/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors.patchItemHandlers;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchEditorVersion;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.patchItemHandlers.FrontendEditorPatchItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchEditorVersion;", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "FrontendEditorPatchItemHandler", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "update", "", "getActualVersion", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "G", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "apply", "item", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorPatchItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorPatchItemHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n69#2,4:68\n*S KotlinDebug\n*F\n+ 1 FrontendEditorPatchItemHandler.kt\ncom/jetbrains/rdclient/editors/patchItemHandlers/FrontendEditorPatchItemHandler\n*L\n33#1:68,4\n*E\n"})
public final class FrontendEditorPatchItemHandler
implements FrontendRdPatchItemHandler<RdPatchEditorVersion, RdPatchItem> {
    @Override
    public boolean validate(@NotNull RdPatchEditorVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdEditorVersion rdEditorVersion = version.getVersion();
        Object object = this.G(version);
        if (object == null || (object = object.getVersion()) == null) {
            return true;
        }
        Object object2 = object;
        if (!Intrinsics.areEqual((Object)object2, (Object)rdEditorVersion)) {
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + ", actual: " + (RdAbstractEditorVersion)object2 + ", expected: " + rdEditorVersion);
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchEditorVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = FrontendEditorPatchItemHandlerKt.access$getLogger$p();
            boolean bl = false;
            if (object.isTraceEnabled()) {
                Logger logger = object;
                boolean bl2 = false;
                logger.trace("Update editor version: " + version.getVersion() + " for operation " + context.getOperation());
            }
            object = context.getOperation();
            if (!(object instanceof PatchItemOperationType.Rollback) && !(object instanceof PatchItemOperationType.SoftRollback) && !(object instanceof PatchItemOperationType.Merge)) break block2;
            EditorSynchronizer editorSynchronizer = this.G(version);
            if (editorSynchronizer != null) {
                editorSynchronizer.resetVersion(version.getVersion());
            }
        }
    }

    @Override
    @Nullable
    public RdPatchEditorVersion getActualVersion(@NotNull RdPatchEditorVersion version, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        EditorSynchronizer editorSynchronizer = this.G(version);
        if (editorSynchronizer == null) {
            return null;
        }
        EditorSynchronizer editorSynchronizer2 = editorSynchronizer;
        RdAbstractEditorVersion rdAbstractEditorVersion = editorSynchronizer2.getVersion();
        Intrinsics.checkNotNull((Object)rdAbstractEditorVersion, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdEditorVersion");
        return new RdPatchEditorVersion((RdEditorVersion)rdAbstractEditorVersion, version.getId());
    }

    private final EditorSynchronizer G(RdPatchEditorVersion rdPatchEditorVersion) {
        RdPatchItemId rdPatchItemId = rdPatchEditorVersion.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.TextControlId");
        Editor editor = FrontendTextControlHostKt.toEditorOrNull((TextControlId)rdPatchItemId);
        if (editor == null) {
            FrontendEditorPatchItemHandler frontendEditorPatchItemHandler = this;
            boolean bl = false;
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().warn("There is no editor for " + rdPatchEditorVersion.getId());
            return null;
        }
        Editor editor2 = editor;
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor2);
        if (editorSynchronizer == null) {
            FrontendEditorPatchItemHandler frontendEditorPatchItemHandler = this;
            boolean bl = false;
            FrontendEditorPatchItemHandlerKt.access$getLogger$p().warn("There is no EditorSynchronizer for " + rdPatchEditorVersion.getId());
            return null;
        }
        EditorSynchronizer editorSynchronizer2 = editorSynchronizer;
        return editorSynchronizer2;
    }

    @Override
    public void apply(@NotNull RdPatchItem item, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
    }
}

