/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editors;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.DocumentsOperationModel;
import com.jetbrains.rd.ide.model.DocumentsOperationModel_GeneratedKt;
import com.jetbrains.rd.ide.model.KernelAwareTextControlId;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdProjectId;
import com.jetbrains.rd.ide.model.TextControlExtension;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlLocation;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.platform.client.SessionUtilKt;
import com.jetbrains.rd.platform.util.ReenterabilityKt;
import com.jetbrains.rd.platform.util.idea.EditorKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.RootExtListener;
import com.jetbrains.rd.util.collections.SynchronizedMap;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rd.util.reactive.ViewableMap;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendDocumentHostListener;
import com.jetbrains.rdclient.editors.FrontendEditorExtensionsProvider;
import com.jetbrains.rdclient.editors.FrontendTextControlBindingPolicy;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.editors.FrontendTextControlHostListener;
import com.jetbrains.rdclient.editors.extensionProcessors.TextControlExtensionProcessor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u0000 Y2\u00020\u0001:\u0006YZ[\\]^B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0010J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0014J\u000e\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\rJ\u0010\u0010)\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010*\u001a\u00020#2\u0006\u0010%\u001a\u00020&H\u0014J\u0010\u0010+\u001a\u00020#2\u0006\u0010%\u001a\u00020,H\u0016J:\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u0002052\u0006\u0010(\u001a\u00020\rH\u0014J\u0018\u00106\u001a\u00020#2\u0006\u0010(\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0010H\u0014J\u0010\u00107\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0014J,\u00108\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\u0006\u00109\u001a\u00020 2\b\b\u0002\u0010:\u001a\u00020 H\u0014J \u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010(\u001a\u00020\rH\u0002J+\u0010@\u001a\u0002052\u0006\u0010A\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\r2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020D0CH&\u00a2\u0006\u0002\u0010EJ*\u0010F\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u00102\u0006\u0010.\u001a\u00020/2\u0006\u00109\u001a\u00020 2\u0006\u0010:\u001a\u00020 H\u0014J\u000e\u0010G\u001a\u00020#2\u0006\u0010(\u001a\u00020\rJ\u0010\u0010H\u001a\u00020 2\u0006\u0010(\u001a\u00020\rH\u0016J\u0010\u0010I\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0014J:\u0010J\u001a\u00020#2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00102\u0006\u0010K\u001a\u0002052\u0006\u0010L\u001a\u00020/2\u0006\u0010(\u001a\u00020\rH\u0014JB\u0010M\u001a\u00020N2\u0006\u0010L\u001a\u00020/2\u0006\u0010(\u001a\u00020\r2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00102\u0006\u0010O\u001a\u0002052\u0006\u0010P\u001a\u00020QH&J\u0010\u0010R\u001a\u00020#2\u0006\u0010(\u001a\u00020\rH\u0014J\u0016\u0010S\u001a\u00020#2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020#0UH\u0004J\f\u0010V\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014J\u0014\u0010V\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010<\u001a\u00020=J\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\r0\u0014J\u0012\u0010X\u001a\u0004\u0018\u00010\r2\u0006\u0010!\u001a\u00020\u0010H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\r0\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006_"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "FrontendTextControlHost", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "publisher", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHostListener;", "documentHost", "Lcom/jetbrains/rdclient/document/FrontendDocumentHost;", "currentlyBindingEditor", "Lcom/intellij/openapi/editor/Editor;", "openedEditors", "Lcom/jetbrains/rd/util/reactive/ViewableMap;", "Lcom/jetbrains/rd/ide/model/TextControlId;", "getOpenedEditors", "()Lcom/jetbrains/rd/util/reactive/ViewableMap;", "prevVisibleEditors", "", "recentlyClosedEditors", "", "documentsOperationModel", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "getDocumentsOperationModel", "()Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "editorIsReleasingLock", "Ljava/lang/Object;", "getEditorIsReleasingLock", "()Ljava/lang/Object;", "isRecentlyClosed", "", "textControlId", "beforeRecoveryStarts", "", "editorCreated", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "isEditorClosing", "editor", "G", "editorReleasedImpl", "selectionChanged", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "subscribeForEditor", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "appSession", "actualTextControlId", "textControlToSubscribe", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "storeTextControlReference", "clearTextControlReference", "ensureEditorOpened", "activate", "isViewer", "G", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "createModel", "editorId", "textControlExtensions", "", "Lcom/jetbrains/rd/ide/model/TextControlExtension;", "(Lcom/jetbrains/rd/ide/model/TextControlId;Lcom/intellij/openapi/editor/Editor;[Lcom/jetbrains/rd/ide/model/TextControlExtension;)Lcom/jetbrains/rd/ide/model/TextControlModel;", "createEditor", "bindEditor", "shouldBind", "allowPumpProtocol", "subscribeForTextControlChanges", "textControlModel", "textControlLifetime", "createSynchronizer", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "textControl", "textControlDisposable", "Lcom/intellij/openapi/Disposable;", "onTextControlClosed", "updateFromFrontend", "block", "Lkotlin/Function0;", "getEditorsIds", "getEditors", "getEditor", "Companion", "MyDocumentListener", "MyProtocolListener", "MyEditorFactoryListener", "MyEditorTrackerListener", "MyFileEditorManagerListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 CollectionEx.kt\ncom/jetbrains/rd/util/CollectionExKt\n+ 7 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 8 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,598:1\n69#2,4:599\n69#2,4:618\n69#2,4:646\n69#2,4:650\n69#2,4:654\n69#2,4:697\n69#2,4:701\n11476#3,9:603\n13402#3:612\n13403#3:614\n11485#3:615\n10065#3:634\n10487#3,5:635\n1#4:613\n1#4:625\n1#4:668\n1#4:681\n1#4:694\n1863#5,2:616\n774#5:622\n865#5,2:623\n774#5:626\n865#5,2:627\n1557#5:629\n1628#5,3:630\n1611#5,9:671\n1863#5:680\n1864#5:682\n1620#5:683\n1611#5,9:684\n1863#5:693\n1864#5:695\n1620#5:696\n66#6:633\n67#6,2:644\n37#7:640\n36#7,3:641\n136#8,9:658\n216#8:667\n217#8:669\n145#8:670\n*S KotlinDebug\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost\n*L\n194#1:599,4\n335#1:618,4\n455#1:646,4\n478#1:650,4\n564#1:654,4\n345#1:697,4\n505#1:701,4\n287#1:603,9\n287#1:612\n287#1:614\n287#1:615\n413#1:634\n413#1:635,5\n287#1:613\n583#1:668\n289#1:681\n290#1:694\n329#1:616,2\n397#1:622\n397#1:623,2\n406#1:626\n406#1:627,2\n406#1:629\n406#1:630,3\n289#1:671,9\n289#1:680\n289#1:682\n289#1:683\n290#1:684,9\n290#1:693\n290#1:695\n290#1:696\n411#1:633\n411#1:644,2\n415#1:640\n415#1:641,3\n583#1:658,9\n583#1:667\n583#1:669\n583#1:670\n*E\n"})
public abstract class FrontendTextControlHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientAppSession session;
    @NotNull
    private final FrontendTextControlHostListener publisher;
    @NotNull
    private final FrontendDocumentHost documentHost;
    @Nullable
    private Editor currentlyBindingEditor;
    @NotNull
    private final ViewableMap<TextControlId, Editor> openedEditors;
    @NotNull
    private List<? extends Editor> prevVisibleEditors;
    @NotNull
    private final List<TextControlId> recentlyClosedEditors;
    @NotNull
    private final Object editorIsReleasingLock;
    @NotNull
    private static final Key<TextControlId> textControlIdKey = new Key("TextControlModelIdKey");
    @NotNull
    private static final Key<Boolean> editorClosingKey = new Key("FrontendTextControlHost.editorClosing");
    @NotNull
    private static final Key<EditorSynchronizer> textControlSynchronizerKey = new Key("FrontendEditorSynchronizer");
    @NotNull
    private static final ExtensionPointName<FrontendTextControlBindingPolicy> BINDING_POLICY_EP = ExtensionPointName.Companion.create("com.intellij.rdclient.textControlBindingPolicy");
    @NotNull
    private static final ExtensionPointName<TextControlExtensionProcessor> TEXT_CONTROL_EXTENSION_EP = ExtensionPointName.Companion.create("com.intellij.rdclient.textControlExtensionProcessor");

    public FrontendTextControlHost(@NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        Object object = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendTextControlHostListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        this.publisher = (FrontendTextControlHostListener)object;
        this.documentHost = FrontendDocumentHost.Companion.getInstance(this.session);
        this.openedEditors = new ViewableMap((Map)new SynchronizedMap());
        this.prevVisibleEditors = CollectionsKt.emptyList();
        this.recentlyClosedEditors = new ArrayList();
        this.editorIsReleasingLock = new Object();
    }

    @NotNull
    protected final ClientAppSession getSession() {
        return this.session;
    }

    @NotNull
    protected final ViewableMap<TextControlId, Editor> getOpenedEditors() {
        return this.openedEditors;
    }

    @NotNull
    protected final DocumentsOperationModel getDocumentsOperationModel() {
        return DocumentsOperationModel_GeneratedKt.getDocumentsOperationModel(FrontendSessionsUtilKt.getProtocol(this.session));
    }

    @NotNull
    public final Object getEditorIsReleasingLock() {
        return this.editorIsReleasingLock;
    }

    public final boolean isRecentlyClosed(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        return !((Map)this.openedEditors).containsKey(textControlId) && this.recentlyClosedEditors.contains(textControlId);
    }

    public final void beforeRecoveryStarts() {
        Logger logger = FrontendTextControlHostKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Clear recentlyClosedEditors before recovery starts.");
        }
        this.recentlyClosedEditors.clear();
    }

    protected void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getEditor().getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FrontendDocumentHost.Companion.getInstance(FrontendSessionsUtilKt.getFrontendProjectSession(project2).getAppSession()).ensureProtocolSubscriptionsReady();
        if (!event.getEditor().isDisposed()) {
            WriteIntentReadAction.run(() -> FrontendTextControlHost.G(this, event));
        }
    }

    public final boolean isEditorClosing(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Boolean bl = (Boolean)editor.getUserData(editorClosingKey);
        return bl != null ? bl : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void G(EditorFactoryEvent editorFactoryEvent) {
        FrontendDocumentHost frontendDocumentHost = FrontendDocumentHost.Companion.tryGetInstance(editorFactoryEvent.getEditor().getProject());
        if (frontendDocumentHost == null) {
            return;
        }
        frontendDocumentHost.ensureProtocolSubscriptionsReady();
        Editor editor = editorFactoryEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        editor2.putUserData(editorClosingKey, (Object)true);
        try {
            this.editorReleasedImpl(editorFactoryEvent);
        }
        finally {
            editor2.putUserData(editorClosingKey, null);
        }
    }

    protected void editorReleasedImpl(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            return;
        }
        TextControlId textControlId2 = textControlId;
        FrontendTextControlHostKt.access$getLogger$p().info("Editor released: " + UtilKt.toDebugString(textControlId2));
        IMutableViewableMap<RdDocumentId, RdDocumentModel> iMutableViewableMap = this.getDocumentsOperationModel().getDocuments();
        IMutableViewableMap<TextControlId, TextControlModel> iMutableViewableMap2 = (IMutableViewableMap<TextControlId, TextControlModel>)iMutableViewableMap.get((Object)textControlId2.getDocumentId());
        if (iMutableViewableMap2 == null || (iMutableViewableMap2 = iMutableViewableMap2.getTextControls()) == null) {
            return;
        }
        IMutableViewableMap<TextControlId, TextControlModel> iMutableViewableMap3 = iMutableViewableMap2;
        ReenterabilityKt.noReenter(this.editorIsReleasingLock, (Function0<Unit>)((Function0)() -> FrontendTextControlHost.G(iMutableViewableMap3, textControlId2, this)));
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            FileEditor[] fileEditorArray = event.getManager().getSelectedEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getSelectedEditors(...)");
            Editor editor = (Editor)fileEditorArray;
            boolean bl2 = false;
            Editor editor2 = editor;
            Collection collection = new ArrayList();
            boolean bl3 = false;
            Editor editor3 = editor2;
            boolean bl4 = false;
            int n = ((Object[])editor3).length;
            for (int j = 0; j < n; ++j) {
                Editor editor4;
                Object object;
                Object object2 = object = editor3[j];
                boolean bl5 = false;
                FileEditor fileEditor = (FileEditor)object2;
                boolean bl6 = false;
                TextEditor textEditor = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
                if ((textEditor != null ? textEditor.getEditor() : null) == null) continue;
                editor4 = editor4;
                boolean bl7 = false;
                collection.add(editor4);
            }
            List list2 = (List)collection;
            this.updateFromFrontend((Function0<Unit>)((Function0)() -> FrontendTextControlHost.G(this, list2)));
            FileEditor fileEditor = event.getOldEditor();
            Object object = fileEditor instanceof TextEditor ? (TextEditor)fileEditor : null;
            if (object != null && (object = object.getEditor()) != null && (object = DocumentExKt.getEditorSynchronizer((Editor)object)) != null) {
                object.setFocused(false);
            }
            FileEditor fileEditor2 = event.getNewEditor();
            TextEditor textEditor = fileEditor2 instanceof TextEditor ? (TextEditor)fileEditor2 : null;
            editor2 = textEditor != null ? textEditor.getEditor() : null;
            EditorImpl editorImpl = editor2 instanceof EditorImpl ? (EditorImpl)editor2 : null;
            if (editorImpl == null) {
                return;
            }
            editor = editorImpl;
            boolean bl8 = bl = UIUtil.hasFocus((Component)((Component)editor.getContentComponent())) || ApplicationManager.getApplication().isHeadlessEnvironment();
            if (!bl) break block4;
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
            if (editorSynchronizer != null) {
                editorSynchronizer.setFocused(true);
            }
        }
    }

    protected void subscribeForEditor(@NotNull Lifetime lifetime, @Nullable ClientProjectSession projectSession, @NotNull ClientAppSession appSession, @NotNull TextControlId actualTextControlId, @NotNull TextControlModel textControlToSubscribe, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)actualTextControlId, (String)"actualTextControlId");
        Intrinsics.checkNotNullParameter((Object)((Object)textControlToSubscribe), (String)"textControlToSubscribe");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor.getUserData(textControlIdKey) == null)) {
            boolean bl = false;
            String string = "subscribing on already registered editor";
            throw new IllegalArgumentException(string.toString());
        }
        Object object = TEXT_CONTROL_EXTENSION_EP.getExtensionList();
        boolean bl = false;
        for (Object t : object) {
            TextControlExtensionProcessor textControlExtensionProcessor = (TextControlExtensionProcessor)t;
            boolean bl2 = false;
            textControlExtensionProcessor.process(editor, textControlToSubscribe, this.session, lifetime, actualTextControlId);
        }
        this.storeTextControlReference(editor, actualTextControlId);
        object = FrontendTextControlHostKt.access$getLogger$p();
        bl = false;
        if (object.isTraceEnabled()) {
            Iterable iterable = object;
            boolean bl3 = false;
            iterable.trace("[file] subscribeForEditor: add editor to _openedEditors. textControlId=" + UtilKt.toDebugString(actualTextControlId));
        }
        ((Map)this.openedEditors).put(actualTextControlId, editor);
        object = actualTextControlId.getKind();
        EditorKind editorKind = editor.getEditorKind();
        Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
        if (object != EditorKt.toLocation(editorKind)) {
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            EditorKind editorKind2 = editor.getEditorKind();
            Intrinsics.checkNotNullExpressionValue((Object)editorKind2, (String)"getEditorKind(...)");
            logger.debug("TextControlLocation differs from actual location for editor, expected=" + (TextControlLocation)((Object)object) + ", actual=" + EditorKt.toLocation(editorKind2) + ", editor=" + editor);
        }
        RLifetimeKt.plusAssign((Lifetime)lifetime, () -> FrontendTextControlHost.G(this, actualTextControlId, editor));
        WriteIntentReadAction.run(() -> FrontendTextControlHost.G(this, projectSession, appSession, actualTextControlId, textControlToSubscribe, lifetime, editor));
    }

    protected void storeTextControlReference(@NotNull Editor editor, @NotNull TextControlId actualTextControlId) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)actualTextControlId, (String)"actualTextControlId");
        ClientIdKt.assertClientIdConsistency$default((ClientId)new ClientId(actualTextControlId.getClientId()), (String)"storeTextControlReference.actualTextControlId.clientId", (boolean)false, (int)2, null);
        editor.putUserData(textControlIdKey, (Object)actualTextControlId);
    }

    protected void clearTextControlReference(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.putUserData(textControlIdKey, null);
    }

    @Nullable
    protected Editor ensureEditorOpened(@NotNull TextControlId textControlId, @NotNull Lifetime lifetime, boolean activate, boolean isViewer) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (this.currentlyBindingEditor != null) {
            return this.currentlyBindingEditor;
        }
        RdDocumentId rdDocumentId = textControlId.getDocumentId();
        FrontendTextControlHostKt.access$getLogger$p().info("Trying to open backend textControl on frontend. Document: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId) + ".");
        RdProjectId rdProjectId = textControlId.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        CommandProcessor.getInstance().executeCommand(project, () -> FrontendTextControlHost.G(objectRef, this, textControlId, lifetime, activate, isViewer), "", null);
        if (objectRef.element == null) {
            FrontendTextControlHostKt.access$getLogger$p().warn("Failed to ensure that an editor is opened for Document: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
        }
        return (Editor)objectRef.element;
    }

    public static /* synthetic */ Editor ensureEditorOpened$default(FrontendTextControlHost frontendTextControlHost, TextControlId textControlId, Lifetime lifetime, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: ensureEditorOpened");
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return frontendTextControlHost.ensureEditorOpened(textControlId, lifetime, bl, bl2);
    }

    private final void G(RdDocumentId rdDocumentId, RdDocumentModel rdDocumentModel, Editor editor) {
        block12: {
            boolean bl;
            Object object;
            Object object22;
            if (!(editor.getUserData(textControlIdKey) == null)) {
                boolean bl2 = false;
                String string = "registering already registered editor";
                throw new IllegalArgumentException(string.toString());
            }
            EditorKind editorKind = editor.getEditorKind();
            Intrinsics.checkNotNullExpressionValue((Object)editorKind, (String)"getEditorKind(...)");
            TextControlLocation textControlLocation = EditorKt.toLocation(editorKind);
            EditorId editorId = (EditorId)editor.getUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY());
            if (editorId == null) {
                throw new IllegalStateException(("Editor " + editor + " doesn't have registered kernel ID. Probably it wasn't created by EditorFactory").toString());
            }
            EditorId editorId2 = editorId;
            Object object3 = null;
            Project project = editor.getProject();
            object3 = new KernelAwareTextControlId(editorId2.serializeToString(), rdDocumentId, 1, textControlLocation, ClientId.Companion.getCurrent().getValue(), project != null ? ProjectUtilKt.getRdProjectId(project) : null);
            Object object4 = rdDocumentModel.getTextControls().keySet();
            boolean bl3 = false;
            Iterable iterable = object4;
            Object object5 = new ArrayList();
            boolean bl4 = false;
            for (Object object22 : iterable) {
                object = (TextControlId)object22;
                boolean bl5 = false;
                if (!(!this.openedEditors.containsKey(object))) continue;
                object5.add(object22);
            }
            List list2 = (List)object5;
            if (!list2.isEmpty()) {
                if (!(((Collection)list2).size() == 1)) {
                    bl3 = false;
                    String string = "More than one unbinded textControls";
                    throw new IllegalArgumentException(string.toString());
                }
                object3 = CollectionsKt.single((List)list2);
            } else {
                Iterable iterable2 = rdDocumentModel.getTextControls().keySet();
                boolean bl6 = false;
                object5 = iterable2;
                Collection collection = new ArrayList();
                boolean bl7 = false;
                object22 = object5.iterator();
                while (object22.hasNext()) {
                    object = object22.next();
                    TextControlId textControlId = object;
                    bl = false;
                    if (!(textControlId.getKind() == textControlLocation)) continue;
                    collection.add(object);
                }
                iterable2 = (List)collection;
                bl6 = false;
                object5 = iterable2;
                collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                bl7 = false;
                object22 = object5.iterator();
                while (object22.hasNext()) {
                    object = object22.next();
                    TextControlId textControlId = object;
                    Collection collection2 = collection;
                    bl = false;
                    collection2.add(textControlId.getTabIndex());
                }
                object4 = (List)collection;
                if (!((Collection)object4).isEmpty()) {
                    String string = editorId2.serializeToString();
                    Comparable comparable = CollectionsKt.maxOrNull((Iterable)((Iterable)object4));
                    Intrinsics.checkNotNull((Object)comparable);
                    Project project2 = editor.getProject();
                    object3 = new KernelAwareTextControlId(string, rdDocumentId, ((Number)((Object)comparable)).intValue() + 1, textControlLocation, ClientId.Companion.getCurrent().getValue(), project2 != null ? ProjectUtilKt.getRdProjectId(project2) : null);
                }
            }
            object4 = (Map)rdDocumentModel.getTextControls();
            Object object6 = object3;
            boolean bl8 = false;
            Object object7 = object4.get(object6);
            if (object7 == null) {
                object5 = (TextControlId)object6;
                bl4 = false;
                FrontendTextControlHostKt.access$getLogger$p().debug("Adding textControl to the model. Document: " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId) + " ");
                Object object8 = FrontendEditorExtensionsProvider.Companion.getEP_NAME().getExtensions();
                boolean bl9 = false;
                object = object8;
                Collection collection = new ArrayList();
                bl = false;
                for (TextControlId textControlId : object) {
                    Object object9 = (FrontendEditorExtensionsProvider)((Object)textControlId);
                    boolean bl10 = false;
                    object9 = object9.getExtensions(this.getSession(), editor);
                    CollectionsKt.addAll((Collection)collection, (Iterable)object9);
                }
                object8 = (List)collection;
                bl9 = false;
                object = object8;
                TextControlExtension[] textControlExtensionArray = object.toArray(new TextControlExtension[0]);
                object22 = this.createModel((TextControlId)object5, editor, textControlExtensionArray);
                object = object22;
                boolean bl11 = false;
                ((TextControlModel)((Object)object)).getVisibleRange().set((Object)UtilKt.calculateVisibleRange(editor));
                ((TextControlModel)((Object)object)).getSpaceWidth().set((Object)EditorUtil.getSpaceWidth((int)0, (Editor)editor));
                ((TextControlModel)((Object)object)).isReadonly().set((Object)editor.isViewer());
                ((TextControlModel)((Object)object)).getDoNotSyncState().set((Object)true);
                Object object10 = object8 = object22;
                boolean bl12 = false;
                object4.put(object6, object10);
                object7 = object10;
            }
            object4 = object7;
            object6 = (TextControlModel)((Object)object4);
            bl8 = false;
            EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
            if (editorSynchronizer != null) {
                editorSynchronizer.setVisible(true);
            }
            RdProjectId rdProjectId = ((TextControlId)object3).getProjectId();
            object5 = IdeFocusManager.getInstance((Project)(rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null)).getFocusOwner();
            EditorComponentImpl editorComponentImpl = object5 instanceof EditorComponentImpl ? (EditorComponentImpl)object5 : null;
            bl4 = Intrinsics.areEqual((Object)(editorComponentImpl != null ? editorComponentImpl.getEditor() : null), (Object)editor);
            FrontendTextControlHostKt.access$getLogger$p().trace("Updating focus for " + DocumentExKt.getTextControlId(editor) + ". isFocused = " + bl4);
            EditorSynchronizer editorSynchronizer2 = DocumentExKt.getEditorSynchronizer(editor);
            if (editorSynchronizer2 == null) break block12;
            editorSynchronizer2.setFocused(bl4);
        }
    }

    @NotNull
    public abstract TextControlModel createModel(@NotNull TextControlId var1, @NotNull Editor var2, @NotNull TextControlExtension[] var3);

    @Nullable
    protected Editor createEditor(@NotNull TextControlId textControlId, @NotNull Lifetime lifetime, boolean activate, boolean isViewer) {
        Editor editor;
        Document document;
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        RdDocumentId rdDocumentId = textControlId.getDocumentId();
        DocumentSynchronizer documentSynchronizer = this.documentHost.getSynchronizer(rdDocumentId);
        Object object = document = documentSynchronizer != null ? documentSynchronizer.getDocument() : null;
        if (document == null) {
            FrontendTextControlHostKt.access$getLogger$p().warn("Unable to find a document for " + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId));
            return null;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorKind editorKind = EditorKt.toEditorKind(textControlId.getKind());
        RdProjectId rdProjectId = textControlId.getProjectId();
        Project project = rdProjectId != null ? ProjectUtilKt.toProject(rdProjectId) : null;
        Logger logger = editorFactory.editors(document, project).filter(arg_0 -> FrontendTextControlHost.G(arg_0 -> FrontendTextControlHost.G(textControlId, arg_0), arg_0)).findFirst();
        Intrinsics.checkNotNullExpressionValue(logger, (String)"findFirst(...)");
        Editor editor2 = (Editor)OptionalsKt.getOrNull(logger);
        if (editor2 != null) {
            logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Found existing editor for document with provided textControlId. documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(rdDocumentId) + ", textControlId=" + UtilKt.toDebugString(textControlId));
            }
            return editor2;
        }
        Editor editor3 = editor = editorFactory.createEditor(document, project, editorKind);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)editor3, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        ((EditorEx)editor3).setViewer(isViewer);
        logger = editor;
        lifetime.onTermination(() -> FrontendTextControlHost.G(this, (Editor)logger, textControlId));
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void bindEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Logger logger = FrontendTextControlHostKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Binding editor " + editor + " under " + ClientId.Companion.getCurrent());
        }
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.shouldBind(editor)) {
            return;
        }
        try {
            this.currentlyBindingEditor = editor;
            this.allowPumpProtocol(editor);
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            logger = document;
            RdDocumentId rdDocumentId = this.documentHost.bindDocument((Document)logger);
            DocumentSynchronizer documentSynchronizer = this.documentHost.getSynchronizer(rdDocumentId);
            if (documentSynchronizer == null) {
                FrontendTextControlHostKt.access$getLogger$p().error("No synchronizer for " + rdDocumentId);
                return;
            }
            this.G(rdDocumentId, documentSynchronizer.getModelDocument(), editor);
        }
        finally {
            this.currentlyBindingEditor = null;
        }
    }

    public boolean shouldBind(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = ThreeState.UNSURE;
        BINDING_POLICY_EP.findFirstSafe(arg_0 -> FrontendTextControlHost.b(arg_0 -> FrontendTextControlHost.G(editor, objectRef, arg_0), arg_0));
        if (objectRef.element == ThreeState.UNSURE) {
            FrontendTextControlHostKt.access$getLogger$p().debug("Skipping binding. None of policies explicitly stated the result");
        }
        return objectRef.element == ThreeState.YES;
    }

    protected void allowPumpProtocol(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
    }

    protected void subscribeForTextControlChanges(@Nullable ClientProjectSession projectSession, @NotNull ClientAppSession appSession, @NotNull TextControlId textControlId, @NotNull TextControlModel textControlModel, @NotNull Lifetime textControlLifetime, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        Intrinsics.checkNotNullParameter((Object)((Object)textControlModel), (String)"textControlModel");
        Intrinsics.checkNotNullParameter((Object)textControlLifetime, (String)"textControlLifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        Disposable disposable = LifetimeDisposableExKt.createNestedDisposable((Lifetime)textControlLifetime, (String)("Disposable for lifetime of a model textControl with id: " + textControlId));
        EditorSynchronizer editorSynchronizer = this.createSynchronizer(textControlLifetime, editor, projectSession, appSession, textControlId, textControlModel, disposable);
        editor.putUserData(textControlSynchronizerKey, (Object)editorSynchronizer);
        textControlLifetime.onTermination(() -> FrontendTextControlHost.G(this, editor));
        this.publisher.editorBound(textControlLifetime, appSession, textControlId, textControlModel, editor);
    }

    @NotNull
    public abstract EditorSynchronizer createSynchronizer(@NotNull Lifetime var1, @NotNull Editor var2, @Nullable ClientProjectSession var3, @NotNull ClientAppSession var4, @NotNull TextControlId var5, @NotNull TextControlModel var6, @NotNull Disposable var7);

    protected void onTextControlClosed(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = editor.getUserData(textControlIdKey);
        if (object == null) {
            boolean bl = false;
            String string = "Closing TextControl without editor key";
            throw new IllegalArgumentException(string.toString());
        }
        TextControlId textControlId = (TextControlId)object;
        FrontendTextControlHostKt.access$getLogger$p().info("Closing " + UtilKt.toDebugString(textControlId) + " ...");
        if (this.openedEditors.containsKey((Object)textControlId)) {
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[file] onTextControlClosed: remove editor from _openedEditors. textControlId=" + UtilKt.toDebugString(textControlId));
            }
            this.openedEditors.remove((Object)textControlId);
        }
        editor.putUserData(textControlIdKey, null);
    }

    protected final void updateFromFrontend(@NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ThreadingAssertions.assertEventDispatchThread();
        block.invoke();
    }

    @NotNull
    public final List<TextControlId> getEditorsIds() {
        return CollectionsKt.toList((Iterable)this.openedEditors.keySet());
    }

    @NotNull
    public final List<Editor> getEditorsIds(@NotNull RdDocumentId documentId) {
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Object object = this.documentHost.getSynchronizer(documentId);
        if (object == null || (object = object.getModelDocument()) == null) {
            return CollectionsKt.emptyList();
        }
        Object object2 = object;
        Map map = (Map)((RdDocumentModel)((Object)object2)).getTextControls();
        boolean bl = false;
        Map map2 = map;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        Map map3 = map2;
        boolean bl3 = false;
        Iterator iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Editor editor;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            boolean bl4 = false;
            Map.Entry entry3 = entry2;
            boolean bl5 = false;
            if (this.getEditor((TextControlId)entry3.getKey()) == null) continue;
            boolean bl6 = false;
            collection.add(editor);
        }
        return (List)collection;
    }

    @NotNull
    public final List<Editor> getEditors() {
        return CollectionsKt.toList((Iterable)this.openedEditors.values());
    }

    @Deprecated(message="use toEditor()", replaceWith=@ReplaceWith(expression="textControlId.toEditor()", imports={}))
    @Nullable
    public final Editor getEditor(@NotNull TextControlId textControlId) {
        Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
        return (Editor)this.openedEditors.get((Object)textControlId);
    }

    private static final void G(FrontendTextControlHost frontendTextControlHost, EditorFactoryEvent editorFactoryEvent) {
        Editor editor = editorFactoryEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        frontendTextControlHost.bindEditor(editor);
    }

    private static final Unit G(IMutableViewableMap iMutableViewableMap, TextControlId textControlId, FrontendTextControlHost frontendTextControlHost) {
        TextControlModel textControlModel = (TextControlModel)((Object)iMutableViewableMap.remove((Object)textControlId));
        if (textControlModel != null && iMutableViewableMap.isEmpty()) {
            frontendTextControlHost.documentHost.unregisterDocument(textControlId.getDocumentId());
        }
        return Unit.INSTANCE;
    }

    private static final Unit b(EditorSynchronizer editorSynchronizer) {
        editorSynchronizer.setVisible(false);
        return Unit.INSTANCE;
    }

    private static final Unit G(EditorSynchronizer editorSynchronizer) {
        editorSynchronizer.setVisible(true);
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendTextControlHost frontendTextControlHost, List list2) {
        Object object;
        Object object22;
        Iterable iterable = frontendTextControlHost.prevVisibleEditors;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Iterable<EditorSynchronizer> iterable3 = new ArrayList();
        boolean bl2 = false;
        Iterable iterable4 = iterable2;
        boolean bl3 = false;
        for (Object object22 : iterable4) {
            EditorSynchronizer editorSynchronizer;
            object = object22;
            boolean bl4 = false;
            Editor editor = (Editor)object;
            boolean bl5 = false;
            if ((EditorSynchronizer)editor.getUserData(textControlSynchronizerKey) == null) continue;
            boolean bl6 = false;
            iterable3.add(editorSynchronizer);
        }
        List list3 = (List)iterable3;
        Iterator iterator2 = list2;
        boolean bl7 = false;
        iterable3 = iterator2;
        Collection collection = new ArrayList();
        boolean bl8 = false;
        Iterable<EditorSynchronizer> iterable5 = iterable3;
        boolean bl9 = false;
        object22 = iterable5.iterator();
        while (object22.hasNext()) {
            EditorSynchronizer editorSynchronizer;
            Object object3 = object = object22.next();
            boolean bl10 = false;
            Editor editor = (Editor)object3;
            boolean bl11 = false;
            if ((EditorSynchronizer)editor.getUserData(textControlSynchronizerKey) == null) continue;
            boolean bl12 = false;
            collection.add(editorSynchronizer);
        }
        iterable = (List)collection;
        for (EditorSynchronizer editorSynchronizer : list3) {
            if (iterable.contains(editorSynchronizer)) continue;
            ClientId.Companion.withExplicitClientId(new ClientId(editorSynchronizer.getTextControlId().getClientId()), () -> FrontendTextControlHost.b(editorSynchronizer));
        }
        for (EditorSynchronizer editorSynchronizer : iterable) {
            ClientId.Companion.withExplicitClientId(new ClientId(editorSynchronizer.getTextControlId().getClientId()), () -> FrontendTextControlHost.G(editorSynchronizer));
        }
        frontendTextControlHost.prevVisibleEditors = list2;
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendTextControlHost frontendTextControlHost, TextControlId textControlId, Editor editor) {
        Logger logger = FrontendTextControlHostKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("[file] subscribeForEditor$onSomeLifetimeTermination: remove editor from _openedEditors. textControlId=" + UtilKt.toDebugString(textControlId));
        }
        frontendTextControlHost.openedEditors.remove((Object)textControlId);
        frontendTextControlHost.clearTextControlReference(editor);
        return Unit.INSTANCE;
    }

    private static final void G(FrontendTextControlHost frontendTextControlHost, ClientProjectSession clientProjectSession, ClientAppSession clientAppSession, TextControlId textControlId, TextControlModel textControlModel, Lifetime lifetime, Editor editor) {
        frontendTextControlHost.subscribeForTextControlChanges(clientProjectSession, clientAppSession, textControlId, textControlModel, lifetime, editor);
    }

    private static final void G(Ref.ObjectRef objectRef, FrontendTextControlHost frontendTextControlHost, TextControlId textControlId, Lifetime lifetime, boolean bl, boolean bl2) {
        block1: {
            objectRef.element = frontendTextControlHost.createEditor(textControlId, lifetime, bl, bl2);
            if (!(textControlId instanceof KernelAwareTextControlId)) break block1;
            Editor editor = (Editor)objectRef.element;
            if (editor != null) {
                editor.putUserData(EditorIdKt.getKERNEL_EDITOR_ID_KEY(), (Object)EditorId.Companion.deserializeFromString(((KernelAwareTextControlId)textControlId).getKernelEditorId()));
            }
        }
    }

    private static final boolean G(TextControlId textControlId, Editor editor) {
        Intrinsics.checkNotNull((Object)editor);
        return Intrinsics.areEqual((Object)DocumentExKt.getTextControlId(editor), (Object)textControlId);
    }

    private static final boolean G(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final Unit G(Editor editor, TextControlId textControlId) {
        if (!editor.isDisposed()) {
            FrontendTextControlHostKt.access$getLogger$p().info("Releasing editor: " + UtilKt.toDebugString(textControlId));
            EditorFactory.getInstance().releaseEditor(editor);
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(FrontendTextControlHost frontendTextControlHost, Editor editor, TextControlId textControlId) {
        ReenterabilityKt.noReenter(frontendTextControlHost.editorIsReleasingLock, (Function0<Unit>)((Function0)() -> FrontendTextControlHost.G(editor, textControlId)));
        return Unit.INSTANCE;
    }

    private static final boolean G(Editor editor, Ref.ObjectRef objectRef, FrontendTextControlBindingPolicy frontendTextControlBindingPolicy) {
        Intrinsics.checkNotNullParameter((Object)frontendTextControlBindingPolicy, (String)"it");
        ThreeState threeState = frontendTextControlBindingPolicy.shouldBind(editor);
        Logger logger = FrontendTextControlHostKt.access$getLogger$p();
        boolean bl = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl2 = false;
            logger2.trace("Policy " + frontendTextControlBindingPolicy.getClass().getSimpleName() + " returned " + threeState);
        }
        if (threeState != ThreeState.UNSURE) {
            objectRef.element = threeState;
            return true;
        }
        return false;
    }

    private static final boolean b(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    private static final Unit G(FrontendTextControlHost frontendTextControlHost, Editor editor) {
        frontendTextControlHost.onTextControlClosed(editor);
        editor.putUserData(textControlSynchronizerKey, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$Companion;", "", "FrontendTextControlHost$Companion", "()V", "textControlIdKey", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/ide/model/TextControlId;", "getTextControlIdKey", "()Lcom/intellij/openapi/util/Key;", "editorClosingKey", "", "textControlSynchronizerKey", "Lcom/jetbrains/rd/ide/editor/EditorSynchronizer;", "getTextControlSynchronizerKey", "BINDING_POLICY_EP", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rdclient/editors/FrontendTextControlBindingPolicy;", "getBINDING_POLICY_EP", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "TEXT_CONTROL_EXTENSION_EP", "Lcom/jetbrains/rdclient/editors/extensionProcessors/TextControlExtensionProcessor;", "getTEXT_CONTROL_EXTENSION_EP", "tryGetInstance", "Lcom/jetbrains/rdclient/editors/FrontendTextControlHost;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,598:1\n51#2:599\n31#2,2:600\n*S KotlinDebug\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$Companion\n*L\n112#1:599\n122#1:600,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<TextControlId> getTextControlIdKey() {
            return textControlIdKey;
        }

        @NotNull
        public final Key<EditorSynchronizer> getTextControlSynchronizerKey() {
            return textControlSynchronizerKey;
        }

        @NotNull
        public final ExtensionPointName<FrontendTextControlBindingPolicy> getBINDING_POLICY_EP() {
            return BINDING_POLICY_EP;
        }

        @NotNull
        public final ExtensionPointName<TextControlExtensionProcessor> getTEXT_CONTROL_EXTENSION_EP() {
            return TEXT_CONTROL_EXTENSION_EP;
        }

        @Deprecated(message="Use an overload with client session")
        @ApiStatus.Internal
        @Nullable
        public final FrontendTextControlHost tryGetInstance(@Nullable Project project) {
            if (project == null || project.isDisposed()) {
                return null;
            }
            ClientProjectSession clientProjectSession = FrontendSessionsUtilKt.getFrontendProjectSessionOrNull(project);
            if (clientProjectSession == null) {
                return null;
            }
            ClientProjectSession clientProjectSession2 = clientProjectSession;
            ComponentManager componentManager = (ComponentManager)clientProjectSession2.getAppSession();
            boolean bl = false;
            return (FrontendTextControlHost)componentManager.getService(FrontendTextControlHost.class);
        }

        @Deprecated(message="Use an overload with client session")
        @ApiStatus.Internal
        @NotNull
        public final FrontendTextControlHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ClientProjectSession clientProjectSession = FrontendSessionsUtilKt.getFrontendProjectSession(project);
            return this.getInstance(clientProjectSession.getAppSession());
        }

        @NotNull
        public final FrontendTextControlHost getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<FrontendTextControlHost> clazz = FrontendTextControlHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (FrontendTextControlHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$MyDocumentListener;", "Lcom/jetbrains/rdclient/document/FrontendDocumentHostListener;", "FrontendTextControlHost$MyDocumentListener", "()V", "documentBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyDocumentListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,598:1\n69#2,4:599\n69#2,4:603\n69#2,4:607\n69#2,4:611\n*S KotlinDebug\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyDocumentListener\n*L\n150#1:599,4\n166#1:603,4\n153#1:607,4\n162#1:611,4\n*E\n"})
    public static final class MyDocumentListener
    implements FrontendDocumentHostListener {
        @Override
        public void documentBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
            Intrinsics.checkNotNullParameter((Object)((Object)documentModel), (String)"documentModel");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            FrontendTextControlHost frontendTextControlHost = Companion.getInstance(session);
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[file] MyDocumentListener$documentBound: Got new document. Advise on `textControls` map. documentId=" + com.jetbrains.rd.ide.document.DocumentExKt.toDebugString(documentId));
            }
            documentModel.getTextControls().view(lifetime, (arg_0, arg_1, arg_2) -> MyDocumentListener.G(frontendTextControlHost, session, arg_0, arg_1, arg_2));
        }

        private static final Unit G(FrontendTextControlHost frontendTextControlHost, TextControlId textControlId) {
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[file] textControl lifetime is terminating. Moving `textControlId` to `recentlyClosedEditors`. textControlId=" + UtilKt.toDebugString(textControlId));
            }
            frontendTextControlHost.recentlyClosedEditors.add(textControlId);
            return Unit.INSTANCE;
        }

        private static final Unit G(FrontendTextControlHost frontendTextControlHost, ClientAppSession clientAppSession, Lifetime lifetime, TextControlId textControlId, TextControlModel textControlModel) {
            Logger logger;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"textControlLifetime");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)((Object)textControlModel), (String)"textControlModel");
            Logger logger2 = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger2.isTraceEnabled()) {
                logger = logger2;
                boolean bl2 = false;
                logger.trace("[file] MyDocumentListener$documentBound$textControls.view: Got new textControl. textControlId=" + UtilKt.toDebugString(textControlId));
            }
            try {
                Boolean bl3 = textControlModel.getFocusOnCreation();
                boolean bl4 = bl3 != null ? bl3 : false;
                Boolean bl5 = (Boolean)textControlModel.isReadonly().getValueOrNull();
                bl = bl5 != null ? bl5 : false;
                Editor editor = frontendTextControlHost.ensureEditorOpened(textControlId, lifetime, bl4, bl);
                if (editor == null) {
                    return Unit.INSTANCE;
                }
                Editor editor2 = editor;
                ClientProjectSession clientProjectSession = SessionUtilKt.getProjectSession(clientAppSession, textControlId.getProjectId());
                frontendTextControlHost.publisher.beforeEditorBound(lifetime, clientAppSession, textControlId, textControlModel, editor2);
                Logger logger3 = FrontendTextControlHostKt.access$getLogger$p();
                boolean bl6 = false;
                if (logger3.isTraceEnabled()) {
                    logger = logger3;
                    boolean bl7 = false;
                    logger.trace("[file] MyDocumentListener$documentBound$textControls.view: Call subscribeForEditor(...)");
                }
                frontendTextControlHost.subscribeForEditor(lifetime, clientProjectSession, clientAppSession, textControlId, textControlModel, editor2);
                lifetime.onTermination(() -> MyDocumentListener.G(frontendTextControlHost, textControlId));
            }
            catch (Throwable throwable) {
                FrontendTextControlHostKt.access$getLogger$p().error(throwable);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "FrontendTextControlHost$MyEditorFactoryListener", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "intellij.rd.client"})
    public static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FrontendTextControlHost frontendTextControlHost = Companion.tryGetInstance(event.getEditor().getProject());
                if (frontendTextControlHost == null) break block0;
                frontendTextControlHost.editorCreated(event);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                FrontendTextControlHost frontendTextControlHost = Companion.tryGetInstance(event.getEditor().getProject());
                if (frontendTextControlHost == null) break block0;
                frontendTextControlHost.G(event);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$MyEditorTrackerListener;", "Lcom/intellij/codeInsight/daemon/impl/EditorTrackerListener;", "project", "Lcom/intellij/openapi/project/Project;", "FrontendTextControlHost$MyEditorTrackerListener", "(Lcom/intellij/openapi/project/Project;)V", "activeEditorsChanged", "", "activeEditors", "", "Lcom/intellij/openapi/editor/Editor;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyEditorTrackerListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,598:1\n69#2,4:599\n*S KotlinDebug\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyEditorTrackerListener\n*L\n223#1:599,4\n*E\n"})
    public static final class MyEditorTrackerListener
    implements EditorTrackerListener {
        @NotNull
        private final Project project;

        public MyEditorTrackerListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void activeEditorsChanged(@NotNull List<? extends Editor> activeEditors) {
            Intrinsics.checkNotNullParameter(activeEditors, (String)"activeEditors");
            FrontendTextControlHost frontendTextControlHost = Companion.tryGetInstance(this.project);
            if (frontendTextControlHost == null) {
                return;
            }
            FrontendTextControlHost frontendTextControlHost2 = frontendTextControlHost;
            frontendTextControlHost2.updateFromFrontend((Function0<Unit>)((Function0)() -> MyEditorTrackerListener.G(frontendTextControlHost2, activeEditors)));
        }

        private static final Unit G(EditorSynchronizer editorSynchronizer, boolean bl, boolean bl2) {
            editorSynchronizer.setVisible(bl || bl2);
            return Unit.INSTANCE;
        }

        private static final Unit G(FrontendTextControlHost frontendTextControlHost, List list2) {
            for (Editor editor : frontendTextControlHost.getOpenedEditors().values()) {
                EditorSynchronizer editorSynchronizer;
                if (DocumentExKt.getEditorSynchronizer(editor) == null) continue;
                boolean bl = list2.contains(editor);
                boolean bl2 = UIUtil.isShowing((Component)editor.getContentComponent());
                Logger logger = FrontendTextControlHostKt.access$getLogger$p();
                boolean bl3 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl4 = false;
                    logger2.trace("activeEditorsChanged: " + editor + " isActive=" + bl + ", isShowing=" + bl2);
                }
                ClientId.Companion.withExplicitClientId(new ClientId(editorSynchronizer.getTextControlId().getClientId()), () -> MyEditorTrackerListener.G(editorSynchronizer, bl, bl2));
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$MyFileEditorManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "FrontendTextControlHost$MyFileEditorManagerListener", "()V", "selectionChanged", "", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "intellij.rd.client"})
    public static final class MyFileEditorManagerListener
    implements FileEditorManagerListener {
        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            ClientId.Companion.withClientId(ClientId.Companion.getCurrent(), () -> MyFileEditorManagerListener.G(event));
        }

        private static final Unit G(FileEditorManagerEvent fileEditorManagerEvent) {
            Project project = fileEditorManagerEvent.getManager().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Companion.getInstance(project).selectionChanged(fileEditorManagerEvent);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdclient/editors/FrontendTextControlHost$MyProtocolListener;", "Lcom/jetbrains/rd/protocol/RootExtListener;", "Lcom/jetbrains/rd/ide/model/DocumentsOperationModel;", "FrontendTextControlHost$MyProtocolListener", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "model", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendTextControlHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,598:1\n69#2,4:599\n69#2,4:603\n*S KotlinDebug\n*F\n+ 1 FrontendTextControlHost.kt\ncom/jetbrains/rdclient/editors/FrontendTextControlHost$MyProtocolListener\n*L\n179#1:599,4\n182#1:603,4\n*E\n"})
    public static final class MyProtocolListener
    implements RootExtListener<DocumentsOperationModel> {
        @Override
        public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull DocumentsOperationModel model) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("[service] MyProtocolListener$extensionCreated: subscribe on `hostReleasedEditor` model");
            }
            model.getHostReleasedEditor().advise(lifetime, arg_0 -> MyProtocolListener.G(session, arg_0));
        }

        private static final Unit G(ClientAppSession clientAppSession, TextControlId textControlId) {
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"it");
            Logger logger = FrontendTextControlHostKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("textControl was released on host. Remove it's id from recentlyClosedEditors: textControlId=" + textControlId + " ");
            }
            Companion.getInstance(clientAppSession).recentlyClosedEditors.remove(textControlId);
            return Unit.INSTANCE;
        }
    }
}

