/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.jetbrains.rd.ide.model.RdCallEditorActionRequest;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdRequest;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionRequest;
import com.jetbrains.rdclient.editors.FrontendTextControlHostKt;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResult;
import com.jetbrains.rdclient.requests.FrontendRebaseSession;
import com.jetbrains.rdclient.services.AppLevelIdeBackend;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\bH\u0014J\b\u0010 \u001a\u00020!H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestWithImmediateResult;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionRequest;", "patch", "Lcom/jetbrains/rd/ide/model/RdPatch;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "resetUndoHistoryToken", "Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;", "info", "Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "FrontendCallEditorActionRequest", "(Lcom/jetbrains/rd/ide/model/RdPatch;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/command/impl/ResetUndoHistoryToken;Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;)V", "getEditorId", "()Lcom/jetbrains/rd/ide/model/TextControlId;", "getFrontendActionId", "()Ljava/lang/String;", "getInfo", "()Lcom/jetbrains/rdclient/editorActions/cwm/EditorActionCommandInfo;", "isBatchingAllowed", "", "()Z", "redo", "rebaseSession", "Lcom/jetbrains/rdclient/requests/FrontendRebaseSession;", "createModel", "Lcom/jetbrains/rd/ide/model/RdRequest;", "debugDescription", "assertClientId", "", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCallEditorActionRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,110:1\n47#2,8:111\n55#2,2:124\n57#2,6:127\n63#2,2:134\n59#3:119\n37#3,2:120\n84#3,2:122\n86#3:126\n25#3:133\n*S KotlinDebug\n*F\n+ 1 FrontendCallEditorActionRequest.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendCallEditorActionRequest\n*L\n74#1:111,8\n74#1:124,2\n74#1:127,6\n74#1:134,2\n74#1:119\n74#1:120,2\n74#1:122,2\n74#1:126\n74#1:133\n*E\n"})
public class FrontendCallEditorActionRequest
extends FrontendAsyncRequestWithImmediateResult
implements FrontendEditorActionRequest {
    @NotNull
    private final TextControlId editorId;
    @NotNull
    private final String frontendActionId;
    @Nullable
    private final EditorActionCommandInfo info;

    public FrontendCallEditorActionRequest(@NotNull RdPatch patch, @NotNull TextControlId editorId, @NotNull String frontendActionId, @NotNull ClientAppSession session, @Nullable ResetUndoHistoryToken resetUndoHistoryToken, @Nullable EditorActionCommandInfo info2) {
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Intrinsics.checkNotNullParameter((Object)editorId, (String)"editorId");
        Intrinsics.checkNotNullParameter((Object)frontendActionId, (String)"frontendActionId");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, patch, resetUndoHistoryToken);
        this.editorId = editorId;
        this.frontendActionId = frontendActionId;
        this.info = info2;
    }

    @Override
    @NotNull
    public TextControlId getEditorId() {
        return this.editorId;
    }

    @NotNull
    public final String getFrontendActionId() {
        return this.frontendActionId;
    }

    @Override
    @Nullable
    public EditorActionCommandInfo getInfo() {
        return this.info;
    }

    @Override
    public boolean isBatchingAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean redo(@NotNull FrontendRebaseSession rebaseSession) {
        RdPatch rdPatch;
        Intrinsics.checkNotNullParameter((Object)rebaseSession, (String)"rebaseSession");
        Object object = FrontendTextControlHostKt.toEditorOrNull(this.getEditorId());
        EditorImpl editorImpl = object instanceof EditorImpl ? (EditorImpl)object : null;
        if (editorImpl == null) {
            return false;
        }
        EditorImpl editorImpl2 = editorImpl;
        ResetUndoHistoryToken resetUndoHistoryToken = this.getResetUndoHistoryToken();
        if (resetUndoHistoryToken != null) {
            resetUndoHistoryToken.refresh();
        }
        object = FrontendPatchEngineKt.getEngine(this.getSession());
        String string = "Redoing call editor action " + this.frontendActionId;
        boolean bl = false;
        object.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
        if (object.getHasActivePatch()) {
            rdPatch = null;
        } else {
            try {
                RdPatch rdPatch2;
                AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default((PatchEngine)object, false, string, null, 4, null));
                Throwable throwable = null;
                try {
                    Object object2;
                    RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Logger logger = MethodHandles.lookup().lookupClass();
                    Logger logger2 = Logger.getInstance(logger);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                    Logger logger3 = logger2;
                    bl4 = false;
                    logger = logger3;
                    try {
                        object2 = logger;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
                        boolean bl7 = false;
                        ActionManager actionManager = ActionManager.getInstance();
                        AnAction anAction = actionManager.getAction(this.frontendActionId);
                        if (anAction == null) {
                            throw new IllegalStateException(("Not found action id: " + this.frontendActionId).toString());
                        }
                        AnAction anAction2 = anAction;
                        DataContext dataContext = editorImpl2.getDataContext();
                        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
                        DataContext dataContext2 = dataContext;
                        AnActionEvent anActionEvent = AnActionEvent.createFromAnAction((AnAction)anAction2, null, (String)"keyboard shortcut", (DataContext)dataContext2);
                        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromAnAction(...)");
                        AnActionEvent anActionEvent2 = anActionEvent;
                        ActionUtil.performActionDumbAwareWithCallbacks((AnAction)anAction2, (AnActionEvent)anActionEvent2);
                        object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable throwable2) {
                        object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    LoggerKt.getOrLogException((Object)object2, (Logger)logger3);
                    rdPatch2 = changeAccumulatingSessionToken.getSession().getPatch();
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                        throw throwable4;
                    }
                }
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                RdPatch rdPatch3 = rdPatch2;
                rdPatch = rdPatch3;
            }
            finally {
                if (object.getHasActivePatch()) {
                    Object object3 = object;
                    boolean bl8 = false;
                    Logger logger = Logger.getInstance(PatchEngine.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                    while (object.getHasActivePatch()) {
                        object.closeCurrentSession("Wrong dispose ordering: " + string);
                    }
                }
            }
        }
        RdPatch rdPatch4 = rdPatch;
        return this.updatePatchAfterRedo(rdPatch4) != null || this.getStatus().isExecuting();
    }

    @Override
    @NotNull
    public RdRequest createModel() {
        String string = AppLevelIdeBackend.Companion.getInstance().getBackendActionId(this.frontendActionId);
        return new RdCallEditorActionRequest(string, this.getEditorId(), this.getPatch());
    }

    @Override
    @NotNull
    protected String debugDescription() {
        return "Call editor action=" + this.frontendActionId + " Patch: " + IPrintableKt.printToString((Object)this.getPatch());
    }

    @Override
    public void assertClientId() {
        ClientIdKt.assertClientIdConsistency$default((ClientId)new ClientId(this.getEditorId().getClientId()), (String)(this.debugDescription() + "::" + this.getEditorId().getDocumentId()), (boolean)false, (int)2, null);
    }
}

