/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.editorActions.cwm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.command.impl.ResetUndoHistoryToken;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.editor.TextControlModelExKt;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.ide.requests.ChangeScope;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.actions.base.ActionContinuation;
import com.jetbrains.rdclient.actions.base.ActionContinuationHolder;
import com.jetbrains.rdclient.actions.base.BackendActionDelegationKt;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListener;
import com.jetbrains.rdclient.actions.base.FrontendActionExecutionListenerKt;
import com.jetbrains.rdclient.actions.base.FrontendActionUpdateTrait;
import com.jetbrains.rdclient.actions.cwm.FrontendAsyncActionHost;
import com.jetbrains.rdclient.client.FrontendSessionsUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.editorActions.cwm.EditorActionCommandInfo;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandler;
import com.jetbrains.rdclient.editorActions.cwm.FrontendAsyncEditorActionHandlerKt;
import com.jetbrains.rdclient.editorActions.cwm.FrontendCallEditorActionRequest;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import com.jetbrains.rdclient.editorActions.cwm.PhantomCallEditorActionRequest;
import com.jetbrains.rdclient.patches.FrontendPatchEngineKt;
import com.jetbrains.rdclient.patches.PatchEngineRegistryKt;
import com.jetbrains.rdclient.requests.FrontendApplyPatchRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestExecutor;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestWithImmediateResultKt;
import com.jetbrains.rdclient.requests.FrontendSpeculativeRequestRecordingListener;
import com.jetbrains.rdclient.services.RdActionsSupport;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0003\u001b\u001c\u001dB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J*\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0007H\u0002J*\u0010\u0019\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler;", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "Lcom/jetbrains/rdclient/actions/base/FrontendActionUpdateTrait;", "frontendId", "", "baseHandler", "backendDeclaredStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "FrontendAsyncEditorActionHandler", "(Ljava/lang/String;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;)V", "getBackendDeclaredStrategy", "()Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "getCallStrategy", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "G", "", "isEnabledForCaret", "doExecute", "", "strategy", "G", "tryFrontend", "CallEditorActionRequestFactory", "LocalCallEditorActionRequestFactory", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n+ 2 Logger.kt\ncom/jetbrains/rd/util/LoggerKt\n+ 3 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,291:1\n107#2:292\n98#2,4:293\n103#2:297\n98#2,4:298\n106#2:327\n98#2,4:328\n47#3,8:302\n55#3,2:315\n57#3,6:318\n63#3,2:325\n59#4:310\n37#4,2:311\n84#4,2:313\n86#4:317\n25#4:324\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler\n*L\n114#1:292\n114#1:293,4\n118#1:297\n118#1:298,4\n171#1:327\n171#1:328,4\n146#1:302,8\n146#1:315,2\n146#1:318,6\n146#1:325,2\n146#1:310\n146#1:311,2\n146#1:313,2\n146#1:317\n146#1:324\n*E\n"})
public final class FrontendAsyncEditorActionHandler
extends EditorActionHandler
implements FrontendActionUpdateTrait {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String frontendId;
    @NotNull
    private final EditorActionHandler baseHandler;
    @NotNull
    private final ActionCallStrategyKind backendDeclaredStrategy;
    @NotNull
    private static final Set<String> TRAVERSAL_ACTIONS_IDS;
    private static boolean isExecuting;

    public FrontendAsyncEditorActionHandler(@NotNull String frontendId, @NotNull EditorActionHandler baseHandler, @NotNull ActionCallStrategyKind backendDeclaredStrategy) {
        Intrinsics.checkNotNullParameter((Object)frontendId, (String)"frontendId");
        Intrinsics.checkNotNullParameter((Object)baseHandler, (String)"baseHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)backendDeclaredStrategy), (String)"backendDeclaredStrategy");
        this.frontendId = frontendId;
        this.baseHandler = baseHandler;
        this.backendDeclaredStrategy = backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getBackendDeclaredStrategy() {
        return this.backendDeclaredStrategy;
    }

    @NotNull
    public final ActionCallStrategyKind getCallStrategy(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        ActionCallStrategyKind actionCallStrategyKind = Companion.getCallStrategy(this.frontendId, editor, caret, dataContext);
        if (actionCallStrategyKind == null) {
            actionCallStrategyKind = this.backendDeclaredStrategy;
        }
        return actionCallStrategyKind;
    }

    private final boolean G(Editor editor, DataContext dataContext) {
        return DocumentExKt.getTextControlId(editor) != null && FrontendActionUpdateTrait.super.frontendUpdate(this.frontendId, dataContext, null, "unknown", null);
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        if (DocumentExKt.getTextControlId(editor) == null) {
            return this.baseHandler.isEnabled(editor, caret, dataContext);
        }
        ActionCallStrategyKind actionCallStrategyKind = this.getCallStrategy(editor, caret, dataContext);
        switch (WhenMappings.$EnumSwitchMapping$0[actionCallStrategyKind.ordinal()]) {
            case 1: 
            case 2: {
                return this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 3: {
                return this.baseHandler.isEnabled(editor, caret, dataContext) && this.G(editor, dataContext);
            }
            case 4: {
                return this.G(editor, dataContext) || this.baseHandler.isEnabled(editor, caret, dataContext);
            }
            case 5: {
                Boolean bl = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                return Intrinsics.areEqual((Object)bl, (Object)true);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!PatchEngineRegistryKt.isPatchEngineEnabled()) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        ThreadingAssertions.assertEventDispatchThread();
        ActionCallStrategyKind actionCallStrategyKind = this.getCallStrategy(editor, caret, dataContext);
        if (isExecuting) {
            if (actionCallStrategyKind == ActionCallStrategyKind.FrontendOnly || actionCallStrategyKind == ActionCallStrategyKind.FrontendFirst) {
                if (this.baseHandler.isEnabled(editor, caret, dataContext)) {
                    this.baseHandler.execute(editor, caret, dataContext);
                }
                return;
            }
            Logger logger = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
            boolean bl = false;
            Logger logger2 = logger;
            LogLevel logLevel = LogLevel.Error;
            boolean bl2 = false;
            if (logger2.isEnabled(logLevel)) {
                LogLevel logLevel2 = logLevel;
                Logger logger3 = logger2;
                boolean bl3 = false;
                String string = "Nested action '" + this.frontendId + "' call: FrontendAsyncEditorActionHandler.doExecute";
                logger3.log(logLevel2, (Object)string, null);
            }
            return;
        }
        Logger logger = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
        boolean bl = false;
        Logger logger4 = logger;
        LogLevel logLevel = LogLevel.Trace;
        boolean bl4 = false;
        if (logger4.isEnabled(logLevel)) {
            LogLevel logLevel3 = logLevel;
            Logger logger5 = logger4;
            boolean bl5 = false;
            String string = "For action " + this.frontendId + " selected strategy is " + actionCallStrategyKind;
            logger5.log(logLevel3, (Object)string, null);
        }
        try {
            isExecuting = true;
            this.G(editor, caret, dataContext, actionCallStrategyKind);
        }
        finally {
            isExecuting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void G(Editor editor, Caret caret, DataContext dataContext, ActionCallStrategyKind actionCallStrategyKind) {
        switch (WhenMappings.$EnumSwitchMapping$0[actionCallStrategyKind.ordinal()]) {
            case 1: {
                RdPatch rdPatch;
                ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
                if (clientAppSession == null || FrontendPatchEngineKt.getEngine(clientAppSession).getHasActivePatch()) {
                    FrontendAsyncEditorActionHandler.G(this, editor, caret, dataContext);
                    return;
                }
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
                PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(clientAppSession);
                String string = "Action handler " + this.frontendId;
                boolean bl = false;
                patchEngine.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
                if (patchEngine.getHasActivePatch()) {
                    return;
                }
                try {
                    RdPatch rdPatch2;
                    AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default(patchEngine, false, string, null, 4, null));
                    Throwable throwable = null;
                    try {
                        void var18_32;
                        RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        com.intellij.openapi.diagnostic.Logger logger = MethodHandles.lookup().lookupClass();
                        com.intellij.openapi.diagnostic.Logger logger2 = com.intellij.openapi.diagnostic.Logger.getInstance(logger);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                        com.intellij.openapi.diagnostic.Logger logger3 = logger2;
                        bl4 = false;
                        logger = logger3;
                        try {
                            com.intellij.openapi.diagnostic.Logger logger4 = logger;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
                            boolean bl7 = false;
                            FrontendAsyncEditorActionHandler.G(this, editor, caret, dataContext);
                            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable2) {
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        LoggerKt.getOrLogException((Object)var18_32, (com.intellij.openapi.diagnostic.Logger)logger3);
                        rdPatch2 = changeAccumulatingSessionToken.getSession().getPatch();
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                            throw throwable4;
                        }
                    }
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    RdPatch rdPatch3 = rdPatch2;
                    rdPatch = rdPatch3;
                }
                finally {
                    if (patchEngine.getHasActivePatch()) {
                        PatchEngine patchEngine2 = patchEngine;
                        boolean bl8 = false;
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                        while (patchEngine.getHasActivePatch()) {
                            patchEngine.closeCurrentSession("Wrong dispose ordering: " + string);
                        }
                    }
                }
                RdPatch rdPatch4 = rdPatch;
                if (rdPatch4 == null) return;
                FrontendAsyncRequestExecutor.Companion.getInstance(clientAppSession).submitRequest(new FrontendApplyPatchRequest(rdPatch4, clientAppSession, resetUndoHistoryToken));
                return;
            }
            case 3: {
                this.G(editor, caret, dataContext, true);
                return;
            }
            case 2: 
            case 4: {
                this.G(editor, caret, dataContext, false);
                return;
            }
            case 5: {
                Boolean bl = EditorActionAvailabilityHintKt.isActionAvailableByHint$default((Editor)editor, (int)editor.getCaretModel().getOffset(), (String)this.frontendId, null, (int)4, null);
                if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                    this.G(editor, caret, dataContext, false);
                    return;
                }
                Logger logger = FrontendAsyncEditorActionHandlerKt.access$getLogger$p();
                boolean bl9 = false;
                Logger logger5 = logger;
                LogLevel logLevel = LogLevel.Warn;
                boolean bl10 = false;
                if (!logger5.isEnabled(logLevel)) return;
                LogLevel logLevel2 = logLevel;
                Logger logger6 = logger5;
                boolean bl11 = false;
                String string = "Action '" + this.frontendId + "' is not available by availability hint but still was called for execution. Skipping.";
                logger6.log(logLevel2, (Object)string, null);
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void G(Editor editor, Caret caret, DataContext dataContext, boolean bl) {
        ClientAppSession clientAppSession = FrontendSessionsUtilKt.getFrontendAppSession(dataContext);
        if (clientAppSession == null) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        ClientAppSession clientAppSession2 = clientAppSession;
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        TextControlId textControlId2 = textControlId;
        if (!((Boolean)FrontendSessionsUtilKt.isConnected(clientAppSession2).getValue()).booleanValue() || FrontendPatchEngineKt.getEngine(clientAppSession2).getHasActivePatch()) {
            this.baseHandler.execute(editor, caret, dataContext);
            return;
        }
        Object object = ApplicationKt.getApplication().getMessageBus().syncPublisher(FrontendActionExecutionListener.Companion.getTOPIC());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"syncPublisher(...)");
        FrontendActionExecutionListenerKt.beforeActionExecutedOnBackend((FrontendActionExecutionListener)object, this.frontendId);
        if (bl) {
            Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
            Disposable disposable = ((EditorImpl)editor).getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)disposable);
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)lifetime, null, (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, dataContext, clientAppSession2, textControlId2, caret, null){
                Object L$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ FrontendAsyncEditorActionHandler this$0;
                final /* synthetic */ Editor $editor;
                final /* synthetic */ DataContext $dataContext;
                final /* synthetic */ ClientAppSession $session;
                final /* synthetic */ TextControlId $editorId;
                final /* synthetic */ Caret $caret;
                {
                    this.this$0 = $receiver;
                    this.$editor = $editor;
                    this.$dataContext = $dataContext;
                    this.$session = $session;
                    this.$editorId = $editorId;
                    this.$caret = $caret;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var2_3 = (CoroutineScope)this.L$0;
                            if (FrontendAsyncEditorActionHandler.access$getTRAVERSAL_ACTIONS_IDS$cp().contains(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0))) {
                                v0 = DocumentExKt.getTextControlModel(this.$editor);
                                v1 = v0 != null && (v0 = TextControlModelExKt.getHasTemplateTraversalPolicyExtension((TextControlModel)v0)) != null ? v0.getHasTemplateTraversalPolicy() : false;
                                if (v1) {
                                    v2 = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)this.$dataContext);
                                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"createFromDataContext(...)");
                                    var3_5 = v2;
                                    FrontendAsyncActionHost.Companion.getInstance(this.$session).execute(FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), var3_5);
                                    return Unit.INSTANCE;
                                }
                            }
                            var3_6 = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                            v3 = (ActionContinuationHolder)BackendActionDelegationKt.getBACKEND_ACTION_CONTINUATION_KEY().getData(this.$dataContext);
                            if (v3 != null) {
                                v3.setContinuation(new ActionContinuation((CompletableDeferred<Unit>)var3_6){
                                    final /* synthetic */ CompletableDeferred<Unit> $deferred;
                                    {
                                        this.$deferred = $deferred;
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object await(Continuation<? super Unit> $completion) {
                                        if (!($completion instanceof doExecuteByStrategy.await.1)) ** GOTO lbl-1000
                                        var3_2 = $completion;
                                        if ((var3_2.label & -2147483648) != 0) {
                                            var3_2.label -= -2147483648;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            var3_2 = new ContinuationImpl(this, $completion){
                                                /* synthetic */ Object result;
                                                final /* synthetic */ doExecuteByStrategy.1 this$0;
                                                int label;
                                                {
                                                    this.this$0 = this$0;
                                                    super($completion);
                                                }

                                                public final Object invokeSuspend(Object $result) {
                                                    this.result = $result;
                                                    this.label |= Integer.MIN_VALUE;
                                                    return this.this$0.await((Continuation<? super Unit>)((Continuation)this));
                                                }
                                            };
                                        }
                                        var2_3 = var3_2.result;
                                        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (var3_2.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)var2_3);
                                                var3_2.label = 1;
                                                v0 = this.$deferred.await((Continuation)var3_2);
                                                if (v0 == var4_4) {
                                                    return var4_4;
                                                }
                                                ** GOTO lbl20
                                            }
                                            case 1: {
                                                ResultKt.throwOnFailure((Object)var2_3);
                                                v0 = var2_3;
lbl20:
                                                // 2 sources

                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                });
                            }
                            var5_7 = (ComponentManager)this.$session;
                            var6_8 = false;
                            var7_10 = CallEditorActionRequestFactory.class;
                            v4 = var5_7.getService(var7_10);
                            if (v4 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)var5_7, var7_10);
                            }
                            var4_11 = (CallEditorActionRequestFactory)v4;
                            this.L$0 = var2_3;
                            this.L$1 = var3_6;
                            this.label = 1;
                            v5 = var4_11.createRequest(this.$editor, this.$editorId, FrontendAsyncEditorActionHandler.access$getFrontendId$p(this.this$0), this.$caret, FrontendAsyncEditorActionHandler.access$getBaseHandler$p(this.this$0), this.$dataContext, (Continuation<? super FrontendAsyncRequest>)((Continuation)this));
                            if (v5 == var9_2) {
                                return var9_2;
                            }
                            ** GOTO lbl38
                        }
                        case 1: {
                            var3_6 = (CompletableDeferred)this.L$1;
                            var2_4 = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v5 = $result;
lbl38:
                            // 2 sources

                            v6 = (FrontendAsyncRequest)v5;
                            if (v6 == null) {
                                var8_12 = false;
                                var3_6.complete((Object)Unit.INSTANCE);
                                return Unit.INSTANCE;
                            }
                            var5_7 = v6;
                            this.L$0 = var3_6;
                            this.L$1 = null;
                            this.label = 2;
                            v7 = FrontendAsyncRequestExecutor.Companion.getInstance(this.$session).executeRequest(var5_7, (Continuation<? super Unit>)((Continuation)this));
                            ** if (v7 != var9_2) goto lbl54
lbl53:
                            // 1 sources

                            return var9_2;
lbl54:
                            // 1 sources

                            ** GOTO lbl65
                        }
                        case 2: {
                            var3_6 = (CompletableDeferred)this.L$0;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v7 = $result;
                            }
                            catch (CancellationException var6_9) {
                                var3_6.cancel(var6_9);
                                return Unit.INSTANCE;
                            }
lbl65:
                            // 2 sources

                            var3_6.complete((Object)Unit.INSTANCE);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value2;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            AnActionEvent anActionEvent = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)dataContext);
            Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createFromDataContext(...)");
            AnActionEvent anActionEvent2 = anActionEvent;
            FrontendAsyncActionHost.Companion.getInstance(clientAppSession2).execute(this.frontendId, anActionEvent2);
        }
    }

    private static final void G(FrontendAsyncEditorActionHandler frontendAsyncEditorActionHandler, Editor editor, Caret caret, DataContext dataContext) {
        if (frontendAsyncEditorActionHandler.baseHandler.isEnabled(editor, caret, dataContext)) {
            frontendAsyncEditorActionHandler.baseHandler.execute(editor, caret, dataContext);
        }
    }

    public static final /* synthetic */ Set access$getTRAVERSAL_ACTIONS_IDS$cp() {
        return TRAVERSAL_ACTIONS_IDS;
    }

    public static final /* synthetic */ String access$getFrontendId$p(FrontendAsyncEditorActionHandler $this) {
        return $this.frontendId;
    }

    public static final /* synthetic */ EditorActionHandler access$getBaseHandler$p(FrontendAsyncEditorActionHandler $this) {
        return $this.baseHandler;
    }

    static {
        Object[] objectArray = new String[]{"EditorTab", "BraceOrQuoteOut", "EditorUnindentSelection", "EditorIndentSelection"};
        TRAVERSAL_ACTIONS_IDS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001JB\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u00a6@\u00a2\u0006\u0002\u0010\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    public static interface CallEditorActionRequestFactory {
        @Nullable
        public Object createRequest(@NotNull Editor var1, @NotNull TextControlId var2, @NotNull String var3, @Nullable Caret var4, @NotNull EditorActionHandler var5, @NotNull DataContext var6, @NotNull Continuation<? super FrontendAsyncRequest> var7);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$Companion;", "", "FrontendAsyncEditorActionHandler$Companion", "()V", "TRAVERSAL_ACTIONS_IDS", "", "", "value", "", "isExecuting", "()Z", "getCallStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "actionId", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExecuting() {
            return isExecuting;
        }

        @Nullable
        public final ActionCallStrategyKind getCallStrategy(@NotNull String actionId, @NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
            Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
            return (ActionCallStrategyKind)((Object)FrontendEditorActionHandlerStrategyCustomizer.Companion.getEP().computeSafeIfAny(arg_0 -> Companion.G(actionId, editor, caret, dataContext, arg_0)));
        }

        private static final ActionCallStrategyKind G(String string, Editor editor, Caret caret, DataContext dataContext, FrontendEditorActionHandlerStrategyCustomizer frontendEditorActionHandlerStrategyCustomizer) {
            Intrinsics.checkNotNullParameter((Object)frontendEditorActionHandlerStrategyCustomizer, (String)"customizer");
            return frontendEditorActionHandlerStrategyCustomizer.getCustomStrategy(string, editor, caret, dataContext);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JB\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$CallEditorActionRequestFactory;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory", "(Lcom/intellij/openapi/client/ClientAppSession;)V", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "createRequest", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "editor", "Lcom/intellij/openapi/editor/Editor;", "editorId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "frontendActionId", "", "caret", "Lcom/intellij/openapi/editor/Caret;", "baseHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "(Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rd/ide/model/TextControlId;Ljava/lang/String;Lcom/intellij/openapi/editor/Caret;Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;Lcom/intellij/openapi/actionSystem/DataContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendAsyncEditorActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n+ 2 PatchEngine.kt\ncom/jetbrains/rd/ide/requests/PatchEngineKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,291:1\n47#2,8:292\n55#2,2:305\n57#2,6:308\n63#2,2:315\n59#3:300\n37#3,2:301\n84#3,2:303\n86#3:307\n25#3:314\n*S KotlinDebug\n*F\n+ 1 FrontendAsyncEditorActionHandler.kt\ncom/jetbrains/rdclient/editorActions/cwm/FrontendAsyncEditorActionHandler$LocalCallEditorActionRequestFactory\n*L\n248#1:292,8\n248#1:305,2\n248#1:308,6\n248#1:315,2\n248#1:300\n248#1:301,2\n248#1:303,2\n248#1:307\n248#1:314\n*E\n"})
    public static final class LocalCallEditorActionRequestFactory
    implements CallEditorActionRequestFactory {
        @NotNull
        private final ClientAppSession session;

        public LocalCallEditorActionRequestFactory(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        @Override
        @Nullable
        public Object createRequest(@NotNull Editor editor, @NotNull TextControlId editorId, @NotNull String frontendActionId, @Nullable Caret caret, @NotNull EditorActionHandler baseHandler, @NotNull DataContext dataContext, @NotNull Continuation<? super FrontendAsyncRequest> $completion) {
            FrontendAsyncRequestExecutor frontendAsyncRequestExecutor = FrontendAsyncRequestExecutor.Companion.getInstance(this.session);
            if (frontendAsyncRequestExecutor.getSpeculativeExecutionEnabled()) {
                ResetUndoHistoryToken resetUndoHistoryToken = FrontendAsyncRequestWithImmediateResultKt.createResetUndoHistoryToken(editor);
                Pair pair = EditorActionCommandInfo.Companion.capture(() -> LocalCallEditorActionRequestFactory.G(this, frontendActionId, baseHandler, editor, caret, dataContext));
                RdPatch rdPatch = (RdPatch)pair.component1();
                EditorActionCommandInfo editorActionCommandInfo = (EditorActionCommandInfo)pair.component2();
                if (rdPatch == null) {
                    if ((Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorTab") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorIndentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorUnindentSelection") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorEnter") || Intrinsics.areEqual((Object)frontendActionId, (Object)"EditorBackSpace")) && RdActionsSupport.Companion.getInstance().hasBackendAction(frontendActionId)) {
                        return new PhantomCallEditorActionRequest(frontendActionId, editorId, editorActionCommandInfo);
                    }
                    return null;
                }
                return new FrontendCallEditorActionRequest(rdPatch, editorId, frontendActionId, this.session, resetUndoHistoryToken, editorActionCommandInfo);
            }
            return new PhantomCallEditorActionRequest(frontendActionId, editorId, EditorActionCommandInfo.Companion.captureForPhantomRequest());
        }

        private static final Unit G(EditorActionHandler editorActionHandler, Editor editor, Caret caret, DataContext dataContext) {
            editorActionHandler.execute(editor, caret, dataContext);
            return Unit.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final RdPatch G(LocalCallEditorActionRequestFactory localCallEditorActionRequestFactory, String string, EditorActionHandler editorActionHandler, Editor editor, Caret caret, DataContext dataContext) {
            RdPatch rdPatch;
            PatchEngine patchEngine = FrontendPatchEngineKt.getEngine(localCallEditorActionRequestFactory.session);
            String string2 = "Call editor action " + string;
            boolean bl = false;
            patchEngine.softAssertThereIsNoActivePatch("recordChanges must no be called under another patch, because it leads to recording and  sending the same patch multiple times");
            if (patchEngine.getHasActivePatch()) {
                rdPatch = null;
            } else {
                try {
                    RdPatch rdPatch2;
                    AutoCloseable autoCloseable = (AutoCloseable)((Object)PatchEngine.openAccumulatingSession$default(patchEngine, false, string2, null, 4, null));
                    Throwable throwable = null;
                    try {
                        Object object;
                        RdPatchEngine.ChangeAccumulatingSessionToken changeAccumulatingSessionToken = (RdPatchEngine.ChangeAccumulatingSessionToken)((Object)autoCloseable);
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        com.intellij.openapi.diagnostic.Logger logger = MethodHandles.lookup().lookupClass();
                        com.intellij.openapi.diagnostic.Logger logger2 = com.intellij.openapi.diagnostic.Logger.getInstance(logger);
                        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                        com.intellij.openapi.diagnostic.Logger logger3 = logger2;
                        bl4 = false;
                        logger = logger3;
                        try {
                            object = logger;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            ChangeScope changeScope = changeAccumulatingSessionToken.getSession().getChangeScope();
                            boolean bl7 = false;
                            FrontendSpeculativeRequestRecordingListener.Companion.withListener(localCallEditorActionRequestFactory.session, () -> LocalCallEditorActionRequestFactory.G(editorActionHandler, editor, caret, dataContext));
                            object = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable throwable2) {
                            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                        }
                        LoggerKt.getOrLogException((Object)object, (com.intellij.openapi.diagnostic.Logger)logger3);
                        rdPatch2 = changeAccumulatingSessionToken.getSession().getPatch();
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, throwable);
                            throw throwable4;
                        }
                    }
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    RdPatch rdPatch3 = rdPatch2;
                    rdPatch = rdPatch3;
                }
                finally {
                    if (patchEngine.getHasActivePatch()) {
                        PatchEngine patchEngine2 = patchEngine;
                        boolean bl8 = false;
                        com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance(PatchEngine.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("There are unclosed accumulating sessions after recordChanges. Close them forcibly");
                        while (patchEngine.getHasActivePatch()) {
                            patchEngine.closeCurrentSession("Wrong dispose ordering: " + string2);
                        }
                    }
                }
            }
            return rdPatch;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ActionCallStrategyKind.values().length];
            try {
                nArray[ActionCallStrategyKind.FrontendOnly.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWithFrontendUpdate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.FrontendFirst.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.Backend.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ActionCallStrategyKind.BackendWhenAvailableByHint.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

