/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.PatchEngineDocumentSynchronizer;
import com.jetbrains.rd.ide.editor.UtilKt;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdPatchDocumentVersion;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdResetDocumentChange;
import com.jetbrains.rd.util.string.IPrintableKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rdclient.document.FrontendPatchDocumentItemHandlerKt;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchHandlerContext;
import com.jetbrains.rdclient.engine.handlers.FrontendRdPatchItemHandler;
import com.jetbrains.rdclient.requests.PatchItemOperationType;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler;", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchItemHandler;", "Lcom/jetbrains/rd/ide/model/RdPatchDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "FrontendPatchDocumentItemHandler", "()V", "validate", "", "version", "context", "Lcom/jetbrains/rdclient/engine/handlers/FrontendRdPatchHandlerContext;", "update", "", "getActualVersion", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "apply", "item", "G", "Lcom/jetbrains/rd/ide/document/PatchEngineDocumentSynchronizer;", "id", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendPatchDocumentItemHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,107:1\n69#2,4:108\n69#2,4:112\n69#2,4:116\n69#2,4:120\n69#2,4:124\n*S KotlinDebug\n*F\n+ 1 FrontendPatchDocumentItemHandler.kt\ncom/jetbrains/rdclient/document/FrontendPatchDocumentItemHandler\n*L\n29#1:108,4\n49#1:112,4\n53#1:116,4\n95#1:120,4\n101#1:124,4\n*E\n"})
public final class FrontendPatchDocumentItemHandler
implements FrontendRdPatchItemHandler<RdPatchDocumentVersion, RdDocumentChangeBase> {
    @Override
    public boolean validate(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.G((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return true;
        }
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer2 = patchEngineDocumentSynchronizer;
        if (!Intrinsics.areEqual((Object)patchEngineDocumentSynchronizer2.getVersion(), (Object)version.getVersion())) {
            FrontendPatchDocumentItemHandlerKt.access$getLogger$p().error("Not matched versions for " + version.getId() + " documentId, actual: " + patchEngineDocumentSynchronizer2.getVersion() + ", expected: " + version.getVersion());
            return false;
        }
        return true;
    }

    @Override
    public void update(@NotNull RdPatchDocumentVersion version, @NotNull FrontendRdPatchHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Update document version: " + version.getId() + " to " + version.getVersion() + " with operation type " + context.getOperation());
        }
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.G((RdDocumentId)rdPatchItemId, context.getSession());
        if (patchEngineDocumentSynchronizer == null) {
            return;
        }
        object = patchEngineDocumentSynchronizer;
        PatchItemOperationType patchItemOperationType = context.getOperation();
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback || patchItemOperationType instanceof PatchItemOperationType.Rollback) {
            ((PatchEngineDocumentSynchronizer)object).resetVersion(version.getVersion());
        } else if (patchItemOperationType instanceof PatchItemOperationType.Perform || patchItemOperationType instanceof PatchItemOperationType.SoftPerform) {
            ((PatchEngineDocumentSynchronizer)object).updateLastKnownVersion(version.getVersion());
        }
    }

    @Override
    @Nullable
    public RdPatchDocumentVersion getActualVersion(@NotNull RdPatchDocumentVersion version, @NotNull ClientAppSession session) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        RdPatchItemId rdPatchItemId = version.getId();
        Intrinsics.checkNotNull((Object)rdPatchItemId, (String)"null cannot be cast to non-null type com.jetbrains.rd.ide.model.RdDocumentId");
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer = this.G((RdDocumentId)rdPatchItemId, session);
        if (patchEngineDocumentSynchronizer == null) {
            return null;
        }
        PatchEngineDocumentSynchronizer patchEngineDocumentSynchronizer2 = patchEngineDocumentSynchronizer;
        return new RdPatchDocumentVersion(patchEngineDocumentSynchronizer2.getVersion(), version.getId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void apply(@NotNull RdDocumentChangeBase item, @NotNull FrontendRdPatchHandlerContext context) {
        RdDocumentChangeBase rdDocumentChangeBase;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PatchItemOperationType patchItemOperationType = context.getOperation();
        Object object = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl2 = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            bl = false;
            logger.trace("Apply document step: " + IPrintableKt.printToString((Object)item) + " with operation type " + patchItemOperationType);
        }
        object = this.G(item.getDocumentId(), context.getSession());
        if (object == null) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            bl = false;
            if (!logger.isTraceEnabled()) return;
            Logger logger2 = logger;
            boolean bl3 = false;
            logger2.trace("Document synchronizer not found for " + item.getDocumentId() + ": can not apply change: " + IPrintableKt.printToString((Object)item));
            return;
        }
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRollback) {
            return;
        }
        if (patchItemOperationType instanceof PatchItemOperationType.SoftRedo || patchItemOperationType instanceof PatchItemOperationType.SoftPerform) {
            ((PatchEngineDocumentSynchronizer)object).updateDocumentLog(item);
            return;
        }
        PatchItemOperationType patchItemOperationType2 = patchItemOperationType;
        if (Intrinsics.areEqual((Object)patchItemOperationType2, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            var7_14 = item;
            if (var7_14 instanceof RdResetDocumentChange) {
                rdDocumentChangeBase = new RdResetDocumentChange(((RdResetDocumentChange)item).getText(), ((RdResetDocumentChange)item).getPreviousVersion(), ((RdResetDocumentChange)item).getVersion(), item.getDocumentId());
            } else {
                if (!(var7_14 instanceof RdDocumentChange)) throw new IllegalStateException((item.getClass() + " is not supported for revert operation").toString());
                rdDocumentChangeBase = UtilKt.reverse((RdDocumentChange)item);
            }
        } else if (Intrinsics.areEqual((Object)patchItemOperationType2, (Object)PatchItemOperationType.Redo.INSTANCE)) {
            var7_14 = item;
            if (var7_14 instanceof RdResetDocumentChange) {
                rdDocumentChangeBase = item;
            } else {
                boolean bl4;
                if (!(var7_14 instanceof RdDocumentChange)) throw new IllegalStateException((item.getClass() + " is not supported for redo operation").toString());
                RdDocumentChange rdDocumentChange = context.getRebaseSession().replay((RdDocumentChange)item);
                if (rdDocumentChange.getOffset() == -1 || rdDocumentChange.getMoveOffset() == -1 || rdDocumentChange.getOldDocumentLength() == -1) {
                    FrontendPatchDocumentItemHandlerKt.access$getLogger$p().warn("Can't redo change for " + DocumentExKt.toDebugString(item.getDocumentId()) + ": " + IPrintableKt.printToString((Object)item));
                    return;
                }
                boolean bl5 = bl4 = ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength() == rdDocumentChange.getOldDocumentLength();
                if (_Assertions.ENABLED && !bl4) {
                    boolean bl6 = false;
                    String string = "Document length " + ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength() + " does not match with expected change length " + rdDocumentChange.getOldDocumentLength();
                    throw new AssertionError((Object)string);
                }
                rdDocumentChangeBase = rdDocumentChange;
            }
        } else {
            rdDocumentChangeBase = item;
        }
        RdDocumentChangeBase rdDocumentChangeBase2 = rdDocumentChangeBase;
        ((PatchEngineDocumentSynchronizer)object).receiveDocumentChange(rdDocumentChangeBase2, patchItemOperationType instanceof PatchItemOperationType.Redo);
        if (Intrinsics.areEqual((Object)patchItemOperationType, (Object)PatchItemOperationType.Rollback.INSTANCE)) {
            context.getRebaseSession().record(item);
        }
        patchItemOperationType2 = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
        boolean bl7 = false;
        if (!patchItemOperationType2.isTraceEnabled()) return;
        PatchItemOperationType patchItemOperationType3 = patchItemOperationType2;
        boolean bl8 = false;
        patchItemOperationType3.trace("Change " + IPrintableKt.printToString((Object)rdDocumentChangeBase2) + " from operation type " + patchItemOperationType + " was applied. New document length: " + ((PatchEngineDocumentSynchronizer)object).getDocument().getTextLength());
    }

    private final PatchEngineDocumentSynchronizer G(RdDocumentId rdDocumentId, ClientAppSession clientAppSession) {
        FrontendDocumentHost frontendDocumentHost = FrontendDocumentHost.Companion.getInstance(clientAppSession);
        if (frontendDocumentHost.isRecentlyClosed(rdDocumentId)) {
            Logger logger = FrontendPatchDocumentItemHandlerKt.access$getLogger$p();
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Do not promote document version for a recently closed document (it is an expected race case); document: " + rdDocumentId);
            }
            return null;
        }
        DocumentSynchronizer documentSynchronizer = frontendDocumentHost.getSynchronizer(rdDocumentId);
        return documentSynchronizer instanceof PatchEngineDocumentSynchronizer ? (PatchEngineDocumentSynchronizer)documentSynchronizer : null;
    }
}

