/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.diagnostics;

import com.intellij.openapi.client.ClientAppSession;
import com.jetbrains.rd.ide.model.RdFailureResponse;
import com.jetbrains.rd.ide.model.RdResponse;
import com.jetbrains.rd.ide.model.RdRetryResponse;
import com.jetbrains.rd.ide.model.RdSuccessResponse;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.UtilsKt;
import com.jetbrains.rdclient.requests.FrontendAsyncRequest;
import com.jetbrains.rdclient.requests.FrontendAsyncRequestListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016J \u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u000fH\u0002J\u0013\u0010\u0012\u001a\u00020\u0013*\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rdclient/diagnostics/FrontendRequestsLogger;", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequestListener;", "FrontendRequestsLogger", "()V", "requestSubmitted", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "request", "Lcom/jetbrains/rdclient/requests/FrontendAsyncRequest;", "requestsSent", "requests", "", "requestCompleted", "response", "Lcom/jetbrains/rd/ide/model/RdResponse;", "G", "Lcom/jetbrains/rd/tracing/SyncEventsLogger$ResponseType;", "tillNow", "Lkotlin/time/Duration;", "", "G", "(J)J", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendRequestsLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendRequestsLogger.kt\ncom/jetbrains/rdclient/diagnostics/FrontendRequestsLogger\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1863#2,2:53\n*S KotlinDebug\n*F\n+ 1 FrontendRequestsLogger.kt\ncom/jetbrains/rdclient/diagnostics/FrontendRequestsLogger\n*L\n20#1:53,2\n*E\n"})
public final class FrontendRequestsLogger
implements FrontendAsyncRequestListener {
    @Override
    public void requestSubmitted(@NotNull ClientAppSession session, @NotNull FrontendAsyncRequest request) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
    }

    @Override
    public void requestsSent(@NotNull ClientAppSession session, @NotNull List<? extends FrontendAsyncRequest> requests) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(requests, (String)"requests");
        Iterable iterable = requests;
        boolean bl = false;
        for (Object t : iterable) {
            FrontendAsyncRequest frontendAsyncRequest = (FrontendAsyncRequest)t;
            boolean bl2 = false;
            Long l = frontendAsyncRequest.getSubmissionTime();
            if (l == null) {
                continue;
            }
            long l2 = l;
            SyncEventsLogger.INSTANCE.logRequestInQueueDuration(frontendAsyncRequest.getClass(), Duration.getInWholeMilliseconds-impl((long)this.G(l2)), UtilsKt.actionIdOrNull(frontendAsyncRequest));
        }
    }

    @Override
    public void requestCompleted(@NotNull ClientAppSession session, @NotNull FrontendAsyncRequest request, @NotNull RdResponse response) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Long l = request.getSubmissionTime();
        if (l == null) {
            return;
        }
        long l2 = l;
        SyncEventsLogger.INSTANCE.logRequestCompleted(request.getClass(), this.G(response), Duration.getInWholeMilliseconds-impl((long)this.G(l2)), UtilsKt.actionIdOrNull(request));
    }

    private final SyncEventsLogger.ResponseType G(RdResponse rdResponse) {
        RdResponse rdResponse2 = rdResponse;
        return rdResponse2 instanceof RdSuccessResponse ? SyncEventsLogger.ResponseType.SUCCESS : (rdResponse2 instanceof RdRetryResponse ? SyncEventsLogger.ResponseType.RETRY : (rdResponse2 instanceof RdFailureResponse ? SyncEventsLogger.ResponseType.FAILURE : SyncEventsLogger.ResponseType.UNKNOWN));
    }

    private final long G(long l) {
        return DurationKt.toDuration((long)(System.nanoTime() - l), (DurationUnit)DurationUnit.NANOSECONDS);
    }
}

