/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.diagnostics;

import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.ide.editor.EditorSynchronizer;
import com.jetbrains.rd.ide.model.RdAbstractEditorVersion;
import com.jetbrains.rd.ide.model.RdEditorVersion;
import com.jetbrains.rd.tracing.SyncEventsLogger;
import com.jetbrains.rdclient.diagnostics.ConflictTracker;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker;", "", "CaretMovementTracker", "()V", "originalCaretPositions", "", "Lcom/intellij/openapi/editor/Editor;", "Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker$CaretPosition;", "trackEditor", "", "editor", "reportAllMovements", "conflictTracker", "Lcom/jetbrains/rdclient/diagnostics/ConflictTracker;", "CaretPosition", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nCaretMovementTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CaretMovementTracker.kt\ncom/jetbrains/rdclient/diagnostics/CaretMovementTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,60:1\n216#2,2:61\n*S KotlinDebug\n*F\n+ 1 CaretMovementTracker.kt\ncom/jetbrains/rdclient/diagnostics/CaretMovementTracker\n*L\n32#1:61,2\n*E\n"})
public final class CaretMovementTracker {
    @NotNull
    private final Map<Editor, CaretPosition> originalCaretPositions = new LinkedHashMap();

    public final void trackEditor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Caret caret = editor.getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        Caret caret2 = caret;
        EditorSynchronizer editorSynchronizer = DocumentExKt.getEditorSynchronizer(editor);
        RdAbstractEditorVersion rdAbstractEditorVersion = editorSynchronizer != null ? editorSynchronizer.getVersion() : null;
        RdEditorVersion rdEditorVersion = rdAbstractEditorVersion instanceof RdEditorVersion ? (RdEditorVersion)rdAbstractEditorVersion : null;
        boolean bl = rdEditorVersion != null ? rdEditorVersion.getCaretModelVersion() == -1 : false;
        int n = caret2.getOffset();
        LogicalPosition logicalPosition = caret2.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        this.originalCaretPositions.putIfAbsent(editor, new CaretPosition(bl, n, logicalPosition));
    }

    public final void reportAllMovements(@NotNull ConflictTracker conflictTracker) {
        Intrinsics.checkNotNullParameter((Object)conflictTracker, (String)"conflictTracker");
        ConflictTracker.ConflictEvent conflictEvent = conflictTracker.getPrimaryConflict();
        Map<Editor, CaretPosition> map = this.originalCaretPositions;
        boolean bl = false;
        Iterator<Map.Entry<Editor, CaretPosition>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            LogicalPosition logicalPosition;
            Caret caret;
            Map.Entry<Editor, CaretPosition> entry;
            Map.Entry<Editor, CaretPosition> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            Editor editor = entry2.getKey();
            CaretPosition caretPosition = entry2.getValue();
            if (editor.isDisposed()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)editor.getCaretModel().getPrimaryCaret(), (String)"getPrimaryCaret(...)");
            int n = caret.getOffset();
            Intrinsics.checkNotNullExpressionValue((Object)caret.getLogicalPosition(), (String)"getLogicalPosition(...)");
            if (Intrinsics.areEqual((Object)caretPosition.getLogicalPosition(), (Object)logicalPosition)) continue;
            int n2 = Math.abs(n - caretPosition.getOffset());
            int n3 = Math.abs(logicalPosition.line - caretPosition.getLogicalPosition().line);
            int n4 = Math.abs(logicalPosition.column - caretPosition.getLogicalPosition().column);
            SyncEventsLogger syncEventsLogger = SyncEventsLogger.INSTANCE;
            boolean bl3 = caretPosition.isInitial();
            VirtualFile virtualFile = editor.getVirtualFile();
            FileType fileType = virtualFile != null ? virtualFile.getFileType() : null;
            SyncEventsLogger.RebaseSessionType rebaseSessionType = conflictTracker.getSessionType();
            ConflictTracker.ConflictEvent conflictEvent2 = conflictEvent;
            Class<?> clazz = conflictEvent2 != null ? conflictEvent2.getRequestType() : null;
            ConflictTracker.ConflictEvent conflictEvent3 = conflictEvent;
            String string = conflictEvent3 != null ? conflictEvent3.getActionId() : null;
            syncEventsLogger.logCaretChange(bl3, n2, n3, n4, rebaseSessionType, clazz, string, fileType);
        }
        this.originalCaretPositions.clear();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdclient/diagnostics/CaretMovementTracker$CaretPosition;", "", "isInitial", "", "offset", "", "logicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "CaretMovementTracker$CaretPosition", "(ZILcom/intellij/openapi/editor/LogicalPosition;)V", "()Z", "getOffset", "()I", "getLogicalPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "intellij.rd.client"})
    private static final class CaretPosition {
        private final boolean isInitial;
        private final int offset;
        @NotNull
        private final LogicalPosition logicalPosition;

        public CaretPosition(boolean isInitial, int offset, @NotNull LogicalPosition logicalPosition) {
            Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
            this.isInitial = isInitial;
            this.offset = offset;
            this.logicalPosition = logicalPosition;
        }

        public final boolean isInitial() {
            return this.isInitial;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final LogicalPosition getLogicalPosition() {
            return this.logicalPosition;
        }

        public final boolean component1() {
            return this.isInitial;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final LogicalPosition component3() {
            return this.logicalPosition;
        }

        @NotNull
        public final CaretPosition copy(boolean isInitial, int offset, @NotNull LogicalPosition logicalPosition) {
            Intrinsics.checkNotNullParameter((Object)logicalPosition, (String)"logicalPosition");
            return new CaretPosition(isInitial, offset, logicalPosition);
        }

        public static /* synthetic */ CaretPosition copy$default(CaretPosition caretPosition, boolean bl, int n, LogicalPosition logicalPosition, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = caretPosition.isInitial;
            }
            if ((n2 & 2) != 0) {
                n = caretPosition.offset;
            }
            if ((n2 & 4) != 0) {
                logicalPosition = caretPosition.logicalPosition;
            }
            return caretPosition.copy(bl, n, logicalPosition);
        }

        @NotNull
        public String toString() {
            return "CaretPosition(isInitial=" + this.isInitial + ", offset=" + this.offset + ", logicalPosition=" + this.logicalPosition + ")";
        }

        public int hashCode() {
            int n = Boolean.hashCode(this.isInitial);
            n = n * 31 + Integer.hashCode(this.offset);
            n = n * 31 + this.logicalPosition.hashCode();
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CaretPosition)) {
                return false;
            }
            CaretPosition caretPosition = (CaretPosition)other;
            if (this.isInitial != caretPosition.isInitial) {
                return false;
            }
            if (this.offset != caretPosition.offset) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.logicalPosition, (Object)caretPosition.logicalPosition);
        }
    }
}

