/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.tooltips;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendAsyncTooltipHighlightInfo;
import com.jetbrains.rdclient.daemon.highlighters.tooltips.FrontendSynchronousTooltipProvider;
import com.jetbrains.rdclient.document.DocumentExKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u0005*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/tooltips/FrontendLazyTooltipHighlightInfoRequester;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "FrontendLazyTooltipHighlightInfoRequester", "()V", "mouseMoved", "", "e", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "G", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "range", "Lcom/intellij/openapi/util/TextRange;", "G", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "G", "event", "intellij.rd.client"})
public final class FrontendLazyTooltipHighlightInfoRequester
implements EditorMouseMotionListener {
    public void mouseMoved(@NotNull EditorMouseEvent e) {
        block4: {
            MarkupModelEx markupModelEx;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (Registry.Companion.is("ide.disable.editor.tooltips")) {
                return;
            }
            int n = this.G(e);
            if (n == -1) {
                return;
            }
            Editor editor = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            if (DocumentExKt.getTextControlId(editor) == null) {
                return;
            }
            Document document = e.getEditor().getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)document2, (Project)e.getEditor().getProject(), (boolean)false);
            MarkupModelEx markupModelEx2 = markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
            if (markupModelEx2 != null) {
                this.G(markupModelEx2, new TextRange(n, n));
            }
            Editor editor2 = e.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            markupModel = this.G(editor2, n);
            MarkupModelEx markupModelEx3 = markupModelEx;
            if (markupModelEx3 == null) break block4;
            this.G(markupModelEx3, (TextRange)markupModel);
        }
    }

    private final void G(MarkupModelEx markupModelEx, TextRange textRange) {
        markupModelEx.processRangeHighlightersOverlappingWith(textRange.getStartOffset(), textRange.getEndOffset(), arg_0 -> FrontendLazyTooltipHighlightInfoRequester.G(FrontendLazyTooltipHighlightInfoRequester::G, arg_0));
    }

    private final TextRange G(Editor editor, int n) {
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(n);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"offsetToLogicalPosition(...)");
        LogicalPosition logicalPosition2 = logicalPosition;
        int n2 = Math.max(logicalPosition2.line - 1, 0);
        int n3 = logicalPosition2.line + 2;
        LogicalPosition logicalPosition3 = new LogicalPosition(n2, 0);
        LogicalPosition logicalPosition4 = new LogicalPosition(n3, 0);
        int n4 = editor.logicalPositionToOffset(logicalPosition3);
        int n5 = editor.logicalPositionToOffset(logicalPosition4);
        return new TextRange(n4, n5);
    }

    private final int G(EditorMouseEvent editorMouseEvent) {
        Editor editor = editorMouseEvent.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        Point point = editorMouseEvent.getMouseEvent().getPoint();
        if (editor2 instanceof EditorEx && editor2.getProject() != null && editorMouseEvent.getArea() == EditorMouseEventArea.EDITING_AREA && editorMouseEvent.getMouseEvent().getModifiers() == 0 && EditorUtil.isPointOverText((Editor)editor2, (Point)point) && ((EditorEx)editor2).getFoldingModel().getFoldingPlaceholderAt(point) == null) {
            LogicalPosition logicalPosition = editor2.xyToLogicalPosition(point);
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
            LogicalPosition logicalPosition2 = logicalPosition;
            return editor2.logicalPositionToOffset(logicalPosition2);
        }
        return -1;
    }

    private static final boolean G(RangeHighlighterEx rangeHighlighterEx) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighterEx, (String)"marker");
        ProgressManager.checkCanceled();
        Object object = rangeHighlighterEx.getErrorStripeTooltip();
        if (object instanceof FrontendAsyncTooltipHighlightInfo && !(((FrontendAsyncTooltipHighlightInfo)((Object)object)).getTooltipProvider() instanceof FrontendSynchronousTooltipProvider)) {
            ((FrontendAsyncTooltipHighlightInfo)((Object)object)).calculateTooltip();
        }
        return true;
    }

    private static final boolean G(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }
}

