/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.rd.util.CoroutineHelpersKt;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdclient.daemon.highlighters.inlays.PushToHintSettingsHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.PushToHintShortcutDispatcher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\"\u0010\n\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000b\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u0010\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService;", "", "PushToHintSettingsService", "()V", "watchMode", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "watcher", "Lkotlin/Function2;", "", "Lkotlin/coroutines/Continuation;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lkotlin/jvm/functions/Function2;)V", "setModeFromWidget", "Lcom/intellij/openapi/editor/Editor;", "permanent", "isEnabled", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nPushToHintController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushToHintController.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,259:1\n68#2,6:260\n68#2,6:266\n1#3:272\n*S KotlinDebug\n*F\n+ 1 PushToHintController.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService\n*L\n90#1:260,6\n95#1:266,6\n*E\n"})
public final class PushToHintSettingsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Property<Boolean>> PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY = new Key("PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY");
    @NotNull
    private static final Key<IPropertyView<Boolean>> PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY = new Key("PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY");

    public final void watchMode(@NotNull EditorImpl editor, @NotNull Lifetime lifetime, @NotNull Function2<? super Boolean, ? super Continuation<? super Unit>, ? extends Object> watcher) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(watcher, (String)"watcher");
        ThreadingAssertions.assertEventDispatchThread();
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PushToHintSettingsHost pushToHintSettingsHost = (PushToHintSettingsHost)project2.getService(PushToHintSettingsHost.class);
        Logger logger = Logger.getInstance(PushToHintSettingsService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        Intrinsics.checkNotNull((Object)pushToHintSettingsHost);
        PushToHintShortcutDispatcher pushToHintShortcutDispatcher = new PushToHintShortcutDispatcher(editor, logger2, pushToHintSettingsHost);
        IdeEventQueue.Companion.getInstance().addPostprocessor((IdeEventQueue.EventDispatcher)pushToHintShortcutDispatcher, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        logger2.trace("Push-To-Hint key dispatcher added to " + editor);
        Function2 function2 = PushToHintSettingsService::G;
        MergingUpdateQueue mergingUpdateQueue = (MergingUpdateQueue)function2.invoke((Object)lifetime, (Object)200);
        Property property = new Property((Object)false);
        pushToHintShortcutDispatcher.getActivated().view(lifetime, (arg_0, arg_1) -> PushToHintSettingsService.G(mergingUpdateQueue, logger2, editor, property, arg_0, arg_1));
        property.advise(lifetime, arg_0 -> PushToHintSettingsService.G(editor, arg_0));
        UserDataHolder userDataHolder = (UserDataHolder)editor;
        UserDataHolder userDataHolder2 = PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY;
        boolean bl = false;
        Object object2 = userDataHolder.getUserData(userDataHolder2);
        Object object3 = object2;
        if (object3 == null) {
            boolean bl2 = false;
            object = new Property((Object)false);
            userDataHolder.putUserData(userDataHolder2, object);
            object3 = object;
        }
        Property property2 = (Property)object3;
        property2.advise(lifetime, arg_0 -> PushToHintSettingsService.G(logger2, editor, arg_0));
        userDataHolder = BoolPropertyExKt.or((IPropertyView)((IPropertyView)property), (IPropertyView)((IPropertyView)property2));
        userDataHolder2 = (UserDataHolder)editor;
        Key<IPropertyView<Boolean>> key = PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY;
        boolean bl3 = false;
        object = userDataHolder2.getUserData(key);
        Object object4 = object;
        if (object4 == null) {
            boolean bl4 = false;
            UserDataHolder userDataHolder3 = userDataHolder;
            userDataHolder2.putUserData(key, (Object)userDataHolder3);
            object4 = userDataHolder3;
        }
        CoroutineHelpersKt.adviseSuspend$default((ISource)((ISource)userDataHolder), (Lifetime)lifetime, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, watcher, (int)4, null);
    }

    public final void setModeFromWidget(@NotNull Editor editor, boolean permanent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            Property property = (Property)editor.getUserData(PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY);
            if (property == null) break block0;
            property.set((Object)permanent);
        }
    }

    public final boolean isEnabled(@NotNull Editor editor) {
        IPropertyView iPropertyView;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        IPropertyView iPropertyView2 = iPropertyView = (IPropertyView)editor.getUserData(PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY);
        return iPropertyView2 != null ? (Boolean)iPropertyView2.getValue() : false;
    }

    private static final MergingUpdateQueue G(Lifetime lifetime, int n) {
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        MergingUpdateQueue mergingUpdateQueue2 = mergingUpdateQueue = new MergingUpdateQueue("ActivationDebounceQueue", n, true, MergingUpdateQueue.ANY_COMPONENT, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), null, Alarm.ThreadToUse.SWING_THREAD, null, 128, null);
        boolean bl = false;
        mergingUpdateQueue2.setRestartTimerOnAdd(true);
        return mergingUpdateQueue;
    }

    private static final Unit G(Logger logger, EditorImpl editorImpl, Property property) {
        logger.trace("Push-To-Hint deactivated by releasing Ctrl in " + editorImpl);
        property.set((Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit G(MergingUpdateQueue mergingUpdateQueue, Logger logger, EditorImpl editorImpl, Property property, Lifetime lifetime, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lt");
        if (!bl) {
            return Unit.INSTANCE;
        }
        mergingUpdateQueue.queue(new Update(logger, editorImpl, (Property<Boolean>)property, lifetime){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ EditorImpl $editor;
            final /* synthetic */ Property<Boolean> $activatedByShortcut;
            final /* synthetic */ Lifetime $lt;
            {
                this.$logger = $logger;
                this.$editor = $editor;
                this.$activatedByShortcut = $activatedByShortcut;
                this.$lt = $lt;
                super((Object)"PushToHintActivation", false, 0, 6, null);
            }

            public void run() {
                ThreadingAssertions.assertEventDispatchThread();
                this.$logger.trace("Push-To-Hint activated by double press + hold Ctrl in " + this.$editor);
                this.$activatedByShortcut.set((Object)true);
            }

            public boolean isDisposed() {
                return RLifetimeKt.isNotAlive((Lifetime)this.$lt);
            }
        });
        lifetime.onTermination(() -> PushToHintSettingsService.G(logger, editorImpl, property));
        return Unit.INSTANCE;
    }

    private static final Unit G(EditorImpl editorImpl, boolean bl) {
        if (bl) {
            editorImpl.getSettings().setWheelFontChangeEnabled(false);
        } else {
            editorImpl.getSettings().resetWheelFontChangeEnabled();
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(Logger logger, EditorImpl editorImpl, boolean bl) {
        logger.trace("Push-To-Hint mode was " + (bl ? "pinned" : "unpinned") + " in " + editorImpl);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService$Companion;", "", "PushToHintSettingsService$Companion", "()V", "getInstance", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService;", "project", "Lcom/intellij/openapi/project/Project;", "PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getPUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY", "()Lcom/intellij/openapi/util/Key;", "PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getPUSH_TO_HINT_ACTIVATED_PROPERTY_KEY", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nPushToHintController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushToHintController.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,259:1\n31#2,2:260\n*S KotlinDebug\n*F\n+ 1 PushToHintController.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/PushToHintSettingsService$Companion\n*L\n40#1:260,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PushToHintSettingsService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<PushToHintSettingsService> clazz = PushToHintSettingsService.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (PushToHintSettingsService)object;
        }

        @NotNull
        public final Key<Property<Boolean>> getPUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY() {
            return PUSH_TO_HINT_PERMANENT_MODE_PROPERTY_KEY;
        }

        @NotNull
        public final Key<IPropertyView<Boolean>> getPUSH_TO_HINT_ACTIVATED_PROPERTY_KEY() {
            return PUSH_TO_HINT_ACTIVATED_PROPERTY_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

