/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.codeInsight.hints.BlockConstrainedPresentation;
import com.intellij.codeInsight.hints.BlockConstraints;
import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.codeInsight.hints.HorizontalConstrainedPresentation;
import com.intellij.codeInsight.hints.HorizontalConstraints;
import com.intellij.codeInsight.hints.InlayContentListener;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.InlineInlayRenderer;
import com.intellij.codeInsight.hints.LinearOrderInlayRenderer;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.InlayTextMetricsStorage;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationListener;
import com.intellij.codeInsight.hints.presentation.RecursivelyUpdatingRootPresentation;
import com.intellij.codeInsight.hints.presentation.RootInlayPresentation;
import com.intellij.codeInsight.hints.presentation.ScaleAwarePresentationFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayProperties;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.BlockConstrainsModel;
import com.jetbrains.rd.ide.model.ConstrainedInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HorizontalConstraintsModel;
import com.jetbrains.rd.ide.model.InlayConstraintsModel;
import com.jetbrains.rd.ide.model.InlayWithPresentationEventsModel;
import com.jetbrains.rd.ide.model.RootPresentationModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayWithPresentationModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayWithPresentationModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "project", "Lcom/intellij/openapi/project/Project;", "inlayEventsModel", "Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;", "FrontendInlayWithPresentationModelHandler", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/InlayWithPresentationEventsModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "textMetricsStorage", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendInlayWithPresentationModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final EditorImpl editor;
    @Nullable
    private final Project project;
    @NotNull
    private final InlayWithPresentationEventsModel inlayEventsModel;
    @NotNull
    private final InlayTextMetricsStorage textMetricsStorage;

    public FrontendInlayWithPresentationModelHandler(@NotNull EditorImpl editor, @Nullable Project project, @NotNull InlayWithPresentationEventsModel inlayEventsModel) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)inlayEventsModel), (String)"inlayEventsModel");
        this.editor = editor;
        this.project = project;
        this.inlayEventsModel = inlayEventsModel;
        this.textMetricsStorage = new InlayTextMetricsStorage((Editor)this.editor);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof ConstrainedInlayHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        block7: {
            Inlay inlay;
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            ConstrainedInlayHighlighterModel cfr_ignored_0 = (ConstrainedInlayHighlighterModel)model;
            boolean bl = ((ConstrainedInlayHighlighterModel)model).getConstraints().getRelatesToPrecedingText();
            ((RangeMarkerImpl)highlighter).setStickingToRight(bl);
            PresentationFactory presentationFactory = new PresentationFactory((Editor)this.editor);
            ScaleAwarePresentationFactory scaleAwarePresentationFactory = new ScaleAwarePresentationFactory((Editor)this.editor, presentationFactory);
            RootPresentationModel rootPresentationModel = ((ConstrainedInlayHighlighterModel)model).getPresentation();
            InlayPresentation inlayPresentation = FrontendInlayWithPresentationModelSupportKt.access$toPresentation(rootPresentationModel.getPresentation(), this.textMetricsStorage, model.getId(), this.inlayEventsModel, scaleAwarePresentationFactory);
            if (inlayPresentation == null) {
                return;
            }
            InlayPresentation inlayPresentation2 = inlayPresentation;
            RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation = new RecursivelyUpdatingRootPresentation(inlayPresentation2);
            if (FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter) != null) {
                Inlay<?> inlay2 = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
                EditorCustomElementRenderer editorCustomElementRenderer = inlay2 != null ? inlay2.getRenderer() : null;
                LinearOrderInlayRenderer linearOrderInlayRenderer = editorCustomElementRenderer instanceof LinearOrderInlayRenderer ? (LinearOrderInlayRenderer)editorCustomElementRenderer : null;
                InlayPresentation inlayPresentation3 = linearOrderInlayRenderer != null ? linearOrderInlayRenderer.getCachedPresentation() : null;
                RecursivelyUpdatingRootPresentation cfr_ignored_1 = (RecursivelyUpdatingRootPresentation)inlayPresentation3;
                RecursivelyUpdatingRootPresentation recursivelyUpdatingRootPresentation2 = (RecursivelyUpdatingRootPresentation)inlayPresentation3;
                if (recursivelyUpdatingRootPresentation2 != null) {
                    recursivelyUpdatingRootPresentation2.update(recursivelyUpdatingRootPresentation.getContent(), (Editor)this.editor, (InlayPresentationFactory)presentationFactory);
                }
                return;
            }
            InlayConstraintsModel inlayConstraintsModel = ((ConstrainedInlayHighlighterModel)model).getConstraints();
            if (inlayConstraintsModel instanceof HorizontalConstraintsModel) {
                var11_10 = new HorizontalConstraints(inlayConstraintsModel.getPriority(), bl, ((HorizontalConstraintsModel)inlayConstraintsModel).getPlacedAtTheEndOfLine());
                var12_14 = new HorizontalConstrainedPresentation((RootInlayPresentation)recursivelyUpdatingRootPresentation, var11_10);
                var13_15 = new InlineInlayRenderer((Collection)CollectionsKt.listOf((Object)var12_14));
                inlay = var11_10.getPlacedAtTheEndOfLine() ? this.editor.getInlayModel().addAfterLineEndElement(model.getStart(), var11_10.getRelatesToPrecedingText(), (EditorCustomElementRenderer)var13_15) : this.editor.getInlayModel().addInlineElement(model.getStart(), var11_10.getRelatesToPrecedingText(), var11_10.getPriority(), (EditorCustomElementRenderer)var13_15);
            } else if (inlayConstraintsModel instanceof BlockConstrainsModel) {
                var11_10 = new BlockConstraints(bl, inlayConstraintsModel.getPriority(), null, null, 12, null);
                var12_14 = new BlockConstrainedPresentation((RootInlayPresentation)recursivelyUpdatingRootPresentation, (BlockConstraints)var11_10);
                var13_15 = new BlockInlayRenderer(presentationFactory, (Collection)CollectionsKt.listOf((Object)var12_14));
                inlay = this.editor.getInlayModel().addBlockElement(model.getStart(), new InlayProperties().relatesToPrecedingText(bl).showAbove(((BlockConstrainsModel)inlayConstraintsModel).getShowAbove()).showWhenFolded(((BlockConstrainsModel)inlayConstraintsModel).getShowWhenFolded()).priority(var11_10.getPriority()), (EditorCustomElementRenderer)var13_15);
            } else {
                return;
            }
            Inlay inlay3 = inlay;
            FrontendInlayWithPresentationModelSupportKt.setInlay(highlighter, inlay3);
            Inlay inlay4 = inlay3;
            if (inlay4 == null || (inlay4 = (LinearOrderInlayRenderer)inlay4.getRenderer()) == null) break block7;
            inlay4.setListener((PresentationListener)new InlayContentListener(inlay3));
        }
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Inlay<?> inlay = FrontendInlayWithPresentationModelSupportKt.getInlay(highlighter);
        if (inlay == null) {
            return false;
        }
        Inlay<?> inlay2 = inlay;
        if (!(inlay2.getRenderer() instanceof InlineInlayRenderer)) {
            return false;
        }
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return FrontendInlayWithPresentationModelSupportKt.move((ConstrainedInlayHighlighterModel)model, startOffset, endOffset);
    }
}

