/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayModelAdapter;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendInlayRenderer;
import com.jetbrains.rdclient.daemon.highlighters.inlays.InlayInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "frontendInlayModelAdapter", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;", "FrontendInlayDocumentWatcher", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayModelAdapter;)V", "attach", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "G", "Lcom/jetbrains/rdclient/daemon/highlighters/inlays/InlayInfo;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendInlayDocumentWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendInlayDocumentWatcher.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n774#2:70\n865#2,2:71\n1863#2,2:73\n774#2:75\n865#2,2:76\n1863#2,2:78\n1863#2,2:80\n*S KotlinDebug\n*F\n+ 1 FrontendInlayDocumentWatcher.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendInlayDocumentWatcher\n*L\n28#1:70\n28#1:71,2\n28#1:73,2\n31#1:75\n31#1:76,2\n31#1:78,2\n57#1:80,2\n*E\n"})
public final class FrontendInlayDocumentWatcher
implements DocumentListener {
    @Nullable
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final FrontendInlayModelAdapter frontendInlayModelAdapter;

    public FrontendInlayDocumentWatcher(@Nullable Project project, @NotNull Editor editor, @NotNull FrontendInlayModelAdapter frontendInlayModelAdapter) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)frontendInlayModelAdapter, (String)"frontendInlayModelAdapter");
        this.project = project;
        this.editor = editor;
        this.frontendInlayModelAdapter = frontendInlayModelAdapter;
    }

    public final void attach(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.editor.getDocument().addDocumentListener((DocumentListener)this, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        boolean bl;
        boolean bl2;
        Object object;
        Collection<Object> collection2;
        VisualPosition visualPosition;
        int n;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getDocument().isInBulkUpdate()) {
                    return;
                }
                VisualPosition visualPosition2 = this.editor.offsetToVisualPosition(event.getOffset());
                Intrinsics.checkNotNullExpressionValue((Object)visualPosition2, (String)"offsetToVisualPosition(...)");
                VisualPosition visualPosition3 = visualPosition2;
                List list2 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualPosition3.line, true);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getBlockElementsForVisualLine(...)");
                Iterable iterable = list2;
                n = 0;
                visualPosition = iterable;
                collection2 = new ArrayList();
                boolean bl3 = false;
                for (Object t : visualPosition) {
                    object = (Inlay)t;
                    bl2 = false;
                    if (!(object.getRenderer() instanceof FrontendInlayRenderer)) continue;
                    collection2.add(t);
                }
                iterable = (List)collection2;
                n = 0;
                for (Collection<Object> collection2 : iterable) {
                    Inlay inlay = (Inlay)collection2;
                    boolean bl4 = false;
                    inlay.update();
                }
                List list3 = this.editor.getInlayModel().getBlockElementsForVisualLine(visualPosition3.line, false);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getBlockElementsForVisualLine(...)");
                iterable = list3;
                n = 0;
                visualPosition = iterable;
                collection2 = new ArrayList();
                bl3 = false;
                for (Object t : visualPosition) {
                    object = (Inlay)t;
                    bl2 = false;
                    if (!(object.getRenderer() instanceof FrontendInlayRenderer)) continue;
                    collection2.add(t);
                }
                iterable = (List)collection2;
                n = 0;
                for (Collection<Object> collection2 : iterable) {
                    Inlay inlay = (Inlay)collection2;
                    boolean bl5 = false;
                    inlay.update();
                }
                CharSequence charSequence = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                if (charSequence.length() == 0) break block17;
                CharSequence charSequence2 = event.getNewFragment();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"getNewFragment(...)");
                if (StringsKt.isBlank((CharSequence)charSequence2)) break block18;
            }
            return;
        }
        int n2 = event.getOffset();
        n = event.getOffset() + event.getNewFragment().length();
        VisualPosition visualPosition4 = this.editor.offsetToVisualPosition(n2);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition4, (String)"offsetToVisualPosition(...)");
        visualPosition = visualPosition4;
        Inlay inlay = this.editor.getInlayModel().getInlineElementAt(visualPosition);
        if (inlay != null) {
            Inlay inlay2 = inlay;
            boolean bl6 = false;
            InlayInfo inlayInfo = this.G(inlay2);
            if (inlayInfo != null) {
                object = inlayInfo;
                bl2 = false;
                if (!((InlayInfo)object).getRelatesToPrecedingText()) {
                    this.frontendInlayModelAdapter.moveInlay(inlay2, (InlayInfo)object, n);
                }
            }
        }
        VisualPosition visualPosition5 = EditorUtil.inlayAwareOffsetToVisualPosition((Editor)this.editor, (int)n);
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition5, (String)"inlayAwareOffsetToVisualPosition(...)");
        collection2 = visualPosition5;
        Inlay inlay3 = this.editor.getInlayModel().getInlineElementAt((VisualPosition)collection2);
        if (inlay3 != null) {
            Inlay inlay4 = inlay3;
            boolean bl7 = false;
            InlayInfo inlayInfo = this.G(inlay4);
            if (inlayInfo != null) {
                InlayInfo inlayInfo2 = inlayInfo;
                bl = false;
                if (inlayInfo2.getRelatesToPrecedingText()) {
                    this.frontendInlayModelAdapter.moveInlay(inlay4, inlayInfo2, n2);
                }
            }
        }
        List list4 = this.editor.getInlayModel().getAfterLineEndElementsInRange(n, n, FrontendInlayRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getAfterLineEndElementsInRange(...)");
        Iterable iterable = list4;
        boolean bl8 = false;
        for (Object t : iterable) {
            InlayInfo inlayInfo;
            Inlay inlay5 = (Inlay)t;
            bl = false;
            Intrinsics.checkNotNull((Object)inlay5);
            if (this.G(inlay5) == null) continue;
            boolean bl9 = false;
            this.frontendInlayModelAdapter.moveInlay(inlay5, inlayInfo, n2);
        }
    }

    private final InlayInfo G(Inlay<?> inlay) {
        EditorCustomElementRenderer editorCustomElementRenderer = inlay.getRenderer();
        FrontendInlayRenderer frontendInlayRenderer = editorCustomElementRenderer instanceof FrontendInlayRenderer ? (FrontendInlayRenderer)editorCustomElementRenderer : null;
        if (frontendInlayRenderer == null) {
            return null;
        }
        FrontendInlayRenderer frontendInlayRenderer2 = frontendInlayRenderer;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, document);
        if (frontendMarkupContributor == null) {
            return null;
        }
        FrontendMarkupContributor frontendMarkupContributor2 = frontendMarkupContributor;
        RangeHighlighterEx rangeHighlighterEx = frontendMarkupContributor2.getStorage().getAll().get(frontendInlayRenderer2.getId());
        return rangeHighlighterEx != null ? FrontendHintInlayModelSupportKt.getInlayInfo((RangeHighlighter)rangeHighlighterEx) : null;
    }
}

