/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.SmartList;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HintInlayHighlighterModel;
import com.jetbrains.rd.ide.model.InlayProperties;
import com.jetbrains.rd.ui.ProtocolUIKt;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendHintInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.inlays.InlayInfo;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendHintInlayModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "FrontendHintInlayModelHandler", "()V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendHintInlayModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendHintInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendHintInlayModelHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,139:1\n1#2:140\n15#3:141\n*S KotlinDebug\n*F\n+ 1 FrontendHintInlayModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendHintInlayModelHandler\n*L\n100#1:141\n*E\n"})
public final class FrontendHintInlayModelHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof HintInlayHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Object v1;
        Iterable iterable;
        SmartList smartList;
        block3: {
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            HintInlayHighlighterModel cfr_ignored_0 = (HintInlayHighlighterModel)model;
            ((RangeMarkerImpl)highlighter).setStickingToRight(!((HintInlayHighlighterModel)model).getRelatesToPrecedingText());
            SmartList smartList2 = FrontendHintInlayModelSupportKt.getInlayInfo(highlighter);
            if (smartList2 == null || (smartList2 = smartList2.getInlays()) == null) {
                smartList2 = new SmartList();
            }
            smartList = smartList2;
            iterable = (Iterable)smartList;
            for (Object t : iterable) {
                Inlay inlay = (Inlay)t;
                boolean bl = false;
                if (!(inlay.getOffset() != model.getStart())) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Inlay inlay = v1;
        if (inlay != null) {
            iterable = inlay;
            boolean bl = false;
            FrontendHintInlayModelSupportKt.setInlayUpdateRequest(highlighter, (HintInlayHighlighterModel)model);
            LOG.debug("Request inlay update '" + ProtocolUIKt.toSimpleText(((HintInlayHighlighterModel)model).getText()) + "' from " + iterable.getOffset() + " to " + model.getStart());
        }
        FrontendHintInlayModelSupportKt.setInlayInfo(highlighter, new InlayInfo((HintInlayHighlighterModel)model, smartList));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter)) {
            return false;
        }
        HintInlayHighlighterModel hintInlayHighlighterModel = (HintInlayHighlighterModel)model;
        InlayInfo inlayInfo = FrontendHintInlayModelSupportKt.getInlayInfo(highlighter);
        if (inlayInfo == null) return false;
        if (hintInlayHighlighterModel.getId() != inlayInfo.getId()) return false;
        boolean bl = true;
        if (!bl) return false;
        InlayInfo inlayInfo2 = FrontendHintInlayModelSupportKt.getInlayInfo(highlighter);
        if (!Intrinsics.areEqual((Object)hintInlayHighlighterModel.getText(), (Object)(inlayInfo2 != null ? inlayInfo2.getText() : null))) return false;
        InlayInfo inlayInfo3 = FrontendHintInlayModelSupportKt.getInlayInfo(highlighter);
        if (!Intrinsics.areEqual((Object)hintInlayHighlighterModel.getIcon(), (Object)(inlayInfo3 != null ? inlayInfo3.getIcon() : null))) return false;
        inlayInfo = FrontendHintInlayModelSupportKt.getInlayInfo(highlighter);
        if (inlayInfo == null) return false;
        InlayProperties inlayProperties = inlayInfo.getInlayProperties();
        if (inlayProperties == null) return false;
        if (hintInlayHighlighterModel.getInlayProperties().getInPushToHintMode() != inlayProperties.getInPushToHintMode()) return false;
        return true;
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return FrontendHintInlayModelSupportKt.move((HintInlayHighlighterModel)model, startOffset, endOffset);
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendHintInlayModelHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendHintInlayModelHandler$Companion;", "", "FrontendHintInlayModelHandler$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

