/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.inlays;

import com.intellij.codeInsight.hints.BlockInlayRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.BlockInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.inlays.BlockInlayInfo;
import com.jetbrains.rdclient.daemon.highlighters.inlays.FrontendBlockInlayModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlighterModelAgnosticComparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/inlays/FrontendBlockInlayModelHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "FrontendBlockInlayModelHandler", "()V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "intellij.rd.client"})
public final class FrontendBlockInlayModelHandler
implements IProtocolHighlighterModelHandler {
    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model instanceof BlockInlayHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        BlockInlayHighlighterModel blockInlayHighlighterModel = (BlockInlayHighlighterModel)model;
        if (FrontendBlockInlayModelSupportKt.getBlockInlayInfo(highlighter) != null) {
            return;
        }
        FrontendBlockInlayModelSupportKt.setBlockInlayInfo(highlighter, new BlockInlayInfo(model.getId(), blockInlayHighlighterModel.getShowAbove(), blockInlayHighlighterModel.getFullWidth(), blockInlayHighlighterModel.getPriority(), blockInlayHighlighterModel.getFocusOnShow(), null, 32, null));
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        if (!(model instanceof BlockInlayHighlighterModel)) {
            return false;
        }
        Inlay inlay = highlighter instanceof Inlay ? (Inlay)highlighter : null;
        if (inlay == null) {
            return false;
        }
        Inlay inlay2 = inlay;
        if (!(inlay2.getRenderer() instanceof BlockInlayRenderer)) {
            return false;
        }
        return HighlighterModelAgnosticComparator.INSTANCE.compare(model, highlighter);
    }

    @Override
    @NotNull
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return FrontendBlockInlayModelSupportKt.move((BlockInlayHighlighterModel)model, startOffset, endOffset);
    }
}

