/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RangeMarkersKt;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.FrontendIndentGuideHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.indentGuides.currentScope.FrontendCurrentScopeHighlightingManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl;", "Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManager;", "FrontendCurrentScopeHighlightingManagerImpl", "()V", "myCodeInsightSettings", "Lcom/intellij/codeInsight/CodeInsightSettings;", "updateCurrentScopeHighlighting", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "G", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/ex/EditorEx;", "Companion", "intellij.rd.client"})
public final class FrontendCurrentScopeHighlightingManagerImpl
implements FrontendCurrentScopeHighlightingManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CodeInsightSettings myCodeInsightSettings;
    @NotNull
    private static final Key<RangeHighlighter> SCOPE_MARKER_IN_EDITOR_KEY;

    public FrontendCurrentScopeHighlightingManagerImpl() {
        CodeInsightSettings codeInsightSettings = CodeInsightSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)codeInsightSettings, (String)"getInstance(...)");
        this.myCodeInsightSettings = codeInsightSettings;
    }

    @Override
    public void updateCurrentScopeHighlighting(@NotNull Editor editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!(editor instanceof EditorEx)) {
            return;
        }
        TextRange textRange = this.G((EditorEx)editor);
        RangeHighlighter rangeHighlighter2 = rangeHighlighter = (RangeHighlighter)editor.getUserData(SCOPE_MARKER_IN_EDITOR_KEY);
        if (Intrinsics.areEqual((Object)textRange, (Object)(rangeHighlighter2 != null ? RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)rangeHighlighter2)) : null))) {
            return;
        }
        RangeHighlighter rangeHighlighter3 = rangeHighlighter;
        if (rangeHighlighter3 != null) {
            rangeHighlighter3.dispose();
        }
        editor.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, null);
        if (textRange == null) {
            return;
        }
        RangeHighlighterEx rangeHighlighterEx = ((EditorEx)editor).getMarkupModel().addRangeHighlighterAndChangeAttributes(null, textRange.getStartOffset(), textRange.getEndOffset(), 0, HighlighterTargetArea.LINES_IN_RANGE, false, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.G(FrontendCurrentScopeHighlightingManagerImpl::G, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighter rangeHighlighter4 = (RangeHighlighter)rangeHighlighterEx;
        editor.putUserData(SCOPE_MARKER_IN_EDITOR_KEY, (Object)rangeHighlighter4);
    }

    private final TextRange G(EditorEx editorEx) {
        if (!this.myCodeInsightSettings.HIGHLIGHT_SCOPE) {
            return null;
        }
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)((Document)editorEx.getDocument()), (Project)editorEx.getProject(), (boolean)false);
        MarkupModelEx markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        if (markupModelEx == null) {
            return null;
        }
        MarkupModelEx markupModelEx2 = markupModelEx;
        int n = editorEx.getCaretModel().getCurrentCaret().getOffset();
        markupModel = new Ref.ObjectRef();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        markupModelEx2.processRangeHighlightersOverlappingWith(n, n, arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.G(arg_0 -> FrontendCurrentScopeHighlightingManagerImpl.G((Ref.ObjectRef)markupModel, objectRef, arg_0), arg_0));
        return (TextRange)objectRef.element;
    }

    private static final Unit G(RangeHighlighterEx rangeHighlighterEx) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighterEx, (String)"h");
        rangeHighlighterEx.setLineMarkerRenderer(BraceHighlightingHandler.Companion.createLineMarkerRenderer(true));
        return Unit.INSTANCE;
    }

    private static final void G(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final boolean G(Ref.ObjectRef objectRef, Ref.ObjectRef objectRef2, RangeHighlighterEx rangeHighlighterEx) {
        Intrinsics.checkNotNull((Object)rangeHighlighterEx);
        Integer n = FrontendIndentGuideHighlighterModelHandler.Companion.getIndentLevel((RangeHighlighter)rangeHighlighterEx);
        if (n == null) {
            return true;
        }
        int n2 = n;
        Integer n3 = (Integer)objectRef.element;
        if (n3 == null || n3 < n2) {
            objectRef.element = n2;
            objectRef2.element = RangeMarkersKt.getAsTextRange((RangeMarker)((RangeMarker)rangeHighlighterEx));
        }
        return true;
    }

    private static final boolean G(Function1 function1, Object object) {
        return (Boolean)function1.invoke(object);
    }

    static {
        Key key = Key.create((String)"FrontendCurrentScopeHighlightingManagerImpl.SCOPE_MARKER_IN_EDITOR_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SCOPE_MARKER_IN_EDITOR_KEY = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/indentGuides/currentScope/FrontendCurrentScopeHighlightingManagerImpl$Companion;", "", "FrontendCurrentScopeHighlightingManagerImpl$Companion", "()V", "SCOPE_MARKER_IN_EDITOR_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

