/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.SmartList;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingRestoreRecord;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelSupportKt;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0016\u0018\u0000 c2\u00020\u0001:\u0001cB1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010&\u001a\u00020\bH\u0002J\b\u0010'\u001a\u00020(H\u0002J\u0014\u0010-\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/J \u00101\u001a\u00020(2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u000206H\u0002J\u0016\u00107\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0002J\u0014\u00108\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090/J\b\u0010:\u001a\u00020\bH\u0014J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<H\u0014J&\u0010>\u001a\b\u0012\u0004\u0012\u00020=0/2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010?\u001a\u00020\u0007H\u0014J8\u0010@\u001a\u00020(2\u0006\u0010A\u001a\u00020=2\u0006\u0010?\u001a\u00020\u00072\u001e\u0010B\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0D0CH\u0002J\u0016\u0010E\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090FH\u0014J\u0018\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u0002092\u0006\u0010?\u001a\u00020\u0007H\u0014J\u0016\u0010I\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002090/H\u0014J\u0010\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u00020=H\u0002J,\u0010L\u001a\u001e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0Mj\u0002`N2\u0006\u0010O\u001a\u00020\bH\u0002J>\u0010P\u001a\u00020(2\u0006\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u0010S\u001a\u00020\b2\u0006\u0010T\u001a\u00020\b2\f\u0010U\u001a\b\u0012\u0004\u0012\u00020=0/H\u0002J\u0018\u0010V\u001a\u00020\b2\u0006\u0010Q\u001a\u0002032\u0006\u0010R\u001a\u000203H\u0002J\u0016\u0010W\u001a\u00020(2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0016J\u000e\u0010X\u001a\u00020(2\u0006\u0010Y\u001a\u000200J\u0010\u0010Z\u001a\u00020(2\u0006\u0010Y\u001a\u000200H\u0002J\u0018\u0010[\u001a\u00020\b2\u0006\u0010\\\u001a\u00020=2\u0006\u0010?\u001a\u00020\u0007H\u0014J*\u0010]\u001a\u0004\u0018\u00010=2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010?\u001a\u00020\u00072\u0006\u0010^\u001a\u00020\bH\u0014J\"\u0010_\u001a\u0004\u0018\u00010=2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u0010`\u001a\u00020\u0007H\u0014J\u0018\u0010a\u001a\u00020(2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010b\u001a\u00020=H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR+\u0010\u0004\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005j\u0002`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010!\u001a\u00070\"\u00a2\u0006\u0002\b#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u000e\u0010*\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isExpandedCallbackFactory", "Lkotlin/Function0;", "Lkotlin/Function1;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingInfo;", "", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallback;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingExpandedCallbackFactory;", "FrontendEditorFoldingModelAdapter", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "()Lkotlin/jvm/functions/Function0;", "applyIsExpandedUpdatesFromBackend", "getApplyIsExpandedUpdatesFromBackend", "()Z", "uiRegionDebugging", "groups", "", "", "Lcom/intellij/openapi/editor/FoldingGroup;", "getGroups", "()Ljava/util/Map;", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "getFoldingModel", "()Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "foldingManager", "Lkotlin/Lazy;", "Lcom/intellij/codeInsight/folding/impl/CodeFoldingManagerImpl;", "frontendEditorFoldingInfo", "Lcom/intellij/codeInsight/folding/impl/EditorFoldingInfo;", "Lorg/jetbrains/annotations/NotNull;", "foldingRestoreRecords", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FoldingRestoreRecord;", "G", "G", "", "isInitialized", "_initialized", "lock", "", "afterBulkAdd", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "G", "start", "", "end", "attr", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "G", "updateCollapsedStates", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isUserFoldRegionsSupported", "getExistingFoldRegionsForMerge", "", "Lcom/intellij/openapi/editor/FoldRegion;", "getExistingFoldRegionsAtRange", "foldingInfo", "G", "existingFoldRegion", "mergeResult", "Lcom/intellij/openapi/util/Ref;", "Lkotlin/Triple;", "addFoldings", "", "isCustomFoldRegion", "rangeHighlighter", "initFoldings", "G", "foldRegion", "G", "Lkotlin/Function3;", "Lcom/jetbrains/rdclient/daemon/highlighters/foldings/RestoreFoldingExpandedCallback;", "foldingInitializationForOpenedEditor", "G", "startOffset", "endOffset", "defaultExpansion", "mandatoryExpansion", "existingFoldRegionsAtRange", "G", "beforeBulkRemove", "afterUpdated", "highlighter", "G", "canBeReused", "oldRegion", "createNewRegionOrIgnore", "isExpanded", "createFoldRegion", "info", "G", "existingRegion", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendEditorFoldingModelAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,430:1\n2632#2,3:431\n2632#2,3:434\n774#2:454\n865#2,2:455\n774#2:458\n865#2,2:459\n230#2,2:461\n774#2:465\n865#2,2:466\n295#2,2:469\n1#3:437\n381#4,7:438\n381#4,7:445\n69#5,2:452\n72#5:457\n69#5,2:463\n72#5:468\n69#5,4:471\n15#5:475\n*S KotlinDebug\n*F\n+ 1 FrontendEditorFoldingModelAdapter.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter\n*L\n104#1:431,3\n327#1:434,3\n106#1:454\n106#1:455,2\n112#1:458\n112#1:459,2\n133#1:461,2\n329#1:465\n329#1:466,2\n334#1:469,2\n393#1:438,7\n412#1:445,7\n106#1:452,2\n106#1:457\n329#1:463,2\n329#1:468\n373#1:471,4\n45#1:475\n*E\n"})
public class FrontendEditorFoldingModelAdapter
implements FrontendMarkupAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory;
    private final boolean applyIsExpandedUpdatesFromBackend;
    private final boolean uiRegionDebugging;
    @NotNull
    private final Map<Long, FoldingGroup> groups;
    @NotNull
    private final FoldingModelImpl foldingModel;
    @NotNull
    private final Lazy<CodeFoldingManagerImpl> foldingManager;
    @NotNull
    private final EditorFoldingInfo frontendEditorFoldingInfo;
    @NotNull
    private final Map<FoldingRestoreRecord, Boolean> foldingRestoreRecords;
    private boolean _initialized;
    @NotNull
    private final Object lock;
    @NotNull
    private static final Key<Boolean> RESTORE_FOLDING_STATE;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final TextAttributes redFromBackend;
    @NotNull
    private static final TextAttributes greenMergedWithExisting;
    @NotNull
    private static final TextAttributes blueMergedWithCreatedByFrontend;
    @NotNull
    private static final TextAttributes cyanExoticStateFromFrontend;

    public FrontendEditorFoldingModelAdapter(@NotNull Editor editor, @NotNull Function0<? extends Function1<? super FoldingInfo, Boolean>> isExpandedCallbackFactory) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(isExpandedCallbackFactory, (String)"isExpandedCallbackFactory");
        this.editor = editor;
        this.isExpandedCallbackFactory = isExpandedCallbackFactory;
        this.applyIsExpandedUpdatesFromBackend = true;
        this.uiRegionDebugging = Registry.Companion.is("rdclient.fold.debug.ui.enabled", false);
        this.groups = new LinkedHashMap();
        FoldingModel foldingModel = this.editor.getFoldingModel();
        Intrinsics.checkNotNull((Object)foldingModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.FoldingModelImpl");
        this.foldingModel = (FoldingModelImpl)foldingModel;
        this.foldingManager = LazyKt.lazy(() -> FrontendEditorFoldingModelAdapter.G(this));
        EditorFoldingInfo editorFoldingInfo = EditorFoldingInfo.get((Editor)this.editor);
        Intrinsics.checkNotNullExpressionValue((Object)editorFoldingInfo, (String)"get(...)");
        this.frontendEditorFoldingInfo = editorFoldingInfo;
        this.foldingRestoreRecords = new LinkedHashMap();
        this.lock = new Object();
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final Function0<Function1<FoldingInfo, Boolean>> isExpandedCallbackFactory() {
        return this.isExpandedCallbackFactory;
    }

    protected boolean getApplyIsExpandedUpdatesFromBackend() {
        return this.applyIsExpandedUpdatesFromBackend;
    }

    @NotNull
    protected final Map<Long, FoldingGroup> getGroups() {
        return this.groups;
    }

    @NotNull
    protected final FoldingModelImpl getFoldingModel() {
        return this.foldingModel;
    }

    private final boolean G() {
        return Intrinsics.areEqual((Object)RESTORE_FOLDING_STATE.get((UserDataHolder)this.editor), (Object)true);
    }

    private final void G() {
        RESTORE_FOLDING_STATE.set((UserDataHolder)this.editor, null);
        this.foldingRestoreRecords.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isInitialized() {
        if (this._initialized) {
            return true;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this._initialized;
            return bl2;
        }
    }

    @Override
    public final void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        LocalChangeKt.ignoreOnReentrancy(FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0<Unit>)((Function0)() -> FrontendEditorFoldingModelAdapter.G(this, highlighters)));
    }

    private final void G(int n, int n2, TextAttributes textAttributes) {
        if (this.uiRegionDebugging) {
            this.editor.getMarkupModel().addRangeHighlighter(n, n2, 6000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
        }
    }

    private final void G(List<? extends RangeHighlighterEx> list2) {
        boolean bl;
        block4: {
            Iterable iterable = list2;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
                    boolean bl3 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.b(this, list2));
    }

    public final void updateCollapsedStates(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.G(true);
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.G(highlighters, function3, this));
    }

    protected boolean isUserFoldRegionsSupported() {
        return false;
    }

    @NotNull
    protected List<FoldRegion> getExistingFoldRegionsForMerge() {
        FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
        Intrinsics.checkNotNullExpressionValue((Object)foldRegionArray, (String)"getAllFoldRegions(...)");
        return ArraysKt.toMutableList((Object[])foldRegionArray);
    }

    @NotNull
    protected List<FoldRegion> getExistingFoldRegionsAtRange(int start, int end, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion foldRegion = this.foldingModel.getFoldRegion(start, end);
        return foldRegion == null ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)foldRegion);
    }

    private final void G(FoldRegion foldRegion, FoldingInfo foldingInfo, Ref<Triple<FoldRegion, Boolean, Boolean>> ref) {
        boolean bl = true;
        boolean bl2 = foldRegion.isExpanded();
        if (this.frontendEditorFoldingInfo.getPsiElement(foldRegion) != null) {
            this.frontendEditorFoldingInfo.removeRegion(foldRegion);
            bl = false;
        }
        if (ref.isNull() && this.canBeReused(foldRegion, foldingInfo)) {
            if (bl) {
                this.G(foldingInfo, foldRegion);
                ((CodeFoldingManagerImpl)this.foldingManager.getValue()).markUpdated(foldRegion);
                ref.set((Object)new Triple((Object)foldRegion, (Object)bl2, (Object)true));
                return;
            }
            ref.set((Object)new Triple((Object)foldRegion, (Object)bl2, (Object)false));
        }
        this.foldingModel.removeFoldRegion(foldRegion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFoldings(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        try {
            Map map = CodeFoldingManagerImpl.getAsyncExpandStatusMap((Editor)this.editor);
            if (map == null) {
                map = MapsKt.emptyMap();
            }
            Map map2 = map;
            Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.G(false);
            for (RangeHighlighter rangeHighlighter : highlighters) {
                FoldingInfo foldingInfo;
                if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null || this.isCustomFoldRegion(rangeHighlighter, foldingInfo)) continue;
                Boolean bl = (Boolean)map2.get(TextRange.create((Segment)((Segment)rangeHighlighter)));
                boolean bl2 = bl != null ? bl.booleanValue() : ((Boolean)function3.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo)).booleanValue();
                this.G(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo, bl2, false, this.getExistingFoldRegionsAtRange(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), foldingInfo));
                if (!this.uiRegionDebugging || !map2.containsKey(TextRange.create((Segment)((Segment)rangeHighlighter)))) continue;
                this.G(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), cyanExoticStateFromFrontend);
            }
        }
        finally {
            this.G();
            CodeFoldingManagerImpl.setAsyncExpandStatusMap((Editor)this.editor, null);
        }
    }

    protected boolean isCustomFoldRegion(@NotNull RangeHighlighter rangeHighlighter, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)rangeHighlighter, (String)"rangeHighlighter");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        return false;
    }

    protected void initFoldings(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
        Function3<Integer, Integer, FoldingInfo, Boolean> function3 = this.G(true);
        List<FoldRegion> list2 = this.getExistingFoldRegionsForMerge();
        if (Registry.Companion.is("cache.folding.model.on.disk")) {
            logger.warn("Key `cache.folding.model.on.disk` is active. \n            The successfully raised zombies broke the order of editor/document folding initialization.\n            That leads to RIDER-5877. \n            See `com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl.buildInitialFoldings(com.intellij.openapi.editor.Document)`");
        }
        for (RangeHighlighter object : highlighters) {
            FoldingInfo foldingInfo;
            if (FoldingInfoKt.getFoldingInfo(object) == null) continue;
            List<FoldRegion> list3 = this.getExistingFoldRegionsAtRange(object.getStartOffset(), object.getEndOffset(), foldingInfo);
            list2.removeAll((Collection)list3);
            this.G(object.getStartOffset(), object.getEndOffset(), foldingInfo, (Boolean)function3.invoke((Object)object.getStartOffset(), (Object)object.getEndOffset(), (Object)foldingInfo), this.G(object.getStartOffset(), object.getEndOffset()), list3);
        }
        boolean bl = !this.isUserFoldRegionsSupported();
        for (FoldRegion foldRegion : list2) {
            if (this.G(foldRegion) || !bl) continue;
            this.foldingModel.removeFoldRegion(foldRegion);
        }
    }

    private final boolean G(FoldRegion foldRegion) {
        return this.frontendEditorFoldingInfo.getPsiElement(foldRegion) != null || Intrinsics.areEqual((Object)foldRegion.getUserData(CustomFoldRegion.IMMUTABLE_FOLD_REGION), (Object)true);
    }

    private final Function3<Integer, Integer, FoldingInfo, Boolean> G(boolean bl) {
        if (bl) {
            Function1 function1 = (Function1)this.isExpandedCallbackFactory.invoke();
            return (arg_0, arg_1, arg_2) -> FrontendEditorFoldingModelAdapter.G(function1, arg_0, arg_1, arg_2);
        }
        if (this.G()) {
            Function1 function1 = (Function1)this.isExpandedCallbackFactory.invoke();
            return (arg_0, arg_1, arg_2) -> FrontendEditorFoldingModelAdapter.G(this, function1, arg_0, arg_1, arg_2);
        }
        return FrontendEditorFoldingModelAdapter::G;
    }

    private final void G(int n, int n2, FoldingInfo foldingInfo, boolean bl, boolean bl2, List<? extends FoldRegion> list2) {
        Ref ref = new Ref();
        for (FoldRegion foldRegion2 : list2) {
            this.G(foldRegion2, foldingInfo, (Ref<Triple<FoldRegion, Boolean, Boolean>>)ref);
        }
        FoldRegion foldRegion = null;
        if (ref.isNull()) {
            this.G(n, n2, redFromBackend);
            foldRegion = this.createNewRegionOrIgnore(n, n2, foldingInfo, bl || bl2);
        } else {
            Triple triple = (Triple)ref.get();
            FoldRegion foldRegion2 = (FoldRegion)triple.component1();
            boolean bl3 = (Boolean)triple.component2();
            boolean bl4 = (Boolean)triple.component3();
            if (bl4) {
                this.G(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), greenMergedWithExisting);
                foldRegion = foldRegion2;
            } else {
                this.G(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), blueMergedWithCreatedByFrontend);
                foldRegion = this.createNewRegionOrIgnore(foldRegion2.getStartOffset(), foldRegion2.getEndOffset(), foldingInfo, bl3 || bl2);
            }
        }
        if (foldRegion != null) {
            if (bl2 && !foldRegion.isExpanded()) {
                this.G(n, n2, cyanExoticStateFromFrontend);
                foldRegion.setExpanded(true);
            }
            foldingInfo.getRegions().add((Object)foldRegion);
        }
    }

    private final boolean G(int n, int n2) {
        for (Caret caret : this.editor.getCaretModel().getAllCarets()) {
            int n3 = caret.getOffset();
            if (n3 == 0) continue;
            boolean bl = n + 1 <= n3 ? n3 < n2 : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighterEx> highlighters) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            Iterable iterable = highlighters;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
                    boolean bl3 = false;
                    if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.G(this, highlighters));
    }

    @Override
    public final void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        LocalChangeKt.ignoreOnReentrancy(FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0<Unit>)((Function0)() -> FrontendEditorFoldingModelAdapter.G(this, highlighter)));
    }

    private final void G(RangeHighlighterEx rangeHighlighterEx) {
        Object v1;
        SmartList<FoldRegion> smartList;
        FoldingInfo foldingInfo;
        block5: {
            FoldingInfo foldingInfo2 = FoldingInfoKt.getFoldingInfo((RangeHighlighter)rangeHighlighterEx);
            if (foldingInfo2 == null) {
                return;
            }
            foldingInfo = foldingInfo2;
            smartList = foldingInfo.getRegions();
            Iterable iterable = (Iterable)smartList;
            for (Object t : iterable) {
                FoldRegion foldRegion = (FoldRegion)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)foldRegion.getEditor(), (Object)this.editor)) continue;
                v1 = t;
                break block5;
            }
            v1 = null;
        }
        FoldRegion foldRegion = v1;
        if (foldRegion == null) {
            return;
        }
        FoldRegion foldRegion2 = foldRegion;
        if (this.canBeReused(foldRegion2, foldingInfo)) {
            if (this.getApplyIsExpandedUpdatesFromBackend() && foldRegion2.isExpanded() == foldingInfo.getCollapsedByDefault()) {
                this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.G(foldRegion2, foldingInfo));
            }
            return;
        }
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> FrontendEditorFoldingModelAdapter.G(foldRegion2, smartList, this, rangeHighlighterEx, foldingInfo));
    }

    protected boolean canBeReused(@NotNull FoldRegion oldRegion, @NotNull FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)oldRegion, (String)"oldRegion");
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        if (!Intrinsics.areEqual((Object)oldRegion.getPlaceholderText(), (Object)foldingInfo.getPlaceholderText())) {
            return false;
        }
        FoldingGroup foldingGroup = oldRegion.getGroup();
        Long l = foldingInfo.getGroupId();
        if (foldingGroup != null && l != null) {
            FoldingGroup foldingGroup2;
            FoldingGroup foldingGroup3 = foldingGroup;
            Map<Long, FoldingGroup> map = this.groups;
            boolean bl = false;
            FoldingGroup foldingGroup4 = map.get(l);
            if (foldingGroup4 == null) {
                FoldingGroup foldingGroup5 = foldingGroup3;
                boolean bl2 = false;
                foldingGroup3 = foldingGroup5;
                FoldingGroup foldingGroup6 = foldingGroup;
                map.put(l, foldingGroup6);
                foldingGroup2 = foldingGroup6;
            } else {
                foldingGroup2 = foldingGroup4;
            }
            return Intrinsics.areEqual((Object)foldingGroup3, (Object)foldingGroup2);
        }
        if (oldRegion.shouldNeverExpand() != foldingInfo.getNeverExpands()) {
            return false;
        }
        return foldingGroup == null && l == null;
    }

    @Nullable
    protected FoldRegion createNewRegionOrIgnore(int start, int end, @NotNull FoldingInfo foldingInfo, boolean isExpanded) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        FoldRegion foldRegion = this.createFoldRegion(start, end, foldingInfo);
        if (foldRegion == null) {
            logger.warn("Unable to insert (" + start + ", " + end + ") in the folding tree. Maybe the duplicate range already/still exist.");
            return null;
        }
        foldRegion.setExpanded(isExpanded && !foldingInfo.getNeverExpands());
        return foldRegion;
    }

    @Nullable
    protected FoldRegion createFoldRegion(int start, int end, @NotNull FoldingInfo info2) {
        FoldRegion foldRegion;
        block4: {
            FoldingGroup foldingGroup;
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            Long l = info2.getGroupId();
            if (l != null) {
                FoldingGroup foldingGroup2;
                long l2 = ((Number)l).longValue();
                boolean bl = false;
                Map<Long, FoldingGroup> map = this.groups;
                Long l3 = l2;
                boolean bl2 = false;
                FoldingGroup foldingGroup3 = map.get(l3);
                if (foldingGroup3 == null) {
                    boolean bl3 = false;
                    FoldingGroup foldingGroup4 = FoldingGroup.newGroup((String)String.valueOf(l2));
                    Intrinsics.checkNotNullExpressionValue((Object)foldingGroup4, (String)"newGroup(...)");
                    FoldingGroup foldingGroup5 = foldingGroup4;
                    map.put(l3, foldingGroup5);
                    foldingGroup2 = foldingGroup5;
                } else {
                    foldingGroup2 = foldingGroup3;
                }
                foldingGroup = foldingGroup2;
            } else {
                foldingGroup = null;
            }
            FoldingGroup foldingGroup6 = foldingGroup;
            FoldRegion foldRegion2 = foldRegion = this.foldingModel.createFoldRegion(start, end, info2.getPlaceholderText(), foldingGroup6, info2.getNeverExpands());
            if (foldRegion2 == null) break block4;
            FoldRegion foldRegion3 = foldRegion2;
            boolean bl = false;
            this.G(info2, foldRegion);
        }
        return foldRegion;
    }

    private final void G(FoldingInfo foldingInfo, FoldRegion foldRegion) {
        if (FoldingInfoKt.isDocComment(foldingInfo)) {
            FoldingInfoKt.markAsDocComment(foldRegion);
        }
        if (FoldingInfoKt.isDefinition(foldingInfo)) {
            FoldingInfoKt.markAsDefinition(foldRegion);
        }
        if (FoldingInfoKt.isCodeBlock(foldingInfo)) {
            FoldingInfoKt.markAsCodeBlock(foldRegion);
        }
        ((CodeFoldingManagerImpl)this.foldingManager.getValue()).setCollapsedByDefault(foldRegion, foldingInfo.getCollapsedByDefault());
        CodeFoldingManagerImpl.markAsAutoCreated((FoldRegion)foldRegion);
    }

    private static final CodeFoldingManagerImpl G(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter) {
        CodeFoldingManager codeFoldingManager = CodeFoldingManager.getInstance((Project)frontendEditorFoldingModelAdapter.editor.getProject());
        Intrinsics.checkNotNull((Object)codeFoldingManager, (String)"null cannot be cast to non-null type com.intellij.codeInsight.folding.impl.CodeFoldingManagerImpl");
        return (CodeFoldingManagerImpl)codeFoldingManager;
    }

    private static final Unit G(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2) {
        frontendEditorFoldingModelAdapter.G(list2);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void b(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2) {
        boolean bl;
        Iterable iterable;
        boolean bl2;
        Object object = logger;
        boolean bl3 = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            bl2 = false;
            iterable = list2;
            int n = list2.size();
            bl = false;
            Iterable iterable2 = iterable;
            Collection collection2 = new ArrayList();
            boolean bl4 = false;
            Iterator iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t;
                boolean bl5 = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                collection2.add(t);
            }
            List list3 = (List)collection2;
            logger.trace("doAfterBulkAdd (runBatchFoldingOperation): allHighlighters=" + n + ", foldings=" + list3.size());
        }
        if (frontendEditorFoldingModelAdapter._initialized) {
            frontendEditorFoldingModelAdapter.addFoldings(list2);
        } else {
            Iterable iterable3 = list2;
            bl2 = false;
            iterable = iterable3;
            Collection collection = new ArrayList();
            bl = false;
            for (Collection collection2 : iterable) {
                RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)collection2;
                boolean bl6 = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                collection.add(collection2);
            }
            object = (List)collection;
            if (!((Collection)object).isEmpty()) {
                Object object2 = frontendEditorFoldingModelAdapter.lock;
                synchronized (object2) {
                    boolean bl7 = false;
                    try {
                        CodeFoldingManagerImpl.markAsAsyncFoldingUpdater((Editor)frontendEditorFoldingModelAdapter.editor);
                        frontendEditorFoldingModelAdapter.initFoldings((List<? extends RangeHighlighter>)object);
                    }
                    finally {
                        frontendEditorFoldingModelAdapter._initialized = true;
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
    }

    private static final void G(List list2, Function3 function3, FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter) {
        for (RangeHighlighter rangeHighlighter : list2) {
            Object t2;
            FoldingInfo foldingInfo;
            block2: {
                Intrinsics.checkNotNull((Object)FoldingInfoKt.getFoldingInfo(rangeHighlighter));
                Iterable iterable = (Iterable)foldingInfo.getRegions();
                boolean bl = false;
                for (Object t2 : iterable) {
                    FoldRegion foldRegion = (FoldRegion)t2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)foldRegion.getEditor(), (Object)frontendEditorFoldingModelAdapter.editor)) continue;
                    break block2;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            FoldRegion foldRegion = (FoldRegion)t2;
            foldRegion.setExpanded(((Boolean)function3.invoke((Object)rangeHighlighter.getStartOffset(), (Object)rangeHighlighter.getEndOffset(), (Object)foldingInfo)).booleanValue());
        }
    }

    private static final boolean G(Function1 function1, int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        return (Boolean)function1.invoke((Object)foldingInfo);
    }

    private static final boolean G(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, Function1 function1, int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"foldingInfo");
        frontendEditorFoldingModelAdapter.G(n, n2, cyanExoticStateFromFrontend);
        Boolean bl = frontendEditorFoldingModelAdapter.foldingRestoreRecords.get(new FoldingRestoreRecord(n, n2, foldingInfo.getAttributeId(), foldingInfo.getPlaceholderText()));
        return bl != null ? bl.booleanValue() : ((Boolean)function1.invoke((Object)foldingInfo)).booleanValue();
    }

    private static final boolean G(int n, int n2, FoldingInfo foldingInfo) {
        Intrinsics.checkNotNullParameter((Object)foldingInfo, (String)"<unused var>");
        return true;
    }

    private static final void G(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, List list2) {
        boolean bl;
        RangeHighlighterEx rangeHighlighterEx;
        boolean bl2;
        Object object;
        Iterable iterable;
        Iterable iterable2;
        Logger logger = FrontendEditorFoldingModelAdapter.logger;
        boolean bl3 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            boolean bl4 = false;
            iterable2 = list2;
            int n = list2.size();
            boolean bl5 = false;
            iterable = iterable2;
            object = new ArrayList();
            bl2 = false;
            for (Object object2 : iterable) {
                rangeHighlighterEx = (RangeHighlighterEx)object2;
                bl = false;
                if (!HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) continue;
                object.add(object2);
            }
            List list3 = (List)object;
            logger2.trace("beforeBulkRemove (runBatchFoldingOperation): allHighlighters=" + n + ", foldings=" + list3.size());
        }
        boolean bl6 = frontendEditorFoldingModelAdapter.G();
        for (RangeHighlighterEx rangeHighlighterEx2 : list2) {
            FoldRegion foldRegion;
            Object v0;
            SmartList<FoldRegion> smartList;
            block6: {
                if (FoldingInfoKt.getFoldingInfo((RangeHighlighter)rangeHighlighterEx2) == null) continue;
                smartList = ((FoldingInfo)((Object)iterable2)).getRegions();
                object = (Iterable)smartList;
                bl2 = false;
                Iterator<Object> iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    Object object2;
                    object2 = iterator2.next();
                    rangeHighlighterEx = (FoldRegion)object2;
                    bl = false;
                    if (!Intrinsics.areEqual((Object)rangeHighlighterEx.getEditor(), (Object)frontendEditorFoldingModelAdapter.editor)) continue;
                    v0 = object2;
                    break block6;
                }
                v0 = null;
            }
            if ((FoldRegion)v0 == null) continue;
            smartList.remove((Object)foldRegion);
            if (!foldRegion.isValid()) continue;
            if (bl6 && foldRegion.isExpanded() == ((FoldingInfo)((Object)iterable2)).getCollapsedByDefault()) {
                frontendEditorFoldingModelAdapter.foldingRestoreRecords.put(new FoldingRestoreRecord(rangeHighlighterEx2.getStartOffset(), rangeHighlighterEx2.getEndOffset(), ((FoldingInfo)((Object)iterable2)).getAttributeId(), ((FoldingInfo)((Object)iterable2)).getPlaceholderText()), foldRegion.isExpanded());
            }
            if ((iterable = foldRegion.getGroup()) != null && frontendEditorFoldingModelAdapter.foldingModel.getGroupedRegions((FoldingGroup)iterable).size() == 1) {
                object = frontendEditorFoldingModelAdapter.groups;
                Long l = ((FoldingInfo)((Object)iterable2)).getGroupId();
                TypeIntrinsics.asMutableMap((Object)object).remove(l);
            }
            frontendEditorFoldingModelAdapter.foldingModel.removeFoldRegion(foldRegion);
        }
    }

    private static final Unit G(FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, RangeHighlighterEx rangeHighlighterEx) {
        frontendEditorFoldingModelAdapter.G(rangeHighlighterEx);
        return Unit.INSTANCE;
    }

    private static final void G(FoldRegion foldRegion, FoldingInfo foldingInfo) {
        foldRegion.setExpanded(!foldingInfo.getCollapsedByDefault());
    }

    private static final void G(FoldRegion foldRegion, SmartList smartList, FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter, RangeHighlighterEx rangeHighlighterEx, FoldingInfo foldingInfo) {
        block1: {
            FoldRegion foldRegion2;
            Logger logger = FrontendEditorFoldingModelAdapter.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("doAfterUpdated (runBatchFoldingOperation): a single folding");
            }
            boolean bl3 = foldRegion.isExpanded();
            smartList.remove((Object)foldRegion);
            frontendEditorFoldingModelAdapter.foldingModel.removeFoldRegion(foldRegion);
            FoldRegion foldRegion3 = foldRegion2 = frontendEditorFoldingModelAdapter.createNewRegionOrIgnore(rangeHighlighterEx.getStartOffset(), rangeHighlighterEx.getEndOffset(), foldingInfo, frontendEditorFoldingModelAdapter.getApplyIsExpandedUpdatesFromBackend() ? !foldingInfo.getCollapsedByDefault() : bl3);
            if (foldRegion3 == null) break block1;
            FoldRegion foldRegion4 = foldRegion3;
            boolean bl4 = false;
            smartList.add((Object)foldRegion2);
        }
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        Key key = Key.create((String)"RESTORE_FOLDING_STATE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        RESTORE_FOLDING_STATE = key;
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendEditorFoldingModelAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendEditorFoldingModelAdapter.logger = logger;
        redFromBackend = new TextAttributes();
        greenMergedWithExisting = new TextAttributes();
        blueMergedWithCreatedByFrontend = new TextAttributes();
        cyanExoticStateFromFrontend = new TextAttributes();
        redFromBackend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.RED);
        greenMergedWithExisting.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.GREEN);
        blueMergedWithCreatedByFrontend.withAdditionalEffect(EffectType.ROUNDED_BOX, (Color)JBColor.BLUE);
        cyanExoticStateFromFrontend.withAdditionalEffect(EffectType.WAVE_UNDERSCORE, JBColor.CYAN);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u00020\f8\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendEditorFoldingModelAdapter$Companion;", "", "FrontendEditorFoldingModelAdapter$Companion", "()V", "RESTORE_FOLDING_STATE", "Lcom/intellij/openapi/util/Key;", "", "setReloadingState", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "redFromBackend", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "getRedFromBackend", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "greenMergedWithExisting", "getGreenMergedWithExisting", "blueMergedWithCreatedByFrontend", "getBlueMergedWithCreatedByFrontend", "cyanExoticStateFromFrontend", "getCyanExoticStateFromFrontend", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public final void setReloadingState(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            RESTORE_FOLDING_STATE.set((UserDataHolder)editor, (Object)true);
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        @NotNull
        public final TextAttributes getRedFromBackend() {
            return redFromBackend;
        }

        @NotNull
        public final TextAttributes getGreenMergedWithExisting() {
            return greenMergedWithExisting;
        }

        @NotNull
        public final TextAttributes getBlueMergedWithCreatedByFrontend() {
            return blueMergedWithCreatedByFrontend;
        }

        @NotNull
        public final TextAttributes getCyanExoticStateFromFrontend() {
            return cyanExoticStateFromFrontend;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

