/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters.foldings;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.CodeFoldingEventsModel;
import com.jetbrains.rd.ide.model.FoldRegionStateChangeEvent;
import com.jetbrains.rd.ide.model.RdMarkupModel;
import com.jetbrains.rd.ui.bedsl.extensions.LocalChangeKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.IFrontendProtocolMarkupExtension;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelSupport;
import com.jetbrains.rdclient.daemon.highlighters.MarkupListenerManager;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingManager;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelHandler;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendCodeFoldingModelSupportKt;
import com.jetbrains.rdclient.daemon.highlighters.foldings.FrontendEditorFoldingModelAdapter;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J4\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelSupport;", "FrontendCodeFoldingModelSupport", "()V", "createHandler", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "markupModel", "Lcom/jetbrains/rd/ide/model/RdMarkupModel;", "document", "Lcom/intellij/openapi/editor/Document;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "MyFoldingListener", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendCodeFoldingModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n15#2:125\n15#2:126\n*S KotlinDebug\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport\n*L\n58#1:125\n33#1:126\n*E\n"})
public class FrontendCodeFoldingModelSupport
implements IProtocolHighlighterModelSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @Override
    @Nullable
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session, @NotNull RdMarkupModel markupModel, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)markupModel), (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return null;
    }

    @Override
    @Nullable
    public IProtocolHighlighterModelHandler createHandler(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull ClientAppSession session, @NotNull RdMarkupModel markupModel, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)markupModel), (String)"markupModel");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Function0<Function1<FoldingInfo, Boolean>> function0 = FrontendCodeFoldingManager.Companion.getInstance().getFoldingExpandedCallbackFactory();
        FrontendEditorFoldingModelAdapter frontendEditorFoldingModelAdapter = new FrontendEditorFoldingModelAdapter(editor, function0);
        MarkupListenerManager.Companion.getInstance().attachListener(lifetime, editor, frontendEditorFoldingModelAdapter);
        if (editor instanceof EditorEx) {
            CodeFoldingEventsModel codeFoldingEventsModel = (CodeFoldingEventsModel)((Object)IFrontendProtocolMarkupExtension.Companion.getExtension(markupModel, FrontendCodeFoldingModelSupportKt.access$getCODE_FOLDING_EVENTS_MODEL_EXTENSION_KEY$p()));
            ((EditorEx)editor).getFoldingModel().addListener((FoldingListener)new MyFoldingListener((EditorEx)editor, codeFoldingEventsModel), LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        } else {
            boolean bl = false;
            Logger logger = Logger.getInstance(FrontendCodeFoldingModelSupport.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot sync foldings state because the editor doesn't implement EditorEx interface: editor.class=" + editor.getClass().getSimpleName());
        }
        return new FrontendCodeFoldingModelHandler();
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendCodeFoldingModelSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$Companion;", "", "FrontendCodeFoldingModelSupport$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$MyFoldingListener;", "Lcom/intellij/openapi/editor/ex/FoldingListener;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "codeFoldingEventsModel", "Lcom/jetbrains/rd/ide/model/CodeFoldingEventsModel;", "FrontendCodeFoldingModelSupport$MyFoldingListener", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/jetbrains/rd/ide/model/CodeFoldingEventsModel;)V", "changesAccumulator", "", "Lcom/jetbrains/rd/ide/model/FoldRegionStateChangeEvent;", "onFoldRegionStateChange", "", "region", "Lcom/intellij/openapi/editor/FoldRegion;", "onFoldProcessingEnd", "G", "", "(Lcom/intellij/openapi/editor/FoldRegion;)Ljava/lang/Long;", "intellij.rd.client"})
    @SourceDebugExtension(value={"SMAP\nFrontendCodeFoldingModelSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$MyFoldingListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,124:1\n69#2,4:125\n*S KotlinDebug\n*F\n+ 1 FrontendCodeFoldingModelSupport.kt\ncom/jetbrains/rdclient/daemon/highlighters/foldings/FrontendCodeFoldingModelSupport$MyFoldingListener\n*L\n75#1:125,4\n*E\n"})
    private static final class MyFoldingListener
    implements FoldingListener {
        @NotNull
        private final EditorEx editor;
        @NotNull
        private final CodeFoldingEventsModel codeFoldingEventsModel;
        @NotNull
        private final List<FoldRegionStateChangeEvent> changesAccumulator;

        public MyFoldingListener(@NotNull EditorEx editor, @NotNull CodeFoldingEventsModel codeFoldingEventsModel) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)((Object)codeFoldingEventsModel), (String)"codeFoldingEventsModel");
            this.editor = editor;
            this.codeFoldingEventsModel = codeFoldingEventsModel;
            this.changesAccumulator = new ArrayList();
        }

        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            Intrinsics.checkNotNullParameter((Object)region, (String)"region");
            LocalChangeKt.ignoreOnReentrancy(FrontendCodeFoldingModelSupportKt.getFoldingStateChangeFromBackend(), (Function0<Unit>)((Function0)() -> MyFoldingListener.G(this, region)));
        }

        public void onFoldProcessingEnd() {
            if (this.changesAccumulator.isEmpty()) {
                return;
            }
            this.codeFoldingEventsModel.getFoldRegionsStatesChanged().fire(this.changesAccumulator);
            this.changesAccumulator.clear();
        }

        private final Long G(FoldRegion foldRegion) {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(foldRegion.getStartOffset(), foldRegion.getEndOffset(), arg_0 -> MyFoldingListener.G(foldRegion, objectRef, arg_0));
            return (Long)objectRef.element;
        }

        private static final Unit G(MyFoldingListener myFoldingListener, FoldRegion foldRegion) {
            Long l = myFoldingListener.G(foldRegion);
            if (l == null) {
                MyFoldingListener myFoldingListener2 = myFoldingListener;
                boolean bl = false;
                Logger logger = LOG;
                boolean bl2 = false;
                if (logger.isTraceEnabled()) {
                    Logger logger2 = logger;
                    boolean bl3 = false;
                    logger2.trace("backendId was not for FoldRegion (" + foldRegion.getStartOffset() + ", " + foldRegion.getEndOffset() + ")");
                }
                return Unit.INSTANCE;
            }
            long l2 = l;
            myFoldingListener.changesAccumulator.add(new FoldRegionStateChangeEvent(l2, foldRegion.isExpanded()));
            return Unit.INSTANCE;
        }

        private static final boolean G(FoldRegion foldRegion, Ref.ObjectRef objectRef, RangeHighlighterEx rangeHighlighterEx) {
            if (rangeHighlighterEx.getStartOffset() == foldRegion.getStartOffset() && rangeHighlighterEx.getEndOffset() == foldRegion.getEndOffset()) {
                Intrinsics.checkNotNull((Object)rangeHighlighterEx);
                if (HighlightersUtilKt.isBackendFolding((RangeHighlighter)rangeHighlighterEx)) {
                    objectRef.element = UtilKt.getBackendId((RangeHighlighter)rangeHighlighterEx);
                    return false;
                }
            }
            return true;
        }
    }
}

