/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon.highlighters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "MarkupListenerAggregator", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Document;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "_listeners", "", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "listeners", "", "getListeners", "()Ljava/util/List;", "createListener", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "canHandleEditor", "", "handleEditor", "", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nMarkupListenerAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupListenerAggregator.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,42:1\n15#2:43\n*S KotlinDebug\n*F\n+ 1 MarkupListenerAggregator.kt\ncom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator\n*L\n16#1:43\n*E\n"})
public abstract class MarkupListenerAggregator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final Document document;
    @NotNull
    private final List<FrontendMarkupAdapterListener> _listeners;
    @NotNull
    private static final Logger logger;

    public MarkupListenerAggregator(@Nullable Project project, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.project = project;
        this.document = document;
        this._listeners = new ArrayList();
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    @NotNull
    public final List<FrontendMarkupAdapterListener> getListeners() {
        return this._listeners;
    }

    @NotNull
    protected abstract FrontendMarkupAdapterListener createListener(@NotNull Lifetime var1, @NotNull EditorImpl var2);

    public abstract boolean canHandleEditor(@NotNull EditorImpl var1);

    public final void handleEditor(@NotNull Lifetime lifetime, @NotNull EditorImpl editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        FrontendMarkupAdapterListener frontendMarkupAdapterListener = this.createListener(lifetime, editor);
        logger.debug("Creating " + frontendMarkupAdapterListener + " for editor: " + editor);
        this._listeners.add(frontendMarkupAdapterListener);
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, this.document);
        Intrinsics.checkNotNull((Object)frontendMarkupContributor);
        FrontendMarkupAdapter frontendMarkupAdapter = frontendMarkupContributor.getMarkupAdapter();
        frontendMarkupAdapterListener.afterBulkAdd(ArraysKt.toList((Object[])frontendMarkupAdapter.getAllHighlighters()));
        lifetime.onTermination(() -> MarkupListenerAggregator.G(editor, frontendMarkupAdapterListener, frontendMarkupAdapter, this));
        frontendMarkupAdapter.addListener(lifetime, frontendMarkupAdapterListener);
    }

    private static final Unit G(EditorImpl editorImpl, FrontendMarkupAdapterListener frontendMarkupAdapterListener, FrontendMarkupAdapter frontendMarkupAdapter, MarkupListenerAggregator markupListenerAggregator) {
        if (!editorImpl.isDisposed()) {
            frontendMarkupAdapterListener.beforeBulkRemove(ArraysKt.toList((Object[])frontendMarkupAdapter.getAllHighlighters()));
        }
        markupListenerAggregator._listeners.remove(frontendMarkupAdapterListener);
        logger.debug("Removing " + frontendMarkupAdapterListener + " for editor: " + editorImpl);
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(MarkupListenerAggregator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkupListenerAggregator.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/highlighters/MarkupListenerAggregator$Companion;", "", "MarkupListenerAggregator$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

