/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.ConstrainedInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rd.ide.model.HintInlayHighlighterModel;
import com.jetbrains.rd.ide.model.HorizontalConstraintsModel;
import com.jetbrains.rd.ide.model.InlayConstraintsModel;
import com.jetbrains.rd.platform.util.IDocumentRangeShifter;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.CompoundHighlighterModelsHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import com.jetbrains.rdclient.document.DocumentExKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0017J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u001a\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0002J\u0018\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0006\u0010 \u001a\u00020!J\u0013\u0010\"\u001a\u0004\u0018\u00010\u001d*\u00020#H\u0002\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "document", "Lcom/intellij/openapi/editor/Document;", "compoundHandler", "Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "HighlighterRangeRepairer", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "documentSynchronizer", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "G", "()Lcom/jetbrains/rd/ide/document/DocumentSynchronizer;", "documentSynchronizer$delegate", "Lkotlin/Lazy;", "shifter", "Lcom/jetbrains/rd/platform/util/IDocumentRangeShifter;", "repair", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "model", "G", "Lcom/intellij/openapi/util/TextRange;", "h", "G", "", "correctedRange", "b", "shrinkHistory", "", "G", "Lcom/jetbrains/rd/ide/model/ConstrainedInlayHighlighterModel;", "(Lcom/jetbrains/rd/ide/model/ConstrainedInlayHighlighterModel;)Ljava/lang/Boolean;", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nHighlighterRangeRepairer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HighlighterRangeRepairer.kt\ncom/jetbrains/rdclient/daemon/HighlighterRangeRepairer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n15#2:88\n*S KotlinDebug\n*F\n+ 1 HighlighterRangeRepairer.kt\ncom/jetbrains/rdclient/daemon/HighlighterRangeRepairer\n*L\n21#1:88\n*E\n"})
public final class HighlighterRangeRepairer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Document document;
    @NotNull
    private final CompoundHighlighterModelsHandler compoundHandler;
    @NotNull
    private final Lazy documentSynchronizer$delegate;
    @NotNull
    private final IDocumentRangeShifter shifter;
    @NotNull
    private static final Logger LOG;

    public HighlighterRangeRepairer(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull Document document, @NotNull CompoundHighlighterModelsHandler compoundHandler) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)compoundHandler, (String)"compoundHandler");
        this.lifetime = lifetime;
        this.document = document;
        this.compoundHandler = compoundHandler;
        this.documentSynchronizer$delegate = LazyKt.lazy(() -> HighlighterRangeRepairer.G(this, session));
        this.shifter = this.G().createRangeShifter();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    private final DocumentSynchronizer G() {
        Lazy lazy = this.documentSynchronizer$delegate;
        return (DocumentSynchronizer)lazy.getValue();
    }

    @Nullable
    public final HighlighterModel repair(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        if (model.getId() < 0L) {
            return model;
        }
        TextRange textRange = this.G(model);
        if (textRange == null || !this.G(textRange, model)) {
            return null;
        }
        if (textRange.getStartOffset() == model.getStart() && textRange.getEndOffset() == model.getEnd()) {
            return model;
        }
        return this.compoundHandler.move(textRange.getStartOffset(), textRange.getEndOffset(), model);
    }

    private final TextRange G(HighlighterModel highlighterModel) {
        AbstractDocumentVersion abstractDocumentVersion = highlighterModel.getDocumentVersion();
        if (highlighterModel.getStart() == highlighterModel.getEnd()) {
            boolean bl;
            HintInlayHighlighterModel hintInlayHighlighterModel = highlighterModel instanceof HintInlayHighlighterModel ? (HintInlayHighlighterModel)highlighterModel : null;
            if (hintInlayHighlighterModel != null) {
                bl = hintInlayHighlighterModel.getRelatesToPrecedingText();
            } else {
                ConstrainedInlayHighlighterModel constrainedInlayHighlighterModel = highlighterModel instanceof ConstrainedInlayHighlighterModel ? (ConstrainedInlayHighlighterModel)highlighterModel : null;
                Boolean bl2 = constrainedInlayHighlighterModel != null ? this.G(constrainedInlayHighlighterModel) : null;
                bl = bl2 != null ? bl2 : false;
            }
            boolean bl3 = bl;
            int n = this.shifter.shiftOnePoint(abstractDocumentVersion, highlighterModel.getStart(), bl3);
            return n == -1 ? null : new TextRange(n, n);
        }
        TextRange textRange = new TextRange(highlighterModel.getStart(), highlighterModel.getEnd());
        boolean bl = highlighterModel.getProperties().isVerifiable();
        return this.shifter.shiftRange(abstractDocumentVersion, textRange, bl, highlighterModel.isGreedyToLeft(), highlighterModel.isGreedyToRight());
    }

    private final boolean G(TextRange textRange, HighlighterModel highlighterModel) {
        if (textRange == null) {
            LOG.debug("Received invalid highlighter. Unrolling " + HighlightersUtilKt.prettyPrint(highlighterModel));
            return false;
        }
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.document.getTextLength()) {
            LOG.error("Corrected range:" + textRange + " for highlighter:" + HighlightersUtilKt.prettyPrint(highlighterModel) + ",text:\"" + highlighterModel.getTextToHighlight() + "\"} is shifted out of the document (0," + this.document.getTextLength() + ")");
            return false;
        }
        return !highlighterModel.getProperties().isVerifiable() || this.b(textRange, highlighterModel);
    }

    private final boolean b(TextRange textRange, HighlighterModel highlighterModel) {
        String string = highlighterModel.getTextToHighlight();
        CharSequence charSequence = string;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        if (textRange.getEndOffset() > this.document.getTextLength()) {
            return false;
        }
        charSequence = this.document.getImmutableCharSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
        boolean bl = string.contentEquals(charSequence);
        if (!bl) {
            AbstractDocumentVersion abstractDocumentVersion = this.G().getVersion();
            AbstractDocumentVersion abstractDocumentVersion2 = highlighterModel.getDocumentVersion();
            LOG.error("Highlighter " + HighlightersUtilKt.prettyPrint(highlighterModel) + " is applied to the wrong text.\n Versions: document=" + abstractDocumentVersion + " highlighter=" + abstractDocumentVersion2 + "\nText: \nbackend=\"" + string + "\"\nfrontend=\"" + charSequence + "\"");
        }
        return bl;
    }

    public final void shrinkHistory() {
        this.shifter.shrinkHistory();
    }

    private final Boolean G(ConstrainedInlayHighlighterModel constrainedInlayHighlighterModel) {
        InlayConstraintsModel inlayConstraintsModel = constrainedInlayHighlighterModel.getConstraints();
        HorizontalConstraintsModel horizontalConstraintsModel = inlayConstraintsModel instanceof HorizontalConstraintsModel ? (HorizontalConstraintsModel)inlayConstraintsModel : null;
        return horizontalConstraintsModel != null ? Boolean.valueOf(horizontalConstraintsModel.getRelatesToPrecedingText()) : null;
    }

    private static final DocumentSynchronizer G(HighlighterRangeRepairer highlighterRangeRepairer, ClientAppSession clientAppSession) {
        DocumentSynchronizer documentSynchronizer = DocumentExKt.getDocumentSynchronizer(highlighterRangeRepairer.document, clientAppSession);
        Intrinsics.checkNotNull((Object)documentSynchronizer);
        return documentSynchronizer;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(HighlighterRangeRepairer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/HighlighterRangeRepairer$Companion;", "", "HighlighterRangeRepairer$Companion", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

