/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.rd.ide.model.BackendDaemonStateEnum;
import com.jetbrains.rd.ide.model.HeavyProcessTypeModel;
import com.jetbrains.rd.ide.model.RdDaemonModel;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.FrontendBundle;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererExtension;
import com.jetbrains.rdclient.daemon.FrontendTrafficLightRendererKt;
import com.jetbrains.rdclient.services.IdeBackend;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\u001a\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "backend", "Lcom/jetbrains/rdclient/services/IdeBackend;", "model", "Lcom/jetbrains/rd/ide/model/RdDaemonModel;", "extensions", "", "Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "FrontendTrafficLightRenderer", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/jetbrains/rdclient/services/IdeBackend;Lcom/jetbrains/rd/ide/model/RdDaemonModel;[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;)V", "[Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRendererExtension;", "fillDaemonCodeAnalyzerErrorsStatus", "", "status", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DaemonCodeAnalyzerStatus;", "severityRegistrar", "Lcom/intellij/codeInsight/daemon/impl/SeverityRegistrar;", "isValid", "", "b", "()Z", "G", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nFrontendTrafficLightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,125:1\n1310#2,2:126\n69#3,4:128\n15#3:132\n*S KotlinDebug\n*F\n+ 1 FrontendTrafficLightRenderer.kt\ncom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer\n*L\n39#1:126,2\n103#1:128,4\n30#1:132\n*E\n"})
public final class FrontendTrafficLightRenderer
extends TrafficLightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final PsiFile psiFile;
    @NotNull
    private final IdeBackend backend;
    @NotNull
    private final RdDaemonModel model;
    @NotNull
    private final FrontendTrafficLightRendererExtension[] extensions;
    @NotNull
    private static final Logger logger;

    public FrontendTrafficLightRenderer(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile psiFile, @NotNull IdeBackend backend, @NotNull RdDaemonModel model, @NotNull FrontendTrafficLightRendererExtension[] extensions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)extensions, (String)"extensions");
        super(project, editor);
        this.psiFile = psiFile;
        this.backend = backend;
        this.model = model;
        this.extensions = extensions;
    }

    protected void fillDaemonCodeAnalyzerErrorsStatus(@NotNull TrafficLightRenderer.DaemonCodeAnalyzerStatus status, @NotNull SeverityRegistrar severityRegistrar) {
        Logger logger;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)severityRegistrar, (String)"severityRegistrar");
        if (this.b() && !this.G() || !InterfacesKt.getHasValue((IOptPropertyView)((IOptPropertyView)this.model.getState()))) {
            status.reasonWhySuspended = FrontendBundle.INSTANCE.message("loading.solution.components", new Object[0]);
            status.errorAnalyzingFinished = true;
        } else {
            Object object;
            block18: {
                FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension;
                object = this.extensions;
                bl = false;
                int n = ((FrontendTrafficLightRendererExtension[])object).length;
                for (int j = 0; j < n; ++j) {
                    FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension2;
                    FrontendTrafficLightRendererExtension frontendTrafficLightRendererExtension3 = frontendTrafficLightRendererExtension2 = object[j];
                    boolean bl2 = false;
                    if (!frontendTrafficLightRendererExtension3.isAvailable()) continue;
                    frontendTrafficLightRendererExtension = frontendTrafficLightRendererExtension2;
                    break block18;
                }
                frontendTrafficLightRendererExtension = logger = null;
            }
            if (logger != null) {
                status.reasonWhySuspended = logger.getTooltip();
                status.errorAnalyzingFinished = true;
                return;
            }
            object = (BackendDaemonStateEnum)((Object)this.model.getState().getValueOrNull());
            if (status.errorAnalyzingFinished) {
                Object object2 = object;
                switch (object2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()]) {
                    case -1: {
                        break;
                    }
                    case 1: {
                        if (status.reasonWhyDisabled == null) break;
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.not.supported.for.this.file", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 2: {
                        status.reasonWhyDisabled = FrontendBundle.INSTANCE.message("analysis.is.unsupported.for.document", new Object[0]);
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 3: {
                        Object object3;
                        Object object4 = (String)this.model.getMessage().getValue();
                        if (object4 == null && (object4 = status.reasonWhyDisabled) == null) {
                            object4 = object3 = "";
                        }
                        if (!(((CharSequence)(object3 = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)object3))).toString())).length() == 0)) {
                            object3 = (String)object3 + (StringsKt.endsWith$default((String)object3, (String)"", (boolean)false, (int)2, null) ? " " : " ");
                        }
                        status.reasonWhyDisabled = object3;
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 4: {
                        String string = (String)this.model.getMessage().getValue();
                        if (string == null && (string = status.reasonWhySuspended) == null) {
                            string = "Code analysis suspended";
                        }
                        status.reasonWhySuspended = string;
                        status.errorAnalyzingFinished = true;
                        HeavyProcessTypeModel heavyProcessTypeModel = (HeavyProcessTypeModel)((Object)this.model.getHeavyProcessType().getValue());
                        Object object5 = status.heavyProcessType = heavyProcessTypeModel != null ? FrontendTrafficLightRendererKt.access$fromModel(heavyProcessTypeModel) : null;
                        if (status.heavyProcessType == null) break;
                        status.errorCounts = ArrayUtilRt.EMPTY_INT_ARRAY;
                        break;
                    }
                    case 5: 
                    case 6: {
                        status.errorAnalyzingFinished = false;
                        status.errorCounts = this.getErrorCounts();
                        break;
                    }
                    case 7: 
                    case 8: {
                        status.errorAnalyzingFinished = true;
                        status.errorCounts = this.getErrorCounts();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
        }
        logger = FrontendTrafficLightRenderer.logger;
        boolean bl3 = false;
        if (logger.isTraceEnabled()) {
            Logger logger2 = logger;
            bl = false;
            PsiFile psiFile = this.psiFile;
            logger2.trace("Backend daemon status for " + (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null ? psiFile.getName() : null) + " is " + this.model.getState().getValueOrNull() + ", IDEA status is " + status);
        }
    }

    public boolean isValid() {
        if (!this.model.isBound()) {
            return false;
        }
        return super.isValid();
    }

    private final boolean b() {
        return this.model.getState().getValueOrNull() == BackendDaemonStateEnum.HIDDEN;
    }

    private final boolean G() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.backend.getSolution().isLoaded()));
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(FrontendTrafficLightRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        FrontendTrafficLightRenderer.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/daemon/FrontendTrafficLightRenderer$Companion;", "", "FrontendTrafficLightRenderer$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BackendDaemonStateEnum.values().length];
            try {
                nArray[BackendDaemonStateEnum.HIDDEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UNSUPPORTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.DISABLED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.SUSPENDED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.INVALIDATED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_LOCAL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.IN_PROGRESS_GLOBAL.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BackendDaemonStateEnum.UP_TO_DATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

