/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.daemon;

import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdclient.daemon.IProtocolHighlighterModelHandler;
import com.jetbrains.rdclient.daemon.util.HighlightersUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rdclient/daemon/CompoundHighlighterModelsHandler;", "Lcom/jetbrains/rdclient/daemon/IProtocolHighlighterModelHandler;", "handlers", "", "CompoundHighlighterModelsHandler", "(Ljava/util/List;)V", "accept", "", "model", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "initialize", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "compare", "move", "startOffset", "", "endOffset", "getHandler", "intellij.rd.client"})
public final class CompoundHighlighterModelsHandler
implements IProtocolHighlighterModelHandler {
    @NotNull
    private final List<IProtocolHighlighterModelHandler> handlers;

    public CompoundHighlighterModelsHandler(@NotNull List<? extends IProtocolHighlighterModelHandler> handlers) {
        Intrinsics.checkNotNullParameter(handlers, (String)"handlers");
        this.handlers = handlers;
    }

    @Override
    public boolean accept(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.getHandler(model);
        return true;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        this.getHandler(model).initialize(model, highlighter);
    }

    @Override
    public boolean compare(@NotNull HighlighterModel model, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        return this.getHandler(model).compare(model, highlighter);
    }

    @Override
    @Nullable
    public HighlighterModel move(int startOffset, int endOffset, @NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return this.getHandler(model).move(startOffset, endOffset, model);
    }

    @NotNull
    public final IProtocolHighlighterModelHandler getHandler(@NotNull HighlighterModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Object object = null;
        for (IProtocolHighlighterModelHandler iProtocolHighlighterModelHandler : this.handlers) {
            if (!iProtocolHighlighterModelHandler.accept(model)) continue;
            if (object != null) {
                String string = "Both '" + Reflection.getOrCreateKotlinClass(object.getClass()).getQualifiedName() + "' and '" + Reflection.getOrCreateKotlinClass(iProtocolHighlighterModelHandler.getClass()).getQualifiedName() + "' are registered for " + HighlightersUtilKt.prettyPrint(model) + ", class: " + Reflection.getOrCreateKotlinClass(model.getClass()).getQualifiedName();
                throw new IllegalArgumentException(string);
            }
            object = iProtocolHighlighterModelHandler;
        }
        if (object == null) {
            throw new IllegalArgumentException("Haven't found matching handler for " + HighlightersUtilKt.prettyPrint(model) + ", class: " + Reflection.getOrCreateKotlinClass(model.getClass()).getQualifiedName());
        }
        return object;
    }
}

