/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdclient.completion;

import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.impl.LookupManagerImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EmptyIcon;
import com.jetbrains.rd.ide.completion.IProtocolLookupItem;
import com.jetbrains.rd.ide.model.CompletionItem;
import com.jetbrains.rd.ide.model.LookupSummaryInfo;
import com.jetbrains.rd.ui.completion.RdLookupItemBase;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0016\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0016\u001a\u00020\u0017H\u0004J\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006!"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase;", "Lcom/jetbrains/rd/ide/completion/IProtocolLookupItem;", "Lcom/jetbrains/rd/ui/completion/RdLookupItemBase;", "completionItem", "Lcom/jetbrains/rd/ide/model/CompletionItem;", "sessionLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "suppressJavadoc", "", "ProtocolLookupItemBase", "(Lcom/jetbrains/rd/ide/model/CompletionItem;Lcom/jetbrains/rd/util/lifetime/Lifetime;Z)V", "getSessionLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "summaryInfo", "Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "getSummaryInfo", "()Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;", "setSummaryInfo", "(Lcom/jetbrains/rd/ide/model/LookupSummaryInfo;)V", "lifetimeTerminationStacktrace", "Ljava/lang/Exception;", "Lkotlin/Exception;", "checkLifetime", "", "shouldRequestUpdate", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "priority", "", "getPriority", "()J", "Companion", "intellij.rd.client"})
@SourceDebugExtension(value={"SMAP\nProtocolLookupItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,69:1\n69#2,4:70\n15#2:76\n1#3:74\n13#4:75\n*S KotlinDebug\n*F\n+ 1 ProtocolLookupItem.kt\ncom/jetbrains/rdclient/completion/ProtocolLookupItemBase\n*L\n40#1:70,4\n25#1:76\n25#1:75\n*E\n"})
public class ProtocolLookupItemBase
extends RdLookupItemBase
implements IProtocolLookupItem {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime sessionLifetime;
    @Nullable
    private LookupSummaryInfo summaryInfo;
    @Nullable
    private Exception lifetimeTerminationStacktrace;
    @NotNull
    private static final Logger logger;

    public ProtocolLookupItemBase(@NotNull CompletionItem completionItem, @NotNull Lifetime sessionLifetime, boolean suppressJavadoc) {
        Intrinsics.checkNotNullParameter((Object)completionItem, (String)"completionItem");
        Intrinsics.checkNotNullParameter((Object)sessionLifetime, (String)"sessionLifetime");
        super(completionItem);
        this.sessionLifetime = sessionLifetime;
        if (suppressJavadoc) {
            this.putUserData(LookupManagerImpl.Companion.getSUPPRESS_AUTOPOPUP_JAVADOC(), true);
        }
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            Logger logger = ProtocolLookupItemBase.logger;
            boolean bl = false;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl2 = false;
                logger2.trace("Lifetime of lookup item " + this + " is terminated");
            }
        }
        this.sessionLifetime.onTerminationIfAlive(() -> ProtocolLookupItemBase.G(this));
    }

    public /* synthetic */ ProtocolLookupItemBase(CompletionItem completionItem, Lifetime lifetime, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(completionItem, lifetime, bl);
    }

    @NotNull
    public final Lifetime getSessionLifetime() {
        return this.sessionLifetime;
    }

    @Nullable
    public final LookupSummaryInfo getSummaryInfo() {
        return this.summaryInfo;
    }

    public final void setSummaryInfo(@Nullable LookupSummaryInfo lookupSummaryInfo) {
        this.summaryInfo = lookupSummaryInfo;
    }

    protected final void checkLifetime() {
        if (logger.isTraceEnabled() && RLifetimeKt.isNotAlive((Lifetime)this.sessionLifetime)) {
            logger.error("Session lifetime of lookup item " + this + " was terminated from following stack", (Throwable)this.lifetimeTerminationStacktrace);
        }
        if (!RLifetimeKt.isAlive((Lifetime)this.sessionLifetime)) {
            boolean bl = false;
            String string = "Session lifetime of lookup item " + this + " is terminated";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final boolean shouldRequestUpdate() {
        return this.getDisplayName() == null;
    }

    @Override
    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.renderElement(presentation);
        if (presentation.getIcon() == null) {
            presentation.setIcon(EmptyIcon.ICON_16);
        }
    }

    @Override
    public long getPriority() {
        return this.getCompletionItem().getPriority();
    }

    private static final Unit G(ProtocolLookupItemBase protocolLookupItemBase) {
        if (logger.isTraceEnabled()) {
            protocolLookupItemBase.lifetimeTerminationStacktrace = new Exception();
        }
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger = Logger.getInstance(ProtocolLookupItemBase.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ProtocolLookupItemBase.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdclient/completion/ProtocolLookupItemBase$Companion;", "", "ProtocolLookupItemBase$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rd.client"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

