/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.util;

import com.intellij.codeInsight.codeVision.ui.model.richText.RichString;
import com.intellij.ui.SimpleTextAttributes;
import com.jetbrains.rd.ide.model.RichStringModel;
import com.jetbrains.rd.ide.model.RichTextModel;
import com.jetbrains.rd.ui.bindable.ViewModel;
import com.jetbrains.rd.ui.util.ExtensionsKt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB\t\b\u0016\u00a2\u0006\u0004\b\b\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rd/ui/util/RichText;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "Lcom/jetbrains/rd/ui/bindable/ViewModel;", "text", "", "parts", "", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichString;", "RichText", "(Ljava/lang/String;Ljava/util/Collection;)V", "()V", "(Ljava/lang/String;)V", "richText", "(Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;)V", "toRichTextModel", "Lcom/jetbrains/rd/ide/model/RichTextModel;", "Companion", "intellij.rd.ui"})
public final class RichText
extends com.intellij.codeInsight.codeVision.ui.model.richText.RichText
implements ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public RichText(@NotNull String text, @NotNull Collection<RichString> parts) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        super(text, parts);
    }

    @NotNull
    public final RichTextModel toRichTextModel() {
        List list2 = new ArrayList();
        for (RichString richString : this.getParts()) {
            Color color = richString.getAttributes().getFgColor();
            Color color2 = richString.getAttributes().getBgColor();
            Color color3 = richString.getAttributes().getWaveColor();
            RichStringModel richStringModel = new RichStringModel(richString.getText(), color != null ? ExtensionsKt.toRgbColor(color) : null, color2 != null ? ExtensionsKt.toRgbColor(color2) : null, color3 != null ? ExtensionsKt.toRgbColor(color3) : null, null, null, 48, null);
            list2.add(richStringModel);
        }
        return new RichTextModel(list2);
    }

    public RichText() {
        this("", CollectionsKt.emptyList());
    }

    public RichText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this();
        SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
        Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
        this.append(text, simpleTextAttributes);
    }

    public RichText(@NotNull com.intellij.codeInsight.codeVision.ui.model.richText.RichText richText) {
        Intrinsics.checkNotNullParameter((Object)richText, (String)"richText");
        this(richText.getText(), richText.getParts());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/ui/util/RichText$Companion;", "", "RichText$Companion", "()V", "toRichText", "Lcom/jetbrains/rd/ui/util/RichText;", "Lcom/intellij/codeInsight/codeVision/ui/model/richText/RichText;", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RichText toRichText(@NotNull com.intellij.codeInsight.codeVision.ui.model.richText.RichText $this$toRichText) {
            Intrinsics.checkNotNullParameter((Object)$this$toRichText, (String)"<this>");
            return new RichText($this$toRichText);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

