/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.icons.converters;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.ImageDescriptorKt;
import com.intellij.ui.icons.RgbImageFilterSupplier;
import com.intellij.util.ColorFilter;
import com.intellij.util.IconUtil;
import com.intellij.util.io.URLUtil;
import com.jetbrains.rd.ide.model.ColorFilterModel;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.model.IconSource;
import com.jetbrains.rd.ide.model.ImageIconInternWrapper;
import com.jetbrains.rd.ide.model.ImageIconModel;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.icons.ProtocolIconConverter;
import com.jetbrains.rd.ui.icons.ProtocolIconRegistry;
import com.jetbrains.rd.ui.icons.converters.ImageIconConverterKt;
import com.jetbrains.rd.ui.icons.converters.ProtocolImageDataLoader;
import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ui/icons/converters/ImageIconConverter;", "Lcom/jetbrains/rd/ui/icons/ProtocolIconConverter;", "Lcom/intellij/ui/icons/CachedImageIcon;", "Lcom/jetbrains/rd/ide/model/ImageIconModel;", "ImageIconConverter", "()V", "createIcon", "Ljavax/swing/Icon;", "model", "registry", "Lcom/jetbrains/rd/ui/icons/ProtocolIconRegistry;", "createModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "icon", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nImageIconConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1#2:125\n69#3,4:103\n69#3,4:107\n1557#4:111\n1628#4,3:112\n1611#4,9:115\n1863#4:124\n1864#4:126\n1620#4:127\n*S KotlinDebug\n*F\n+ 1 ImageIconConverter.kt\ncom/jetbrains/rd/ui/icons/converters/ImageIconConverter\n*L\n75#1:125\n52#1:103,4\n60#1:107,4\n71#1:111\n71#1:112,3\n75#1:115,9\n75#1:124\n75#1:126\n75#1:127\n*E\n"})
public final class ImageIconConverter
implements ProtocolIconConverter<CachedImageIcon, ImageIconModel> {
    @Override
    @NotNull
    public Icon createIcon(@NotNull ImageIconModel model, @NotNull ProtocolIconRegistry registry) {
        ColorFilterModel colorFilterModel;
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        String string = model.getWrapper().getPath();
        Icon icon2 = IconLoader.findIcon((String)string, AllIcons.class, (boolean)false, (boolean)false);
        if (icon2 != null && !(icon2 instanceof CachedImageIcon)) {
            return icon2;
        }
        Icon icon3 = icon = registry.cacheIcon(model.getWrapper().getIdentity(), (Function1<? super Long, ? extends Icon>)((Function1)arg_0 -> ImageIconConverter.G(model, icon2, arg_0)));
        Float f = model.getInitialScale();
        if (f != null) {
            CachedImageIcon cachedImageIcon = icon instanceof CachedImageIcon ? (CachedImageIcon)icon : null;
            Icon icon4 = cachedImageIcon != null && (cachedImageIcon = cachedImageIcon.scale(f.floatValue())) != null ? (Icon)cachedImageIcon : (icon3 = icon);
        }
        if ((colorFilterModel = model.getColorFilter()) != null) {
            icon3 = IconUtil.colorize((Icon)icon3, (Color)ColorHostKt.toColor(colorFilterModel.getColor()), (boolean)colorFilterModel.getKeepGray());
        }
        return icon3;
    }

    @Override
    @Nullable
    public IconModel createModel(@NotNull CachedImageIcon icon, @NotNull ProtocolIconRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        IconModel iconModel = registry.cacheModel((Icon)icon, (Function1<? super Long, ? extends IconModel>)((Function1)arg_0 -> ImageIconConverter.G(icon, arg_0)));
        boolean bl = false;
        ImageIconModel imageIconModel = iconModel instanceof ImageIconModel ? (ImageIconModel)iconModel : null;
        if (imageIconModel == null) {
            return iconModel;
        }
        ImageIconModel imageIconModel2 = imageIconModel;
        Double d = icon.getObjScale();
        RgbImageFilterSupplier rgbImageFilterSupplier = icon.getLocalFilterSupplier();
        RGBImageFilter rGBImageFilter = rgbImageFilterSupplier != null ? rgbImageFilterSupplier.getFilter() : null;
        ColorFilter colorFilter = rGBImageFilter instanceof ColorFilter ? (ColorFilter)rGBImageFilter : null;
        if (colorFilter != null) {
            ColorFilter colorFilter2 = colorFilter;
            boolean bl2 = false;
            v3 = new ColorFilterModel(ColorHostKt.toModel(colorFilter2.getColor()), colorFilter2.getKeepGray());
        } else {
            v3 = iconModel = null;
        }
        if (d == null && iconModel == null) {
            return imageIconModel2;
        }
        Double d2 = d;
        return new ImageIconModel(imageIconModel2.getWrapper(), d2 != null ? Float.valueOf((float)d2.doubleValue()) : null, (ColorFilterModel)((Object)iconModel));
    }

    private static final Icon G(ImageIconModel imageIconModel, Icon icon, long l) {
        Icon icon2 = icon;
        CachedImageIcon cachedImageIcon = icon2 instanceof CachedImageIcon ? (CachedImageIcon)icon2 : null;
        return (Icon)new CachedImageIcon((ImageDataLoader)new ProtocolImageDataLoader(imageIconModel, (ImageDataLoader)(cachedImageIcon != null ? cachedImageIcon.getOriginalLoader() : null)));
    }

    private static final IconModel G(CachedImageIcon cachedImageIcon, long l) {
        Object object;
        List list2;
        int n;
        Iterable iterable;
        String string;
        Object object2;
        Object object3;
        String string2;
        Object object4;
        Logger logger;
        URL uRL;
        String string3;
        block30: {
            block29: {
                block28: {
                    Object object5;
                    block27: {
                        Object object6;
                        String string4;
                        String string5 = cachedImageIcon.getExpUIPath();
                        if (string5 == null) {
                            string5 = cachedImageIcon.getOriginalPath();
                        }
                        string3 = string5;
                        uRL = cachedImageIcon.getUrl();
                        logger = ImageIconConverterKt.access$getLogger$p();
                        boolean bl = false;
                        if (logger.isTraceEnabled()) {
                            object4 = logger;
                            boolean bl2 = false;
                            URL uRL2 = uRL;
                            object4.trace("originalPath=" + string3 + ", icon.url.path=" + (uRL2 != null ? uRL2.getPath() : null));
                        }
                        if ((string4 = string3) == null) {
                            URL uRL3 = uRL;
                            string4 = uRL3 != null ? uRL3.getPath() : null;
                        }
                        if (string4 != null) {
                            string2 = string4;
                            boolean bl3 = false;
                            object6 = URLUtil.splitJarUrl((String)string2);
                            if (object6 == null || (object6 = (String)object6.second) == null) {
                                object6 = string2;
                            }
                        } else {
                            object6 = null;
                        }
                        if ((object5 = (logger = object6)) == null) break block27;
                        Logger logger2 = object5;
                        boolean bl4 = false;
                        String string6 = FileUtilRt.getNameWithoutExtension((String)logger2);
                        object5 = string6;
                        if (string6 != null) break block28;
                    }
                    object5 = object3 = "protocol_icon_no_path";
                }
                if ((object2 = logger) == null) break block29;
                Logger logger3 = object2;
                boolean bl = false;
                String string7 = FileUtilRt.getExtension((String)logger3);
                object2 = string7;
                if (string7 != null) break block30;
            }
            object2 = "png";
        }
        Object object7 = object2;
        boolean bl = false;
        String string8 = Intrinsics.areEqual((Object)object7, (Object)"") ? "svg" : object7;
        string2 = ImageIconConverterKt.access$getLogger$p();
        boolean bl5 = false;
        if (string2.isTraceEnabled()) {
            object4 = string2;
            bl = false;
            object4.trace("path=" + (String)logger + ", name=" + (String)object3 + ", ext=" + string8);
        }
        if (string3 == null) {
            ImageIconConverterKt.access$getLogger$p().warn("originalPath is null, using " + (String)object3 + "." + string8 + " as a fallback");
        }
        URL uRL4 = uRL;
        String string9 = string2 = uRL4 != null ? uRL4.getPath() : null;
        String string10 = string9 != null ? StringsKt.substringAfterLast$default((String)string9, (String)".", null, (int)2, null) : null;
        String string11 = string2;
        String string12 = string = string11 != null ? StringsKt.substringBeforeLast$default((String)string11, (String)".", null, (int)2, null) : null;
        if (logger != null && string != null && string10 != null) {
            String string13;
            Object object8;
            iterable = ImageDescriptorKt.createImageDescriptorList((String)logger, (boolean)true, (boolean)true, (float)1.0f);
            n = 0;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl6 = false;
            for (Object t : iterable2) {
                object8 = (ImageDescriptor)t;
                object4 = collection;
                boolean bl7 = false;
                string13 = (String)((ImageDescriptor)object8).pathTransform.invoke((Object)string, (Object)string10);
                String string14 = (String)((ImageDescriptor)object8).pathTransform.invoke(object3, (Object)string8);
                object4.add(TuplesKt.to((Object)string13, (Object)string14));
            }
            iterable = CollectionsKt.distinct((Iterable)((List)collection));
            n = 0;
            iterable2 = iterable;
            collection = new ArrayList();
            bl6 = false;
            Iterable iterable3 = iterable2;
            boolean bl8 = false;
            object8 = iterable3.iterator();
            while (object8.hasNext()) {
                IconSource iconSource;
                block26: {
                    byte[] byArray;
                    Object e = object8.next();
                    string13 = e;
                    boolean bl9 = false;
                    Pair pair = (Pair)string13;
                    boolean bl10 = false;
                    URL uRL5 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), (String)pair.getFirst());
                    try {
                        byArray = TextStreamsKt.readBytes((URL)uRL5);
                    }
                    catch (IOException iOException) {
                        iconSource = null;
                        break block26;
                    }
                    byte[] byArray2 = byArray;
                    iconSource = new IconSource((String)pair.getSecond(), byArray2);
                }
                if (iconSource == null) continue;
                IconSource iconSource2 = iconSource;
                boolean bl11 = false;
                collection.add(iconSource2);
            }
            v14 = (List)collection;
        } else {
            v14 = list2 = CollectionsKt.emptyList();
        }
        if (list2.isEmpty()) {
            ImageIconConverterKt.access$getLogger$p().error("Failed to read icon:'" + (String)logger + "'");
        }
        if ((object = logger) == null) {
            object = (String)object3 + "." + string8;
        }
        iterable = object;
        n = cachedImageIcon.getImageFlags();
        return new ImageIconModel(new ImageIconInternWrapper(l, (String)((Object)iterable), n, list2), null, null, 4, null);
    }
}

