/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.execution.console.EditorMergedHorizontalScrollBarLayout;
import com.intellij.execution.console.MergedHorizontalScrollBarModel;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ThinClientConsoleEditorPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "commandEditor", "editorPanel", "Ljavax/swing/JComponent;", "commandEditorPanel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "ThinClientConsoleEditorPanel", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/openapi/editor/ex/EditorEx;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "getCommandEditor", "G", "", "b", "Companion", "intellij.rd.ui"})
public final class ThinClientConsoleEditorPanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorEx commandEditor;

    public ThinClientConsoleEditorPanel(@NotNull EditorEx editor, @NotNull EditorEx commandEditor, @NotNull JComponent editorPanel, @NotNull JComponent commandEditorPanel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)commandEditor, (String)"commandEditor");
        Intrinsics.checkNotNullParameter((Object)editorPanel, (String)"editorPanel");
        Intrinsics.checkNotNullParameter((Object)commandEditorPanel, (String)"commandEditorPanel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.editor = editor;
        this.commandEditor = commandEditor;
        JBScrollBar jBScrollBar = new JBScrollBar(0);
        MergedHorizontalScrollBarModel.create((JScrollBar)((JScrollBar)jBScrollBar), (EditorEx)this.editor, (EditorEx)this.commandEditor);
        this.setLayout((LayoutManager)new EditorMergedHorizontalScrollBarLayout((JScrollBar)jBScrollBar, this.editor, this.commandEditor, true, 2));
        this.add(editorPanel);
        this.add(commandEditorPanel);
        this.add((Component)jBScrollBar);
        this.setBackground((Color)JBColor.lazy(() -> ThinClientConsoleEditorPanel.G(this)));
        if (ExperimentalUI.Companion.isNewUI()) {
            this.editor.getSettings().setLineMarkerAreaShown(false);
            this.commandEditor.getSettings().setLineMarkerAreaShown(true);
        }
        this.editor.setCaretEnabled(false);
        KeyAdapter keyAdapter = new KeyAdapter(this){
            final /* synthetic */ ThinClientConsoleEditorPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyTyped(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (UIUtil.isReallyTypedEvent((KeyEvent)e)) {
                    IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> keyListener.1.G(this.this$0));
                    this.this$0.getCommandEditor().processKeyTyped(e);
                }
            }

            private static final void G(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel) {
                IdeFocusManager.getGlobalInstance().requestFocus((Component)thinClientConsoleEditorPanel.getCommandEditor().getContentComponent(), true);
            }
        };
        lifetime.bracketIfAlive(() -> ThinClientConsoleEditorPanel.b(this, keyAdapter), () -> ThinClientConsoleEditorPanel.G(this, keyAdapter));
        this.G(this.editor);
        this.b(this.editor);
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    @NotNull
    public final EditorEx getCommandEditor() {
        return this.commandEditor;
    }

    private final void G(EditorEx editorEx) {
        editorEx.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(){

            public ActionGroup getActionGroup(EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                AnAction anAction = ActionManager.getInstance().getAction("ConsoleView.PopupMenu");
                Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
                return (ActionGroup)anAction;
            }
        });
    }

    private final void b(EditorEx editorEx) {
        editorEx.getDocument().addDocumentListener(new DocumentListener(editorEx){
            private boolean shouldStickToEnd;
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            public final boolean getShouldStickToEnd() {
                return this.shouldStickToEnd;
            }

            public final void setShouldStickToEnd(boolean bl) {
                this.shouldStickToEnd = bl;
            }

            public void beforeDocumentChange(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ThreadingAssertions.assertEventDispatchThread();
                if (event.getOffset() < event.getDocument().getTextLength()) {
                    this.shouldStickToEnd = false;
                    return;
                }
                this.shouldStickToEnd = com.jetbrains.rd.ui.bindable.views.ThinClientConsoleEditorPanel$Companion.access$isStickingToEnd(ThinClientConsoleEditorPanel.Companion, this.$editor);
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getOffset() + event.getNewLength() < event.getDocument().getTextLength()) {
                    this.shouldStickToEnd = false;
                    return;
                }
                ApplicationKt.getApplication().invokeLater(() -> setupScrollToEndListener.1.G(this, this.$editor));
            }

            private static final void G(setupScrollToEndListener.1 var0, EditorEx editorEx) {
                if (var0.shouldStickToEnd) {
                    EditorUtil.scrollToTheEnd((Editor)((Editor)editorEx));
                    var0.shouldStickToEnd = false;
                }
            }
        });
    }

    private static final Color G(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel) {
        return thinClientConsoleEditorPanel.editor.getBackgroundColor();
    }

    private static final Unit b(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel, keyListener.1 var1_1) {
        thinClientConsoleEditorPanel.editor.getContentComponent().addKeyListener(var1_1);
        return Unit.INSTANCE;
    }

    private static final Unit G(ThinClientConsoleEditorPanel thinClientConsoleEditorPanel, keyListener.1 var1_1) {
        thinClientConsoleEditorPanel.editor.getContentComponent().removeKeyListener(var1_1);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/ThinClientConsoleEditorPanel$Companion;", "", "ThinClientConsoleEditorPanel$Companion", "()V", "G", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "G", "Lcom/intellij/openapi/editor/Editor;", "b", "intellij.rd.ui"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean G(EditorEx editorEx) {
            return this.G((Editor)editorEx) || this.b(editorEx);
        }

        private final boolean G(Editor editor) {
            Document document = editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            int n = editor.getCaretModel().getOffset();
            return document2.getLineNumber(n) >= document2.getLineCount() - 1;
        }

        private final boolean b(EditorEx editorEx) {
            JScrollBar jScrollBar = editorEx.getScrollPane().getVerticalScrollBar();
            return jScrollBar.getValue() == jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
        }

        public static final /* synthetic */ boolean access$isStickingToEnd(Companion $this, EditorEx editor) {
            return $this.G(editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

