/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.EventListeners;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeHtmlViewer;
import com.jetbrains.ide.model.uiautomation.HyperlinkEventModel;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bindable.ViewBinder;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import java.awt.Color;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl;", "Lcom/jetbrains/rd/ui/bindable/ViewBinder;", "Lcom/jetbrains/ide/model/uiautomation/BeHtmlViewer;", "HtmlViewerViewControl", "()V", "bind", "Ljavax/swing/JComponent;", "viewModel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "G", "Lcom/jetbrains/ide/model/uiautomation/HyperlinkEventModel;", "Ljavax/swing/event/HyperlinkEvent;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nHtmlViewerViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlViewerViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1863#2,2:62\n*S KotlinDebug\n*F\n+ 1 HtmlViewerViewControl.kt\ncom/jetbrains/rd/ui/bindable/views/HtmlViewerViewControl\n*L\n38#1:62,2\n*E\n"})
public final class HtmlViewerViewControl
implements ViewBinder<BeHtmlViewer> {
    @Override
    @NotNull
    public JComponent bind(@NotNull BeHtmlViewer viewModel, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKitBuilder().withWordWrapViewFactory().build();
        jEditorPane.setEditorKit(hTMLEditorKit);
        jEditorPane.setBackground(UIUtil.getPanelBackground());
        Document document = hTMLEditorKit.createDefaultDocument();
        jEditorPane.setDocument(document);
        String string = (String)viewModel.getText().getValue();
        jEditorPane.setContentType("text/html");
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:#" + ColorUtil.toHex((Color)UIUtil.getLabelForeground()) + " }");
        styleSheet.addRule("body {font:" + StartupUiUtil.getLabelFont().getFamily() + " }");
        styleSheet.addRule("body {word-break: break-all;}");
        Iterable iterable = BeGetterExtensionsKt.valueOrEmpty(viewModel.getCssRules());
        boolean bl = false;
        for (Object t : iterable) {
            String string2 = (String)t;
            boolean bl2 = false;
            styleSheet.addRule(string2);
        }
        if (string != null) {
            viewModel.getText().advise(lifetime, arg_0 -> HtmlViewerViewControl.b(jEditorPane, arg_0));
        } else {
            viewModel.getUrl().advise(lifetime, arg_0 -> HtmlViewerViewControl.G(jEditorPane, arg_0));
            jEditorPane.setText("<html> " + viewModel.getTextOnError() + "</html>");
        }
        EventListeners.addHyperLinkListener((JEditorPane)jEditorPane, (Disposable)LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null), arg_0 -> HtmlViewerViewControl.G(viewModel, this, arg_0));
        return jEditorPane;
    }

    private final HyperlinkEventModel G(HyperlinkEvent hyperlinkEvent) {
        URL uRL = hyperlinkEvent.getURL();
        return new HyperlinkEventModel(uRL != null ? uRL.toExternalForm() : null, hyperlinkEvent.getDescription());
    }

    private static final Unit b(JEditorPane jEditorPane, String string) {
        jEditorPane.setText(string);
        return Unit.INSTANCE;
    }

    private static final Unit G(JEditorPane jEditorPane, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"v");
        jEditorPane.setPage(new URL(string));
        return Unit.INSTANCE;
    }

    private static final void G(BeHtmlViewer beHtmlViewer, HtmlViewerViewControl htmlViewerViewControl, HyperlinkEvent hyperlinkEvent) {
        if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            ISignal<HyperlinkEventModel> iSignal = beHtmlViewer.getLinkClicked();
            Intrinsics.checkNotNull((Object)hyperlinkEvent);
            iSignal.fire((Object)htmlViewerViewControl.G(hyperlinkEvent));
        }
    }
}

