/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.popup;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.ApplicationKt;
import com.jetbrains.ide.model.uiautomation.BeControlSize;
import com.jetbrains.ide.model.uiautomation.DialogResult;
import com.jetbrains.rd.ide.model.BeAbstractPopup;
import com.jetbrains.rd.ide.model.BePopupPositionActiveWindowContext;
import com.jetbrains.rd.ide.model.BePopupPositionComponentContext;
import com.jetbrains.rd.ide.model.BePopupPositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionDataContextContext;
import com.jetbrains.rd.ide.model.BePopupPositionFocusContext;
import com.jetbrains.rd.ide.model.BePopupPositionMousePositionContext;
import com.jetbrains.rd.ide.model.BePopupPositionScreenPointContext;
import com.jetbrains.rd.ide.model.BePopupPositionTreeOrTableSelectedItemContext;
import com.jetbrains.rd.platform.ProjectUtilKt;
import com.jetbrains.rd.ui.bindable.ConverterStorage;
import com.jetbrains.rd.ui.bindable.popup.BeShowPopupHandler;
import com.jetbrains.rd.ui.bindable.popup.PopupProvider;
import com.jetbrains.rd.ui.bindable.popup.PopupUtils;
import com.jetbrains.rd.ui.bindable.popup.PopupViewControl;
import com.jetbrains.rd.ui.bindable.popup.PopupViewControlKt;
import com.jetbrains.rd.ui.bindable.views.contextProviders.BeContextProvider;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.ui.bindable.views.utils.MarginTypesKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdclient.ui.bindableUi.views.utils.BeUtilKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rd/ui/bindable/popup/PopupViewControl;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/rd/ide/model/BeAbstractPopup;", "isReflection", "", "customSession", "Lcom/intellij/openapi/client/ClientAppSession;", "PopupViewControl", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rd/ide/model/BeAbstractPopup;ZLcom/intellij/openapi/client/ClientAppSession;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "showPopup", "", "G", "Lcom/intellij/openapi/ui/popup/JBPopup;", "popup", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nPopupViewControl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopupViewControl.kt\ncom/jetbrains/rd/ui/bindable/popup/PopupViewControl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,217:1\n69#2,4:218\n*S KotlinDebug\n*F\n+ 1 PopupViewControl.kt\ncom/jetbrains/rd/ui/bindable/popup/PopupViewControl\n*L\n162#1:218,4\n*E\n"})
public final class PopupViewControl {
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private final Project project;
    @NotNull
    private final BeAbstractPopup model;
    private final boolean isReflection;
    @Nullable
    private final ClientAppSession customSession;

    public PopupViewControl(@NotNull Lifetime lifetime, @Nullable Project project, @NotNull BeAbstractPopup model, boolean isReflection, @Nullable ClientAppSession customSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        this.lifetime = lifetime;
        this.project = project;
        this.model = model;
        this.isReflection = isReflection;
        this.customSession = customSession;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public final void showPopup() {
        this.model.getLoaded().advise(this.lifetime, arg_0 -> PopupViewControl.G(this, arg_0));
    }

    private final JBPopup G() {
        JBPopup jBPopup = PopupProvider.Companion.getPopup(this.lifetime, this.project, this.model);
        if (jBPopup == null) {
            throw new IllegalStateException();
        }
        JBPopup jBPopup2 = jBPopup;
        if (jBPopup2 instanceof AbstractPopup) {
            ((AbstractPopup)jBPopup2).setStretchToOwnerWidth(this.model.getSettings().getStretchToOwnerWidth());
            ((AbstractPopup)jBPopup2).setStretchToOwnerHeight(this.model.getSettings().getStretchToOwnerHeight());
            ((AbstractPopup)jBPopup2).setOkHandler(() -> PopupViewControl.G(this));
            ((AbstractPopup)jBPopup2).addListener(new JBPopupListener(this){
                final /* synthetic */ PopupViewControl this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onClosed(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    ApplicationKt.getApplication().invokeLater(() -> loadPopup.2.G(this.this$0));
                }

                private static final void G(PopupViewControl popupViewControl) {
                    PopupViewControl.access$getModel$p(popupViewControl).getResult().set((Object)((Object)DialogResult.CLOSE));
                }
            });
            Pair<Integer, Integer> pair = (Pair<Integer, Integer>)this.model.getMinimumSize().getValue();
            if (pair != null && (pair = MarginTypesKt.getSize((BeControlSize)pair)) != null) {
                Pair<Integer, Integer> pair2 = pair;
                boolean bl = false;
                ((AbstractPopup)jBPopup2).setMinimumSize(new Dimension(((Number)pair2.getFirst()).intValue(), ((Number)pair2.getSecond()).intValue()));
            }
        }
        this.model.getResult().advise(this.lifetime, arg_0 -> PopupViewControl.G(jBPopup2, arg_0));
        ISource iSource = this.model.getTitle();
        if (iSource != null && (iSource = iSource.getText()) != null && (iSource = iSource.getChange()) != null) {
            iSource.advise(this.lifetime, arg_0 -> PopupViewControl.G(jBPopup2, arg_0));
        }
        this.model.getResize().advise(this.lifetime, arg_0 -> PopupViewControl.G(jBPopup2, arg_0));
        this.lifetime.onTermination(() -> PopupViewControl.G(jBPopup2, this));
        if (this.isReflection) {
            jBPopup2.addListener(new JBPopupListener(){

                public void beforeShown(LightweightWindowEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    JPanel jPanel = new JPanel();
                    jPanel.setOpaque(false);
                    jPanel.setVisible(true);
                    jPanel.addMouseListener(new MouseAdapter(){});
                    jPanel.addKeyListener(new KeyAdapter(){});
                    JRootPane jRootPane = SwingUtilities.getRootPane(event.asPopup().getContent());
                    if (jRootPane != null) {
                        jRootPane.setGlassPane(jPanel);
                    }
                }
            });
        }
        return jBPopup2;
    }

    private final void G(JBPopup jBPopup, DataContext dataContext) {
        BePopupPositionContext bePopupPositionContext = (BePopupPositionContext)((Object)this.model.getContext().getValueOrNull());
        Component component = WindowManagerEx.getInstanceEx().getFocusedComponent(this.project);
        if (component == null) {
            component = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        }
        Component component2 = component;
        Object object = PopupViewControlKt.access$getLogger$p();
        boolean bl = false;
        if (object.isTraceEnabled()) {
            Logger logger = object;
            boolean bl2 = false;
            logger.trace("Show popup in context " + bePopupPositionContext);
        }
        object = bePopupPositionContext;
        if (object instanceof BePopupPositionFocusContext) {
            jBPopup.showInFocusCenter();
        } else if (object instanceof BePopupPositionActiveWindowContext) {
            Project project = ProjectUtilKt.toProject(((BePopupPositionActiveWindowContext)bePopupPositionContext).getProjectId());
            jBPopup.showCenteredInCurrentWindow(project);
        } else if (object instanceof BePopupPositionTreeOrTableSelectedItemContext) {
            RelativeRectangle relativeRectangle;
            Component component3;
            Component component4 = component3 = ConverterStorage.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication())).tryGetComponentByDataId(((BePopupPositionTreeOrTableSelectedItemContext)bePopupPositionContext).getComponentId());
            Object object2 = relativeRectangle = component4 != null ? SwingTreeUtilsKt.tryGetSelectedItemBounds(component4) : null;
            if (relativeRectangle != null) {
                RelativeRectangle relativeRectangle2 = relativeRectangle;
                boolean bl3 = false;
                Point point = new Point(relativeRectangle2.getPoint().getPoint().x + relativeRectangle2.getDimension().width, relativeRectangle2.getPoint().getPoint().y + relativeRectangle2.getDimension().height / 2);
                jBPopup.show(new RelativePoint(relativeRectangle.getComponent(), point));
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (object instanceof BePopupPositionComponentContext) {
            Project project = this.project;
            if (project == null) {
                project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            }
            Project project2 = project;
            RelativePoint relativePoint = BeContextProvider.Companion.getPointFromContext(project2, (BePopupPositionComponentContext)bePopupPositionContext, jBPopup.getContent().getPreferredSize());
            RelativePoint relativePoint2 = relativePoint;
            if (relativePoint2 != null) {
                jBPopup.show(relativePoint2);
            } else {
                Project project3 = project2;
                if (project3 != null) {
                    jBPopup.showCenteredInCurrentWindow(project3);
                } else {
                    jBPopup.showInBestPositionFor(dataContext);
                }
            }
        } else if (object instanceof BePopupPositionMousePositionContext) {
            if (component2 != null) {
                jBPopup.showInScreenCoordinates(component2, MouseInfo.getPointerInfo().getLocation());
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (object instanceof BePopupPositionScreenPointContext) {
            if (component2 != null) {
                jBPopup.showInScreenCoordinates(component2, new Point(((BePopupPositionScreenPointContext)bePopupPositionContext).getX(), ((BePopupPositionScreenPointContext)bePopupPositionContext).getY()));
            } else {
                jBPopup.showInBestPositionFor(dataContext);
            }
        } else if (object instanceof BePopupPositionDataContextContext) {
            jBPopup.showInBestPositionFor(dataContext);
        } else if (!BeShowPopupHandler.Companion.showPopup(jBPopup, bePopupPositionContext)) {
            PopupViewControlKt.access$getLogger$p().warn("Unknown bePopupContext: " + bePopupPositionContext);
            jBPopup.showInBestPositionFor(dataContext);
        }
    }

    private static final JBPopup G(PopupViewControl popupViewControl) {
        return popupViewControl.G();
    }

    private static final Unit G(PopupViewControl popupViewControl, JBPopup jBPopup, DataContext dataContext) {
        Intrinsics.checkNotNull((Object)dataContext);
        popupViewControl.G(jBPopup, dataContext);
        return Unit.INSTANCE;
    }

    private static final void G(JBPopup jBPopup, PopupViewControl popupViewControl, DataContext dataContext) {
        if (jBPopup.isDisposed()) {
            return;
        }
        if (popupViewControl.customSession != null) {
            ClientId.Companion.withClientId(popupViewControl.customSession.getClientId(), () -> PopupViewControl.G(popupViewControl, jBPopup, dataContext));
        } else {
            Intrinsics.checkNotNull((Object)dataContext);
            popupViewControl.G(jBPopup, dataContext);
        }
        Integer n = (Integer)popupViewControl.model.getDataId().getValueOrNull();
        PopupUtils.Companion.putRdPopupId(jBPopup, n != null ? n : -1);
    }

    private static final Unit G(JBPopup jBPopup, PopupViewControl popupViewControl, DataContext dataContext) {
        SwingUtilities.invokeLater(() -> PopupViewControl.G(jBPopup, popupViewControl, dataContext));
        return Unit.INSTANCE;
    }

    private static final void G(Function1 function1, Object object) {
        function1.invoke(object);
    }

    private static final Unit G(PopupViewControl popupViewControl, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"it");
        JBPopup jBPopup = popupViewControl.customSession != null ? (JBPopup)ClientId.Companion.withClientId(popupViewControl.customSession.getClientId(), () -> PopupViewControl.G(popupViewControl)) : popupViewControl.G();
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> PopupViewControl.G(arg_0 -> PopupViewControl.G(jBPopup, popupViewControl, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void G(PopupViewControl popupViewControl) {
        InterfacesKt.fire(popupViewControl.model.getAccept());
        popupViewControl.model.getResult().set((Object)DialogResult.OK);
        popupViewControl.model.getResult().set((Object)DialogResult.CANCEL);
    }

    private static final Unit G(JBPopup jBPopup, DialogResult dialogResult) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialogResult), (String)"it");
        if (dialogResult == DialogResult.CLOSE && !jBPopup.isDisposed()) {
            jBPopup.cancel(null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(JBPopup jBPopup, String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"it");
        jBPopup.setCaption(string);
        return Unit.INSTANCE;
    }

    private static final Unit G(JBPopup jBPopup, BeControlSize beControlSize) {
        Intrinsics.checkNotNullParameter((Object)beControlSize, (String)"it");
        Pair<Integer, Integer> pair = MarginTypesKt.getSize(beControlSize);
        if (((Number)pair.getFirst()).intValue() < 0 || ((Number)pair.getSecond()).intValue() < 0) {
            BeUtilKt.resizePopup$default(jBPopup, false, false, 3, null);
        } else {
            jBPopup.setSize(new Dimension(((Number)pair.getFirst()).intValue(), ((Number)pair.getSecond()).intValue()));
        }
        return Unit.INSTANCE;
    }

    private static final Unit G(JBPopup jBPopup, PopupViewControl popupViewControl) {
        if (jBPopup.isDisposed()) {
            return Unit.INSTANCE;
        }
        popupViewControl.model.getResult().set((Object)DialogResult.CLOSE);
        jBPopup.cancel();
        Disposer.dispose((Disposable)((Disposable)jBPopup));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ BeAbstractPopup access$getModel$p(PopupViewControl $this) {
        return $this.model;
    }
}

