/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u001aR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00060\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rd/ui/bindable/ConverterStorage;", "", "ConverterStorage", "()V", "componentToModel", "", "Ljava/awt/Component;", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "dataIdToComponent", "", "Lkotlin/Pair;", "componentId", "Ljava/util/concurrent/atomic/AtomicInteger;", "tryToStoreComponentWithExistingId", "", "component", "model", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "storeComponent", "G", "tryGetModelByComponent", "tryGetComponentByDataId", "id", "(Ljava/lang/Integer;)Ljava/awt/Component;", "tryGetDataByDataId", "", "Companion", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nConverterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n1#2:91\n15#3:92\n*S KotlinDebug\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage\n*L\n81#1:92\n*E\n"})
public final class ConverterStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Component, BeControl> componentToModel = new LinkedHashMap();
    @NotNull
    private final Map<Integer, Pair<BeControl, Component>> dataIdToComponent = new LinkedHashMap();
    @NotNull
    private AtomicInteger componentId = new AtomicInteger();
    @NotNull
    private static final Logger logger;
    private static final int STORAGE_LIMIT = 5000;
    private static final int REPORT_INTERVAL = 100;

    public final void tryToStoreComponentWithExistingId(@NotNull Component component, @NotNull BeControl model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (model.getDataId().getValueOrNull() == null) {
            return;
        }
        this.storeComponent(component, model, lifetime);
    }

    public final void storeComponent(@NotNull Component component, @NotNull BeControl model, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        if (model.getDataId().getValueOrNull() == null) {
            model.getDataId().set((Object)this.componentId.incrementAndGet());
        }
        if (this.componentToModel.containsKey(component) || this.dataIdToComponent.containsKey(model.getDataId().getValueOrNull())) {
            return;
        }
        if (RLifetimeKt.isEternal((Lifetime)lifetime)) {
            logger.error("Component with eternal lifetime cannot be stored");
            return;
        }
        String string = "data id " + model.getDataId().getValueOrNull() + " and control id " + model.getControlId().getValue();
        lifetime.bracketIfAlive(() -> ConverterStorage.G(component, string, this, model), () -> ConverterStorage.b(component, string, this, model));
    }

    private final void G() {
        if (this.componentToModel.size() < 5000) {
            return;
        }
        int n = this.componentToModel.size() - 5000;
        if (n % 100 == 0) {
            logger.error("Possible leak in converter storage detected (size = " + this.componentToModel.size() + "). Fix it or increase the limit.");
        }
    }

    @Nullable
    public final BeControl tryGetModelByComponent(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        return this.componentToModel.get(component);
    }

    @Nullable
    public final Component tryGetComponentByDataId(@Nullable Integer id) {
        if (id == null) {
            return null;
        }
        Pair<BeControl, Component> pair = this.dataIdToComponent.get(id);
        return pair != null ? (Component)pair.getSecond() : null;
    }

    @Nullable
    public final Pair<BeControl, Component> tryGetDataByDataId(@Nullable String id) {
        Pair<BeControl, Component> pair;
        if (id == null) {
            return null;
        }
        Integer n = StringsKt.toIntOrNull((String)id);
        if (n != null) {
            int n2 = ((Number)n).intValue();
            boolean bl = false;
            pair = this.dataIdToComponent.get(n2);
        } else {
            pair = null;
        }
        return pair;
    }

    private static final Unit G(Component component, String string, ConverterStorage converterStorage, BeControl beControl) {
        logger.trace("Add component [" + component.getClass() + "] with " + string + " to client " + ClientId.Companion.getCurrent());
        converterStorage.componentToModel.put(component, beControl);
        Integer n = (Integer)beControl.getDataId().getValueOrNull();
        if (n != null) {
            Integer n2 = n;
            int n3 = ((Number)n2).intValue();
            boolean bl = false;
            Integer n4 = n3;
            converterStorage.dataIdToComponent.put(n4, (Pair<BeControl, Component>)new Pair((Object)beControl, (Object)component));
        }
        converterStorage.G();
        return Unit.INSTANCE;
    }

    private static final Unit b(Component component, String string, ConverterStorage converterStorage, BeControl beControl) {
        block0: {
            logger.trace("Remove component [" + component.getClass() + "] with " + string + " from client " + ClientId.Companion.getCurrent());
            converterStorage.componentToModel.remove(component);
            Integer n = (Integer)beControl.getDataId().getValueOrNull();
            if (n == null) break block0;
            Integer n2 = n;
            int n3 = ((Number)n2).intValue();
            boolean bl = false;
            converterStorage.dataIdToComponent.remove(n3);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(ConverterStorage.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ConverterStorage.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rd/ui/bindable/ConverterStorage$Companion;", "", "ConverterStorage$Companion", "()V", "getInstance", "Lcom/jetbrains/rd/ui/bindable/ConverterStorage;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "STORAGE_LIMIT", "", "REPORT_INTERVAL", "getComponentId", "Ljava/awt/Component;", "(Ljava/awt/Component;Lcom/intellij/openapi/client/ClientAppSession;)Ljava/lang/Integer;", "intellij.rd.ui"})
    @SourceDebugExtension(value={"SMAP\nConverterStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n23#2:91\n1#3:92\n*S KotlinDebug\n*F\n+ 1 ConverterStorage.kt\ncom/jetbrains/rd/ui/bindable/ConverterStorage$Companion\n*L\n79#1:91\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConverterStorage getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession clientSession = (ClientSession)session;
            boolean bl = false;
            Object object = clientSession.getService(ConverterStorage.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + clientSession).toString());
            }
            return (ConverterStorage)object;
        }

        @Nullable
        public final Integer getComponentId(@Nullable Component $this$getComponentId, @NotNull ClientAppSession session) {
            Integer n;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Component component = $this$getComponentId;
            if (component != null) {
                Component component2 = component;
                boolean bl = false;
                IOptProperty<Integer> iOptProperty = Companion.getInstance(session).tryGetModelByComponent(component2);
                n = iOptProperty != null && (iOptProperty = iOptProperty.getDataId()) != null ? (Integer)iOptProperty.getValueOrNull() : null;
            } else {
                n = null;
            }
            return n;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

