/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.colors;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.ColorKeyModel;
import com.jetbrains.rd.ide.model.DualColor;
import com.jetbrains.rd.ide.model.NamedColor;
import com.jetbrains.rd.ide.model.RgbColor;
import com.jetbrains.rd.ide.model.RgbaColor;
import com.jetbrains.rd.ide.model.ThemeColorId;
import com.jetbrains.rd.platform.colors.ColorHost;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0002*\u00020\u0001\u001a\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\b\u001a\n\u0010\u0000\u001a\u00020\b*\u00020\u0005\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"toModel", "Lcom/jetbrains/rd/ide/model/ColorKeyModel;", "Lcom/intellij/openapi/editor/colors/ColorKey;", "toKey", "toColor", "Ljava/awt/Color;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Lcom/jetbrains/rd/ide/model/AbstractColor;", "parseHtmlColor", "color", "", "G", "Lcom/jetbrains/rd/ide/model/RgbaColor;", "intellij.rd.platform"})
public final class ColorHostKt {
    @NotNull
    public static final ColorKeyModel toModel(@NotNull ColorKey $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        return ColorHost.Companion.getInstance().getColorKeyModel($this$toModel);
    }

    @NotNull
    public static final ColorKey toKey(@NotNull ColorKeyModel $this$toKey) {
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"<this>");
        return ColorHost.Companion.getInstance().getColorKey($this$toKey);
    }

    @Nullable
    public static final Color toColor(@NotNull ColorKeyModel $this$toColor, @NotNull EditorColorsScheme colorScheme) {
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)colorScheme, (String)"colorScheme");
        return ColorHost.Companion.getInstance().getColor($this$toColor, colorScheme);
    }

    public static /* synthetic */ Color toColor$default(ColorKeyModel colorKeyModel, EditorColorsScheme editorColorsScheme, int n, Object object) {
        if ((n & 1) != 0) {
            editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        }
        return ColorHostKt.toColor(colorKeyModel, editorColorsScheme);
    }

    @NotNull
    public static final Color toColor(@NotNull AbstractColor $this$toColor) {
        Color color;
        Intrinsics.checkNotNullParameter((Object)$this$toColor, (String)"<this>");
        AbstractColor abstractColor = $this$toColor;
        if (abstractColor instanceof RgbaColor) {
            color = new Color(((RgbaColor)$this$toColor).getRed(), ((RgbaColor)$this$toColor).getGreen(), ((RgbaColor)$this$toColor).getBlue(), ((RgbaColor)$this$toColor).getAlpha());
        } else if (abstractColor instanceof RgbColor) {
            color = new Color(((RgbColor)$this$toColor).getRed(), ((RgbColor)$this$toColor).getGreen(), ((RgbColor)$this$toColor).getBlue());
        } else if (abstractColor instanceof DualColor) {
            color = (Color)new JBColor(ColorHostKt.toColor(((DualColor)$this$toColor).getLightColor()), ColorHostKt.toColor(((DualColor)$this$toColor).getDarkColor()));
        } else if (abstractColor instanceof ThemeColorId) {
            color = ColorHost.Companion.getInstance().getColor((ThemeColorId)$this$toColor);
        } else if (abstractColor instanceof NamedColor) {
            color = ColorHost.Companion.getInstance().getColor((NamedColor)$this$toColor);
        } else {
            throw new IllegalArgumentException("Unexpected AbstractColor value: " + $this$toColor);
        }
        return color;
    }

    @NotNull
    public static final AbstractColor toModel(@NotNull Color $this$toModel) {
        Intrinsics.checkNotNullParameter((Object)$this$toModel, (String)"<this>");
        if ($this$toModel instanceof JBColor) {
            Object object = ((JBColor)$this$toModel).getName();
            if (object != null) {
                String string = object;
                boolean bl = false;
                Color color = ((JBColor)$this$toModel).getDefaultColor();
                return new NamedColor(string, color != null ? ColorHostKt.toModel(color) : null);
            }
            object = ColorHostKt.G($this$toModel);
            Object object2 = ((JBColor)$this$toModel).getDarkVariant();
            if (object2 == null || (object2 = ColorHostKt.G((Color)object2)) == null) {
                object2 = object;
            }
            return new DualColor((RgbaColor)object, (RgbaColor)object2);
        }
        return ColorHostKt.G($this$toModel);
    }

    @Nullable
    public static final AbstractColor parseHtmlColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        try {
            Color color2 = ColorUtil.fromHex((String)color);
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"fromHex(...)");
            return ColorHostKt.toModel(color2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private static final RgbaColor G(Color color) {
        return new RgbaColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }
}

