/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.rd.ide.document.DocumentSynchronizerListener;
import com.jetbrains.rd.ide.model.RdDocumentChange;
import com.jetbrains.rd.ide.requests.PatchEngine;
import com.jetbrains.rd.ide.requests.RdPatchEngine;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListeners;", "", "DocumentSynchronizerListeners", "()V", "listeners", "", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListener;", "change", "", "Lcom/jetbrains/rd/ide/model/RdDocumentChange;", "addListener", "listener", "removeListener", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentSynchronizerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentSynchronizerListener.kt\ncom/jetbrains/rd/ide/document/DocumentSynchronizerListeners\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,46:1\n15#2:47\n*S KotlinDebug\n*F\n+ 1 DocumentSynchronizerListener.kt\ncom/jetbrains/rd/ide/document/DocumentSynchronizerListeners\n*L\n32#1:47\n*E\n"})
public final class DocumentSynchronizerListeners {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DocumentSynchronizerListener> listeners = new ArrayList();

    public final void change(@NotNull RdDocumentChange change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ThreadingAssertions.assertEventDispatchThread();
        for (DocumentSynchronizerListener documentSynchronizerListener : this.listeners) {
            try {
                documentSynchronizerListener.change(change);
            }
            catch (Exception exception) {
                boolean bl = false;
                Logger logger = Logger.getInstance(DocumentSynchronizerListener.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error((Throwable)exception);
            }
        }
    }

    public final void addListener(@NotNull DocumentSynchronizerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ThreadingAssertions.assertEventDispatchThread();
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull DocumentSynchronizerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        ThreadingAssertions.assertEventDispatchThread();
        this.listeners.remove(listener2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListeners$Companion;", "", "DocumentSynchronizerListeners$Companion", "()V", "getInstance", "Lcom/jetbrains/rd/ide/document/DocumentSynchronizerListeners;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "engine", "Lcom/jetbrains/rd/ide/requests/PatchEngine;", "intellij.rd.platform"})
    @SourceDebugExtension(value={"SMAP\nDocumentSynchronizerListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentSynchronizerListener.kt\ncom/jetbrains/rd/ide/document/DocumentSynchronizerListeners$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n31#2,2:47\n*S KotlinDebug\n*F\n+ 1 DocumentSynchronizerListener.kt\ncom/jetbrains/rd/ide/document/DocumentSynchronizerListeners$Companion\n*L\n18#1:47,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DocumentSynchronizerListeners getInstance(@NotNull ClientAppSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ComponentManager componentManager = (ComponentManager)session;
            boolean bl = false;
            Class<DocumentSynchronizerListeners> clazz = DocumentSynchronizerListeners.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (DocumentSynchronizerListeners)object;
        }

        @NotNull
        public final DocumentSynchronizerListeners getInstance(@NotNull PatchEngine engine2) {
            Intrinsics.checkNotNullParameter((Object)engine2, (String)"engine");
            return this.getInstance(((RdPatchEngine)engine2).getClientSession());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

