/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.document;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.document.DocumentLogKt;
import com.jetbrains.rd.ide.document.DocumentLogShrinkingSuppressor;
import com.jetbrains.rd.ide.document.DocumentVersionsKt;
import com.jetbrains.rd.ide.model.RdDocumentChangeBase;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0010&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000 \u001d2\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0003J\u0016\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0004J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0003J\u001b\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u001cH\u0096\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLog;", "", "", "Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "Lcom/jetbrains/rd/ide/model/RdDocumentChangeBase;", "considerGlobalSuppressors", "", "DocumentLog", "(Z)V", "history", "Ljava/util/TreeMap;", "value", "lastKnownVersion", "getLastKnownVersion", "()Lcom/jetbrains/rd/ide/model/RdDocumentVersion;", "lastClearedVersion", "updateLastKnownVersion", "", "newVersion", "contains", "version", "addOrUpdate", "change", "add", "G", "rollbackHistoryToVersion", "v", "iterator", "", "Companion", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nDocumentLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentLog.kt\ncom/jetbrains/rd/ide/document/DocumentLog\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n69#2,4:102\n69#2,4:106\n15#2:110\n*S KotlinDebug\n*F\n+ 1 DocumentLog.kt\ncom/jetbrains/rd/ide/document/DocumentLog\n*L\n75#1:102,4\n93#1:106,4\n24#1:110\n*E\n"})
public final class DocumentLog
implements Iterable<Map.Entry<? extends RdDocumentVersion, ? extends RdDocumentChangeBase>>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean considerGlobalSuppressors;
    @NotNull
    private final TreeMap<RdDocumentVersion, RdDocumentChangeBase> history;
    @NotNull
    private RdDocumentVersion lastKnownVersion;
    @NotNull
    private RdDocumentVersion lastClearedVersion;
    @NotNull
    private static final Logger logger;

    public DocumentLog(boolean considerGlobalSuppressors) {
        this.considerGlobalSuppressors = considerGlobalSuppressors;
        this.history = new TreeMap((arg_0, arg_1) -> DocumentLog.G(DocumentLog::G, arg_0, arg_1));
        this.lastKnownVersion = DocumentVersionsKt.getInitialDocVersion();
        this.lastClearedVersion = DocumentVersionsKt.getInitialDocVersion();
    }

    @NotNull
    public final RdDocumentVersion getLastKnownVersion() {
        return this.lastKnownVersion;
    }

    public final void updateLastKnownVersion(@NotNull RdDocumentVersion newVersion) {
        Intrinsics.checkNotNullParameter((Object)newVersion, (String)"newVersion");
        if (this.lastClearedVersion.getValue() < newVersion.getValue()) {
            this.lastKnownVersion = newVersion;
            if (this.G(newVersion)) {
                this.lastClearedVersion = newVersion;
            }
        }
    }

    public final boolean contains(@NotNull RdDocumentVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return ((Map)this.history).containsKey(version);
    }

    public final void addOrUpdate(@NotNull RdDocumentVersion version, @NotNull RdDocumentChangeBase change) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        ((Map)this.history).put(version, change);
    }

    public final void add(@NotNull RdDocumentVersion version, @NotNull RdDocumentChangeBase change) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!((Map)this.history).isEmpty() && this.history.lastKey().getValue() != version.getValue() - 1) {
            logger.error("Incorrect versions");
        }
        this.history.put(version, change);
    }

    private final boolean G(RdDocumentVersion rdDocumentVersion) {
        int n;
        Logger logger;
        if (this.considerGlobalSuppressors && !DocumentLogKt.access$isShrinkingAllowed(rdDocumentVersion)) {
            return false;
        }
        Iterator<RdDocumentVersion> iterator2 = this.history.keySet().iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            if (logger.getValue() >= rdDocumentVersion.getValue()) break;
            iterator2.remove();
            n = n2;
            n2 = n + 1;
        }
        if (n2 > 0) {
            logger = DocumentLog.logger;
            n = 0;
            if (logger.isTraceEnabled()) {
                Logger logger2 = logger;
                boolean bl = false;
                logger2.trace("DocumentLog was shrunk to " + rdDocumentVersion + " version; removed entries: " + n2 + ", new size: " + this.history.size());
            }
        }
        return true;
    }

    public final void rollbackHistoryToVersion(@NotNull RdDocumentVersion v) {
        int n;
        RdDocumentVersion rdDocumentVersion;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Iterator<RdDocumentVersion> iterator2 = this.history.descendingKeySet().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<RdDocumentVersion> iterator3 = iterator2;
        int n2 = 0;
        while (iterator3.hasNext() && (rdDocumentVersion = iterator3.next()).getValue() > v.getValue()) {
            iterator3.remove();
            n = n2;
            n2 = n + 1;
        }
        if (n2 > 0) {
            rdDocumentVersion = logger;
            n = 0;
            if (rdDocumentVersion.isTraceEnabled()) {
                RdDocumentVersion rdDocumentVersion2 = rdDocumentVersion;
                boolean bl = false;
                rdDocumentVersion2.trace("DocumentLog rollback history to " + v + "; removed entries: " + n2 + ", new size: " + this.history.size());
            }
        }
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<RdDocumentVersion, RdDocumentChangeBase>> iterator() {
        return ((Map)this.history).entrySet().iterator();
    }

    private static final int G(RdDocumentVersion rdDocumentVersion, RdDocumentVersion rdDocumentVersion2) {
        return Intrinsics.compare((int)rdDocumentVersion.getValue(), (int)rdDocumentVersion2.getValue());
    }

    private static final int G(Function2 function2, Object object, Object object2) {
        return ((Number)function2.invoke(object, object2)).intValue();
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(DocumentLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DocumentLog.logger = logger;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rd/ide/document/DocumentLog$Companion;", "", "DocumentLog$Companion", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "registerSuppressor", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "suppressor", "Lcom/jetbrains/rd/ide/document/DocumentLogShrinkingSuppressor;", "intellij.rd.platform"})
    public static final class Companion {
        private Companion() {
        }

        public final void registerSuppressor(@NotNull Lifetime lifetime, @NotNull DocumentLogShrinkingSuppressor suppressor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
            lifetime.bracketIfAlive(() -> Companion.G(suppressor), () -> Companion.G(suppressor));
        }

        private static final boolean G(DocumentLogShrinkingSuppressor documentLogShrinkingSuppressor) {
            return DocumentLogKt.access$getSuppressors$p().add(documentLogShrinkingSuppressor);
        }

        private static final Unit G(DocumentLogShrinkingSuppressor documentLogShrinkingSuppressor) {
            DocumentLogKt.access$getSuppressors$p().remove(documentLogShrinkingSuppressor);
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

