/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.lpp;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.cpp.lpp.LivePlusPlusDetector;
import com.jetbrains.rider.lpp.ClientHandler;
import com.jetbrains.rider.lpp.settings.LivePPMode;
import com.jetbrains.rider.lpp.settings.Settings;
import com.jetbrains.rider.lpp.util.PortRegistrar;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0002\u0014\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/lpp/Server;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "portRegistrar", "Lcom/jetbrains/rider/lpp/util/PortRegistrar;", "mutex", "Ljava/lang/Object;", "clients", "", "", "Lcom/jetbrains/rider/lpp/ClientHandler;", "server", "Ljava/net/ServerSocket;", "nextClientId", "initialize", "", "isInitialized", "", "dispose", "Companion", "Initializer", "intellij.rider.plugins.livePlusPlus"})
@SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/lpp/Server\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,137:1\n1#2:138\n15#3:139\n*S KotlinDebug\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/lpp/Server\n*L\n24#1:139\n*E\n"})
public final class Server
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PortRegistrar portRegistrar = new PortRegistrar(this.getServiceLifetime());
    @NotNull
    private final Object mutex = new Object();
    @NotNull
    private final Map<Integer, ClientHandler> clients = new LinkedHashMap();
    @Nullable
    private ServerSocket server;
    private int nextClientId;
    private static final int MAX_NUMBER_OF_ATTEMPTS = 10;
    @NotNull
    private static final Logger LOG;

    private final void initialize() {
        ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)"LivePP.Server", (int)0, () -> Server.initialize$lambda$5(this), (int)21, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean isInitialized() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            boolean bl2 = this.server != null;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            boolean bl = false;
            LOG.info("Disposing server and socket " + (this.server == null ? "is null" : "is not null"));
            for (ClientHandler client : CollectionsKt.toList((Iterable)this.clients.values())) {
                client.close();
            }
            try {
                if (this.server != null) {
                    ServerSocket serverSocket = this.server;
                    Intrinsics.checkNotNull((Object)serverSocket);
                    this.portRegistrar.unregisterPort(serverSocket.getLocalPort());
                    ServerSocket serverSocket2 = this.server;
                    Intrinsics.checkNotNull((Object)serverSocket2);
                    serverSocket2.close();
                    this.server = null;
                }
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit initialize$lambda$5$lambda$4$lambda$2(Server this$0, ClientHandler it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = this$0.mutex;
        synchronized (object) {
            boolean bl = false;
            this$0.clients.remove(it.getId());
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final Unit initialize$lambda$5$lambda$4$lambda$3(ClientHandler $client) {
        $client.start();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Unit initialize$lambda$5(Server this$0) {
        try {
            Object object;
            Object object2 = this$0.mutex;
            synchronized (object2) {
                boolean bl = false;
                int suggestedPort = this$0.portRegistrar.getServerPort();
                for (int i = 1; i < 11; ++suggestedPort, ++i) {
                    try {
                        ServerSocket serverSocket = this$0.server = new ServerSocket(suggestedPort, 0, InetAddress.getLoopbackAddress());
                        Intrinsics.checkNotNull((Object)serverSocket);
                        int serverPort = serverSocket.getLocalPort();
                        LOG.assertTrue(suggestedPort == serverPort);
                        LOG.info("Server is running on port " + serverPort);
                        break;
                    }
                    catch (BindException e) {
                        LOG.info("Failed to open socket on " + suggestedPort + " port " + e.getMessage());
                        continue;
                    }
                }
                if (this$0.server == null) {
                    LOG.error("Failed to open a port in 10 attempts");
                    return Unit.INSTANCE;
                }
                try {
                    PortRegistrar portRegistrar = this$0.portRegistrar;
                    ServerSocket serverSocket = this$0.server;
                    Intrinsics.checkNotNull((Object)serverSocket);
                    portRegistrar.registerPort(serverSocket.getLocalPort());
                }
                catch (Exception e) {
                    LOG.error("Failed to write port number to the file", (Throwable)e);
                    ServerSocket serverSocket = this$0.server;
                    Intrinsics.checkNotNull((Object)serverSocket);
                    serverSocket.close();
                    this$0.server = null;
                    return Unit.INSTANCE;
                }
                object = Unit.INSTANCE;
            }
            while (true) {
                ServerSocket serverSocket = this$0.server;
                Intrinsics.checkNotNull((Object)serverSocket);
                Socket clientSocket = serverSocket.accept();
                object = this$0.mutex;
                synchronized (object) {
                    boolean bl = false;
                    int e = this$0.nextClientId;
                    this$0.nextClientId = e + 1;
                    int clientId = e;
                    LOG.info("Client connected: " + clientSocket.getPort() + ". Client number: " + clientId);
                    Intrinsics.checkNotNull((Object)clientSocket);
                    ClientHandler client = new ClientHandler(clientSocket, clientId);
                    Integer n = clientId;
                    this$0.clients.put(n, client);
                    SourceExKt.adviseEternal((ISource)((ISource)client.getOnClose()), arg_0 -> Server.initialize$lambda$5$lambda$4$lambda$2(this$0, arg_0));
                    Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)true, null, (String)("LivePP.Client." + clientId), (int)0, () -> Server.initialize$lambda$5$lambda$4$lambda$3(client), (int)21, null);
                }
            }
        }
        catch (SocketException e) {
            LOG.info("LivePP-Server-SocketException: " + e.getMessage());
            return Unit.INSTANCE;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Server.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/lpp/Server$Companion;", "", "<init>", "()V", "MAX_NUMBER_OF_ATTEMPTS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/lpp/Server;", "intellij.rider.plugins.livePlusPlus"})
    @SourceDebugExtension(value={"SMAP\nServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/lpp/Server$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,137:1\n40#2,3:138\n*S KotlinDebug\n*F\n+ 1 Server.kt\ncom/jetbrains/rider/lpp/Server$Companion\n*L\n26#1:138,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Server getInstance() {
            boolean $i$f$service = false;
            Class<Server> serviceClass$iv = Server.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (Server)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/lpp/Server$Initializer;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.livePlusPlus"})
    public static final class Initializer
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            LivePPMode enable;
            Server server;
            if (LivePlusPlusDetector.Companion.isLivePPSupportedOnSystem() && !(server = Companion.getInstance()).isInitialized() && ((enable = Settings.Companion.getInstance().getEnableIntegration()) == LivePPMode.ALWAYS_ENABLED || enable == LivePPMode.AUTO_DETECT && LivePlusPlusDetector.Companion.isLivePPDetected())) {
                server.initialize();
            }
            return Unit.INSTANCE;
        }
    }
}

