/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.lpp;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.lpp.MessagesHandler;
import com.jetbrains.rider.lpp.msg.Message;
import com.jetbrains.rider.lpp.msg.MessageType;
import com.jetbrains.rider.lpp.msg.RequestMessage;
import com.jetbrains.rider.lpp.msg.ResponseType;
import com.jetbrains.rider.lpp.msg.impl.ByeBye;
import com.jetbrains.rider.lpp.msg.impl.GetProjectIdAny;
import com.jetbrains.rider.lpp.msg.impl.GetProjectIdByDebuggablePid;
import com.jetbrains.rider.lpp.msg.impl.GetProjectIdByFilePath;
import com.jetbrains.rider.lpp.msg.impl.GetProjectIdResult;
import com.jetbrains.rider.lpp.msg.impl.Handshake;
import com.jetbrains.rider.lpp.msg.impl.Heartbeat;
import com.jetbrains.rider.lpp.util.LivePPCounterUsagesCollector;
import com.jetbrains.rider.lpp.util.LivePPException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.TimeoutCancellationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0006\u0010\u001f\u001a\u00020\u0016J\b\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00000\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006$"}, d2={"Lcom/jetbrains/rider/lpp/ClientHandler;", "", "socket", "Ljava/net/Socket;", "id", "", "<init>", "(Ljava/net/Socket;I)V", "getId", "()I", "outputStream", "Ljava/io/OutputStream;", "kotlin.jvm.PlatformType", "Ljava/io/OutputStream;", "inputStream", "Ljava/io/InputStream;", "Ljava/io/InputStream;", "onClose", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnClose", "()Lcom/jetbrains/rd/util/reactive/Signal;", "start", "", "mainLoop", "handleMsg", "msg", "Lcom/jetbrains/rider/lpp/msg/impl/GetProjectIdByDebuggablePid;", "Lcom/jetbrains/rider/lpp/msg/impl/GetProjectIdByFilePath;", "getAllMessagesHandlers", "", "Lcom/jetbrains/rider/lpp/MessagesHandler;", "close", "readMsg", "Lcom/jetbrains/rider/lpp/msg/Message;", "sendMsg", "Companion", "intellij.rider.plugins.livePlusPlus"})
@SourceDebugExtension(value={"SMAP\nClientHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientHandler.kt\ncom/jetbrains/rider/lpp/ClientHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,199:1\n295#2,2:200\n11158#3:202\n11493#3,2:203\n11495#3:207\n17#4,2:205\n15#5:208\n*S KotlinDebug\n*F\n+ 1 ClientHandler.kt\ncom/jetbrains/rider/lpp/ClientHandler\n*L\n85#1:200,2\n143#1:202\n143#1:203,2\n143#1:207\n143#1:205,2\n19#1:208\n*E\n"})
public final class ClientHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Socket socket;
    private final int id;
    private final OutputStream outputStream;
    private final InputStream inputStream;
    @NotNull
    private final Signal<ClientHandler> onClose;
    @NotNull
    private static final Logger LOG;

    public ClientHandler(@NotNull Socket socket, int id) {
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        this.socket = socket;
        this.id = id;
        this.outputStream = this.socket.getOutputStream();
        this.inputStream = this.socket.getInputStream();
        this.onClose = new Signal();
    }

    public final int getId() {
        return this.id;
    }

    @NotNull
    public final Signal<ClientHandler> getOnClose() {
        return this.onClose;
    }

    public final void start() {
        try {
            Message msg = this.readMsg();
            if (msg instanceof Handshake) {
                this.sendMsg(new Handshake(1));
                boolean isSameProtocolVersion = ((Handshake)msg).getProtocolVersion() == 1;
                LivePPCounterUsagesCollector.INSTANCE.logHandshaked(isSameProtocolVersion);
                if (isSameProtocolVersion) {
                    this.mainLoop();
                    LOG.info("Connection is gracefully closed on client side");
                    this.close();
                    return;
                }
                LOG.warn("Different protocol versions: " + ((Handshake)msg).getProtocolVersion() + " vs 1");
                this.close();
                return;
            }
            LOG.warn("Messaging etiquette is not respected");
            this.close();
        }
        catch (SocketException e) {
            LOG.info("LivePP-Client-SocketException: " + e.getMessage());
            this.close();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            this.close();
        }
    }

    private final void mainLoop() {
        Message msg;
        while (true) {
            Object v0;
            MessagesHandler messagesHandler;
            block13: {
                if ((msg = this.readMsg()) instanceof Heartbeat) {
                    this.sendMsg(new Heartbeat());
                    continue;
                }
                if (msg instanceof ByeBye) {
                    return;
                }
                if (msg instanceof GetProjectIdByDebuggablePid) {
                    this.handleMsg((GetProjectIdByDebuggablePid)msg);
                    continue;
                }
                if (msg instanceof GetProjectIdByFilePath) {
                    this.handleMsg((GetProjectIdByFilePath)msg);
                    continue;
                }
                if (msg instanceof GetProjectIdAny) {
                    messagesHandler = (MessagesHandler)CollectionsKt.firstOrNull(this.getAllMessagesHandlers());
                    if (messagesHandler != null) {
                        short debugSessionId = messagesHandler.getDebugSessionIdAny();
                        this.sendMsg(new GetProjectIdResult(messagesHandler.getProjectId(), debugSessionId));
                        continue;
                    }
                    this.sendMsg(new GetProjectIdResult(-1, -1));
                    continue;
                }
                if (!(msg instanceof RequestMessage)) break;
                Iterable $this$firstOrNull$iv = this.getAllMessagesHandlers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MessagesHandler it = (MessagesHandler)element$iv;
                    boolean bl = false;
                    if (!(it.getProjectId() == ((RequestMessage)msg).getProjectId())) continue;
                    v0 = element$iv;
                    break block13;
                }
                v0 = null;
            }
            messagesHandler = v0;
            if (messagesHandler != null) {
                try {
                    messagesHandler.handle((RequestMessage)msg, (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>((Object)this){

                        public final void invoke(Message p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            ClientHandler.access$sendMsg((ClientHandler)this.receiver, p0);
                        }
                    }));
                }
                catch (LivePPException e) {
                    throw e;
                }
                catch (TimeoutCancellationException e) {
                    LOG.warn("Failed to handle " + msg.getMessageType() + " message because of '" + e.getMessage() + "' - will return timeout error.");
                    this.sendMsg(((RequestMessage)msg).createFailedResponse(ResponseType.Timeout));
                }
                catch (Exception e) {
                    LOG.warn("Failed to handle " + msg.getMessageType() + " message because of '" + e.getMessage() + "' - will return unspecified error.");
                    this.sendMsg(((RequestMessage)msg).createFailedResponse(ResponseType.UnspecifiedError));
                }
                continue;
            }
            this.sendMsg(((RequestMessage)msg).createFailedResponse(ResponseType.InvalidProjectId));
        }
        throw new LivePPException("Unexpected message: " + msg.getMessageType());
    }

    private final void handleMsg(GetProjectIdByDebuggablePid msg) {
        for (MessagesHandler messagesHandler : this.getAllMessagesHandlers()) {
            short debugSessionId = messagesHandler.getDebugSessionIdByDebuggablePid(msg.getPid());
            if (debugSessionId == -1) continue;
            this.sendMsg(new GetProjectIdResult(messagesHandler.getProjectId(), debugSessionId));
            return;
        }
        this.sendMsg(new GetProjectIdResult(-1, -1));
    }

    private final void handleMsg(GetProjectIdByFilePath msg) {
        VirtualFile file = VirtualFileManager.getInstance().getFileSystem("file").findFileByPath(msg.getFile());
        if (file != null) {
            for (MessagesHandler messagesHandler : this.getAllMessagesHandlers()) {
                if (!messagesHandler.doesProjectContainFile(file)) continue;
                this.sendMsg(new GetProjectIdResult(messagesHandler.getProjectId(), -1));
                return;
            }
        } else {
            LOG.warn("Failed to find file: " + msg.getFile());
        }
        this.sendMsg(new GetProjectIdResult(-1, -1));
    }

    /*
     * WARNING - void declaration
     */
    private final List<MessagesHandler> getAllMessagesHandlers() {
        void $this$mapTo$iv$iv;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$map$iv = projectArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Project project = (Project)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            ComponentManager $this$getService$iv = (ComponentManager)it;
            boolean $i$f$getService = false;
            Object object = $this$getService$iv.getService(MessagesHandler.class);
            if (object == null) {
                throw new IllegalStateException("Service " + MessagesHandler.class + " not found in container " + $this$getService$iv);
            }
            collection.add((MessagesHandler)object);
        }
        return (List)destination$iv$iv;
    }

    public final void close() {
        LOG.info("Closing client #" + this.id);
        try {
            this.socket.close();
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        this.onClose.fire((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Message readMsg() {
        try {
            int headerSize = 6;
            InputStream inputStream = this.inputStream;
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            byte[] header = Message.Companion.receiveNBytes(inputStream, headerSize);
            Closeable closeable = new ByteArrayInputStream(header);
            Throwable throwable = null;
            try {
                Message message;
                ByteArrayInputStream headerStream = (ByteArrayInputStream)closeable;
                boolean bl = false;
                int msgSize = Message.Companion.receiveInt32(headerStream);
                short msgType = Message.Companion.receiveInt16(headerStream);
                InputStream inputStream2 = this.inputStream;
                Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"inputStream");
                byte[] payload = Message.Companion.receiveNBytes(inputStream2, msgSize - headerSize);
                Closeable closeable2 = new ByteArrayInputStream(payload);
                Throwable throwable2 = null;
                try {
                    ByteArrayInputStream payloadStream = (ByteArrayInputStream)closeable2;
                    boolean bl2 = false;
                    Message msg = MessageType.Companion.fromInt16(msgType).createEmptyMsg();
                    msg.receive(payloadStream);
                    if (payloadStream.available() != 0) {
                        throw new LivePPException("Message contains more data than expected");
                    }
                    LOG.trace("Received message: " + msg.toDebugString());
                    message = msg;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            CloseableKt.closeFinally((Closeable)closeable2, throwable2);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                Message message2 = message;
                return message2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new LivePPException("Failed to read message", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMsg(Message msg) {
        try {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                LOG.trace("Sending message:  " + msg.toDebugString());
                msg.send(it);
                int msgSize = it.size() + 4;
                OutputStream outputStream = this.outputStream;
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"outputStream");
                Message.Companion.sendInt32(outputStream, msgSize);
                it.writeTo(this.outputStream);
                this.outputStream.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            throw new LivePPException("Failed to send message: " + msg.getMessageType(), e);
        }
    }

    public static final /* synthetic */ void access$sendMsg(ClientHandler $this, Message msg) {
        $this.sendMsg(msg);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ClientHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/lpp/ClientHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.livePlusPlus"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

