/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.base64url.internal.apache.commons.codec.binary;

import java.util.Arrays;
import org.jose4j.lang.StringUtil;

public abstract class BaseNCodec {
    static final int EOF = -1;
    public static final int MIME_CHUNK_SIZE = 76;
    public static final int PEM_CHUNK_SIZE = 64;
    private static final int DEFAULT_BUFFER_RESIZE_FACTOR = 2;
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final int MASK_8BITS = 255;
    protected static final byte PAD_DEFAULT = 61;
    protected final byte PAD = (byte)61;
    private final int unencodedBlockSize;
    private final int encodedBlockSize;
    protected final int lineLength;
    private final int chunkSeparatorLength;

    protected BaseNCodec(int unencodedBlockSize, int encodedBlockSize, int lineLength, int chunkSeparatorLength) {
        this.unencodedBlockSize = unencodedBlockSize;
        this.encodedBlockSize = encodedBlockSize;
        boolean useChunking = lineLength > 0 && chunkSeparatorLength > 0;
        this.lineLength = useChunking ? lineLength / encodedBlockSize * encodedBlockSize : 0;
        this.chunkSeparatorLength = chunkSeparatorLength;
    }

    boolean hasData(Context context2) {
        return context2.buffer != null;
    }

    int available(Context context2) {
        return context2.buffer != null ? context2.pos - context2.readPos : 0;
    }

    protected int getDefaultBufferSize() {
        return 8192;
    }

    private byte[] resizeBuffer(Context context2) {
        if (context2.buffer == null) {
            context2.buffer = new byte[this.getDefaultBufferSize()];
            context2.pos = 0;
            context2.readPos = 0;
        } else {
            byte[] b = new byte[context2.buffer.length * 2];
            System.arraycopy(context2.buffer, 0, b, 0, context2.buffer.length);
            context2.buffer = b;
        }
        return context2.buffer;
    }

    protected byte[] ensureBufferSize(int size, Context context2) {
        if (context2.buffer == null || context2.buffer.length < context2.pos + size) {
            return this.resizeBuffer(context2);
        }
        return context2.buffer;
    }

    int readResults(byte[] b, int bPos, int bAvail, Context context2) {
        if (context2.buffer != null) {
            int len = Math.min(this.available(context2), bAvail);
            System.arraycopy(context2.buffer, context2.readPos, b, bPos, len);
            context2.readPos += len;
            if (context2.readPos >= context2.pos) {
                context2.buffer = null;
            }
            return len;
        }
        return context2.eof ? -1 : 0;
    }

    protected static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public String encodeToString(byte[] pArray) {
        return StringUtil.newStringUtf8(this.encode(pArray));
    }

    public String encodeAsString(byte[] pArray) {
        return StringUtil.newStringUtf8(this.encode(pArray));
    }

    public byte[] decode(String pArray) {
        return this.decode(StringUtil.getBytesUtf8(pArray));
    }

    public byte[] decode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context2 = new Context();
        this.decode(pArray, 0, pArray.length, context2);
        this.decode(pArray, 0, -1, context2);
        byte[] result2 = new byte[context2.pos];
        this.readResults(result2, 0, result2.length, context2);
        return result2;
    }

    public byte[] encode(byte[] pArray) {
        if (pArray == null || pArray.length == 0) {
            return pArray;
        }
        Context context2 = new Context();
        this.encode(pArray, 0, pArray.length, context2);
        this.encode(pArray, 0, -1, context2);
        byte[] buf = new byte[context2.pos - context2.readPos];
        this.readResults(buf, 0, buf.length, context2);
        return buf;
    }

    abstract void encode(byte[] var1, int var2, int var3, Context var4);

    abstract void decode(byte[] var1, int var2, int var3, Context var4);

    protected abstract boolean isInAlphabet(byte var1);

    public boolean isInAlphabet(byte[] arrayOctet, boolean allowWSPad) {
        for (int i = 0; i < arrayOctet.length; ++i) {
            if (this.isInAlphabet(arrayOctet[i]) || allowWSPad && (arrayOctet[i] == 61 || BaseNCodec.isWhiteSpace(arrayOctet[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean isInAlphabet(String basen) {
        return this.isInAlphabet(StringUtil.getBytesUtf8(basen), true);
    }

    protected boolean containsAlphabetOrPad(byte[] arrayOctet) {
        if (arrayOctet == null) {
            return false;
        }
        for (byte element : arrayOctet) {
            if (61 != element && !this.isInAlphabet(element)) continue;
            return true;
        }
        return false;
    }

    public long getEncodedLength(byte[] pArray) {
        long len = (long)((pArray.length + this.unencodedBlockSize - 1) / this.unencodedBlockSize) * (long)this.encodedBlockSize;
        if (this.lineLength > 0) {
            len += (len + (long)this.lineLength - 1L) / (long)this.lineLength * (long)this.chunkSeparatorLength;
        }
        return len;
    }

    static class Context {
        int ibitWorkArea;
        long lbitWorkArea;
        byte[] buffer;
        int pos;
        int readPos;
        boolean eof;
        int currentLinePos;
        int modulus;

        Context() {
        }

        public String toString() {
            return String.format("%s[buffer=%s, currentLinePos=%s, eof=%s, ibitWorkArea=%s, lbitWorkArea=%s, modulus=%s, pos=%s, readPos=%s]", this.getClass().getSimpleName(), Arrays.toString(this.buffer), this.currentLinePos, this.eof, this.ibitWorkArea, this.lbitWorkArea, this.modulus, this.pos, this.readPos);
        }
    }
}

