/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class Streams {
    public static final int BUFFER_SIZE = 4096;

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
        }
        out.flush();
    }

    public static String toString(Reader reader) throws IOException {
        int charsRead;
        StringBuilder out = new StringBuilder(4096);
        char[] buffer = new char[4096];
        while ((charsRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, charsRead);
        }
        return out.toString();
    }

    public static void readFully(InputStream in, byte[] bytes) throws IOException {
        int result2;
        int len = bytes.length;
        for (int total = 0; total < len && (result2 = in.read(bytes, total, len - total)) != -1; total += result2) {
        }
    }
}

