/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="HPAScalingPolicy is a single policy which must hold true for a specified past interval.")
public class V2HPAScalingPolicy {
    public static final String SERIALIZED_NAME_PERIOD_SECONDS = "periodSeconds";
    @SerializedName(value="periodSeconds")
    private Integer periodSeconds;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Integer value;

    public V2HPAScalingPolicy periodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
        return this;
    }

    @ApiModelProperty(required=true, value="periodSeconds specifies the window of time for which the policy should hold true. PeriodSeconds must be greater than zero and less than or equal to 1800 (30 min).")
    public Integer getPeriodSeconds() {
        return this.periodSeconds;
    }

    public void setPeriodSeconds(Integer periodSeconds) {
        this.periodSeconds = periodSeconds;
    }

    public V2HPAScalingPolicy type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type is used to specify the scaling policy.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public V2HPAScalingPolicy value(Integer value2) {
        this.value = value2;
        return this;
    }

    @ApiModelProperty(required=true, value="value contains the amount of change which is permitted by the policy. It must be greater than zero")
    public Integer getValue() {
        return this.value;
    }

    public void setValue(Integer value2) {
        this.value = value2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HPAScalingPolicy v2HPAScalingPolicy = (V2HPAScalingPolicy)o;
        return Objects.equals(this.periodSeconds, v2HPAScalingPolicy.periodSeconds) && Objects.equals(this.type, v2HPAScalingPolicy.type) && Objects.equals(this.value, v2HPAScalingPolicy.value);
    }

    public int hashCode() {
        return Objects.hash(this.periodSeconds, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HPAScalingPolicy {\n");
        sb.append("    periodSeconds: ").append(this.toIndentedString(this.periodSeconds)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

