/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1EnvVarSource;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EnvVar represents an environment variable present in a Container.")
public class V1EnvVar {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private String value;
    public static final String SERIALIZED_NAME_VALUE_FROM = "valueFrom";
    @SerializedName(value="valueFrom")
    private V1EnvVarSource valueFrom;

    public V1EnvVar name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the environment variable. Must be a C_IDENTIFIER.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1EnvVar value(String value2) {
        this.value = value2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variable references $(VAR_NAME) are expanded using the previously defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to \"\".")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value2) {
        this.value = value2;
    }

    public V1EnvVar valueFrom(V1EnvVarSource valueFrom) {
        this.valueFrom = valueFrom;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1EnvVarSource getValueFrom() {
        return this.valueFrom;
    }

    public void setValueFrom(V1EnvVarSource valueFrom) {
        this.valueFrom = valueFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1EnvVar v1EnvVar = (V1EnvVar)o;
        return Objects.equals(this.name, v1EnvVar.name) && Objects.equals(this.value, v1EnvVar.value) && Objects.equals(this.valueFrom, v1EnvVar.valueFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.valueFrom);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1EnvVar {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueFrom: ").append(this.toIndentedString(this.valueFrom)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

