/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ContainerStateTerminated is a terminated state of a container.")
public class V1ContainerStateTerminated {
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "containerID";
    @SerializedName(value="containerID")
    private String containerID;
    public static final String SERIALIZED_NAME_EXIT_CODE = "exitCode";
    @SerializedName(value="exitCode")
    private Integer exitCode;
    public static final String SERIALIZED_NAME_FINISHED_AT = "finishedAt";
    @SerializedName(value="finishedAt")
    private OffsetDateTime finishedAt;
    public static final String SERIALIZED_NAME_MESSAGE = "message";
    @SerializedName(value="message")
    private String message;
    public static final String SERIALIZED_NAME_REASON = "reason";
    @SerializedName(value="reason")
    private String reason;
    public static final String SERIALIZED_NAME_SIGNAL = "signal";
    @SerializedName(value="signal")
    private Integer signal;
    public static final String SERIALIZED_NAME_STARTED_AT = "startedAt";
    @SerializedName(value="startedAt")
    private OffsetDateTime startedAt;

    public V1ContainerStateTerminated containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's ID in the format '<type>://<container_id>'")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public V1ContainerStateTerminated exitCode(Integer exitCode2) {
        this.exitCode = exitCode2;
        return this;
    }

    @ApiModelProperty(required=true, value="Exit status from the last termination of the container")
    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode2) {
        this.exitCode = exitCode2;
    }

    public V1ContainerStateTerminated finishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time at which the container last terminated")
    public OffsetDateTime getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(OffsetDateTime finishedAt) {
        this.finishedAt = finishedAt;
    }

    public V1ContainerStateTerminated message(String message2) {
        this.message = message2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Message regarding the last termination of the container")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message2) {
        this.message = message2;
    }

    public V1ContainerStateTerminated reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="(brief) reason from the last termination of the container")
    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public V1ContainerStateTerminated signal(Integer signal) {
        this.signal = signal;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Signal from the last termination of the container")
    public Integer getSignal() {
        return this.signal;
    }

    public void setSignal(Integer signal) {
        this.signal = signal;
    }

    public V1ContainerStateTerminated startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Time at which previous execution of the container started")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerStateTerminated v1ContainerStateTerminated = (V1ContainerStateTerminated)o;
        return Objects.equals(this.containerID, v1ContainerStateTerminated.containerID) && Objects.equals(this.exitCode, v1ContainerStateTerminated.exitCode) && Objects.equals(this.finishedAt, v1ContainerStateTerminated.finishedAt) && Objects.equals(this.message, v1ContainerStateTerminated.message) && Objects.equals(this.reason, v1ContainerStateTerminated.reason) && Objects.equals(this.signal, v1ContainerStateTerminated.signal) && Objects.equals(this.startedAt, v1ContainerStateTerminated.startedAt);
    }

    public int hashCode() {
        return Objects.hash(this.containerID, this.exitCode, this.finishedAt, this.message, this.reason, this.signal, this.startedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerStateTerminated {\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    finishedAt: ").append(this.toIndentedString(this.finishedAt)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    signal: ").append(this.toIndentedString(this.signal)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString(this.startedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

