/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="APIServiceSpec contains information for locating and communicating with a server. Only https is supported, though you are able to disable certificate verification.")
public class V1APIServiceSpec {
    public static final String SERIALIZED_NAME_CA_BUNDLE = "caBundle";
    @SerializedName(value="caBundle")
    private byte[] caBundle;
    public static final String SERIALIZED_NAME_GROUP = "group";
    @SerializedName(value="group")
    private String group;
    public static final String SERIALIZED_NAME_GROUP_PRIORITY_MINIMUM = "groupPriorityMinimum";
    @SerializedName(value="groupPriorityMinimum")
    private Integer groupPriorityMinimum;
    public static final String SERIALIZED_NAME_INSECURE_SKIP_T_L_S_VERIFY = "insecureSkipTLSVerify";
    @SerializedName(value="insecureSkipTLSVerify")
    private Boolean insecureSkipTLSVerify;
    public static final String SERIALIZED_NAME_SERVICE = "service";
    @SerializedName(value="service")
    private ApiregistrationV1ServiceReference service;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private String version;
    public static final String SERIALIZED_NAME_VERSION_PRIORITY = "versionPriority";
    @SerializedName(value="versionPriority")
    private Integer versionPriority;

    public V1APIServiceSpec caBundle(byte[] caBundle) {
        this.caBundle = caBundle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CABundle is a PEM encoded CA bundle which will be used to validate an API server's serving certificate. If unspecified, system trust roots on the apiserver are used.")
    public byte[] getCaBundle() {
        return this.caBundle;
    }

    public void setCaBundle(byte[] caBundle) {
        this.caBundle = caBundle;
    }

    public V1APIServiceSpec group(String group2) {
        this.group = group2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Group is the API group name this server hosts")
    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group2) {
        this.group = group2;
    }

    public V1APIServiceSpec groupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return this;
    }

    @ApiModelProperty(required=true, value="GroupPriorityMininum is the priority this group should have at least. Higher priority means that the group is preferred by clients over lower priority ones. Note that other versions of this group might specify even higher GroupPriorityMininum values such that the whole group gets a higher priority. The primary sort is based on GroupPriorityMinimum, ordered highest number to lowest (20 before 10). The secondary sort is based on the alphabetical comparison of the name of the object.  (v1.bar before v1.foo) We'd recommend something like: *.k8s.io (except extensions) at 18000 and PaaSes (OpenShift, Deis) are recommended to be in the 2000s")
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    public void setGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
    }

    public V1APIServiceSpec insecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="InsecureSkipTLSVerify disables TLS certificate verification when communicating with this server. This is strongly discouraged.  You should use the CABundle instead.")
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    public void setInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
    }

    public V1APIServiceSpec service(ApiregistrationV1ServiceReference service) {
        this.service = service;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ApiregistrationV1ServiceReference getService() {
        return this.service;
    }

    public void setService(ApiregistrationV1ServiceReference service) {
        this.service = service;
    }

    public V1APIServiceSpec version(String version) {
        this.version = version;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Version is the API version this server hosts.  For example, \"v1\"")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public V1APIServiceSpec versionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return this;
    }

    @ApiModelProperty(required=true, value="VersionPriority controls the ordering of this API version inside of its group.  Must be greater than zero. The primary sort is based on VersionPriority, ordered highest to lowest (20 before 10). Since it's inside of a group, the number can be small, probably in the 10s. In case of equal version priorities, the version string will be used to compute the order inside a group. If the version string is \"kube-like\", it will sort above non \"kube-like\" version strings, which are ordered lexicographically. \"Kube-like\" versions start with a \"v\", then are followed by a number (the major version), then optionally the string \"alpha\" or \"beta\" and another number (the minor version). These are sorted first by GA > beta > alpha (where GA is a version with no suffix such as beta or alpha), and then by comparing major version, then minor version. An example sorted list of versions: v10, v2, v1, v11beta2, v10beta3, v3beta1, v12alpha1, v11alpha2, foo1, foo10.")
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    public void setVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIServiceSpec v1APIServiceSpec = (V1APIServiceSpec)o;
        return Arrays.equals(this.caBundle, v1APIServiceSpec.caBundle) && Objects.equals(this.group, v1APIServiceSpec.group) && Objects.equals(this.groupPriorityMinimum, v1APIServiceSpec.groupPriorityMinimum) && Objects.equals(this.insecureSkipTLSVerify, v1APIServiceSpec.insecureSkipTLSVerify) && Objects.equals(this.service, v1APIServiceSpec.service) && Objects.equals(this.version, v1APIServiceSpec.version) && Objects.equals(this.versionPriority, v1APIServiceSpec.versionPriority);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.caBundle), this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIServiceSpec {\n");
        sb.append("    caBundle: ").append(this.toIndentedString(this.caBundle)).append("\n");
        sb.append("    group: ").append(this.toIndentedString(this.group)).append("\n");
        sb.append("    groupPriorityMinimum: ").append(this.toIndentedString(this.groupPriorityMinimum)).append("\n");
        sb.append("    insecureSkipTLSVerify: ").append(this.toIndentedString(this.insecureSkipTLSVerify)).append("\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionPriority: ").append(this.toIndentedString(this.versionPriority)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

