/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.IOTrio;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1StatusCause;
import io.kubernetes.client.openapi.models.V1StatusDetails;
import io.kubernetes.client.util.Streams;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Exec {
    private static final Logger log = LoggerFactory.getLogger(Exec.class);
    private ApiClient apiClient;
    private Consumer<Throwable> onUnhandledError;

    public Exec() {
        this(Configuration.getDefaultApiClient());
    }

    public Exec(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Consumer<Throwable> getOnUnhandledError() {
        return this.onUnhandledError;
    }

    public void setOnUnhandledError(Consumer<Throwable> onUnhandledError) {
        this.onUnhandledError = onUnhandledError;
    }

    public ExecutionBuilder newExecutionBuilder(String namespace, String name, String[] command2) {
        return new ExecutionBuilder(namespace, name, command2);
    }

    public Process exec(String namespace, String name, String[] command2, boolean stdin) throws ApiException, IOException {
        return this.exec(namespace, name, command2, null, stdin, false);
    }

    public Process exec(V1Pod pod, String[] command2, boolean stdin) throws ApiException, IOException {
        return this.exec(pod, command2, pod.getSpec().getContainers().get(0).getName(), stdin, false);
    }

    public Process exec(String namespace, String name, String[] command2, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(namespace, name, command2, null, stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command2, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(pod, command2, pod.getSpec().getContainers().get(0).getName(), stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command2, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        if (container == null) {
            container = pod.getSpec().getContainers().get(0).getName();
        }
        return this.exec(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), command2, container, stdin, tty);
    }

    public Process exec(String namespace, String name, String[] command2, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return new ExecutionBuilder(namespace, name, command2).setContainer(container).setStdin(stdin).setTty(tty).setOnUnhandledError(this.onUnhandledError).execute();
    }

    public Future<Integer> exec(String namespace, String podName, Consumer<IOTrio> onOpen, BiConsumer<Integer, IOTrio> onClosed, BiConsumer<Throwable, IOTrio> onError, Long timeoutMs, boolean tty, String ... command2) throws IOException {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        IOTrio io = new IOTrio();
        String cmdStr = Arrays.toString(command2);
        BiConsumer<Throwable, IOTrio> errHandler = (err, errIO) -> {
            if (onError != null) {
                onError.accept((Throwable)err, (IOTrio)errIO);
            }
        };
        try {
            Process process = this.exec(namespace, podName, command2, null, true, tty);
            io.onClose((code, timeout) -> {
                process.destroy();
                this.waitForProcessToExit(process, (Long)timeout, cmdStr, err -> errHandler.accept((Throwable)err, io));
            });
            io.setStdin(process.getOutputStream());
            io.setStdout(process.getInputStream());
            io.setStderr(process.getErrorStream());
            this.runAsync("Process-Waiting-Thread-" + command2[0] + "-" + podName, () -> {
                Supplier<Integer> returnCode = process::exitValue;
                try {
                    log.debug("Waiting for process to close in {} ms: {}", (Object)timeoutMs, (Object)cmdStr);
                    boolean beforeTimeout = this.waitForProcessToExit(process, timeoutMs, cmdStr, err -> errHandler.accept((Throwable)err, io));
                    if (!beforeTimeout) {
                        returnCode = () -> Integer.MAX_VALUE;
                    }
                }
                catch (Exception e) {
                    errHandler.accept(e, io);
                }
                log.debug("process.onExit({}): {}", (Object)returnCode.get(), (Object)cmdStr);
                if (onClosed != null) {
                    onClosed.accept(returnCode.get(), io);
                }
                future.complete(returnCode.get());
            });
            if (onOpen != null) {
                onOpen.accept(io);
            }
        }
        catch (ApiException e) {
            errHandler.accept(e, io);
            future.completeExceptionally(e);
        }
        return future;
    }

    protected void runAsync(String taskName, Runnable task) {
        Thread thread = new Thread(task);
        thread.setName(taskName);
        thread.start();
    }

    private boolean waitForProcessToExit(Process process, Long timeoutMs, String cmdStr, Consumer<Exception> onError) {
        boolean beforeTimeout = true;
        if (timeoutMs != null && timeoutMs >= 0L) {
            boolean exited = false;
            try {
                exited = process.waitFor(timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                onError.accept(e);
            }
            log.debug("Process closed={}: {}", (Object)exited, (Object)cmdStr);
            if (!exited && process.isAlive()) {
                beforeTimeout = false;
                log.warn("Process timed out after {} ms. Shutting down: {}", (Object)timeoutMs, (Object)cmdStr);
                process.destroy();
            }
        } else {
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                onError.accept(e);
            }
        }
        return beforeTimeout;
    }

    static int parseExitCode(ApiClient client, InputStream inputStream) {
        try {
            List<V1StatusCause> causes;
            V1StatusDetails details;
            String body;
            Type returnType = new TypeToken<V1Status>(){}.getType();
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                body = Streams.toString(reader);
            }
            V1Status status = (V1Status)client.getJSON().deserialize(body, returnType);
            if (status == null) {
                return -1;
            }
            if ("Success".equals(status.getStatus())) {
                return 0;
            }
            if ("NonZeroExitCode".equals(status.getReason()) && (details = status.getDetails()) != null && (causes = details.getCauses()) != null) {
                for (V1StatusCause cause : causes) {
                    if (!"ExitCode".equals(cause.getReason())) continue;
                    try {
                        return Integer.parseInt(cause.getMessage());
                    }
                    catch (NumberFormatException nfe) {
                        log.error("Error parsing exit code from status channel response", (Throwable)nfe);
                    }
                }
            }
        }
        catch (Throwable t) {
            log.error("Error parsing exit code from status channel response", t);
        }
        return -1;
    }

    public final class ExecutionBuilder {
        private final String namespace;
        private final String name;
        private final String[] command;
        private String container;
        private boolean stdin;
        private boolean stdout;
        private boolean stderr;
        private boolean tty;
        private Consumer<Throwable> onUnhandledError;

        private ExecutionBuilder(String namespace, String name, String[] command2) {
            this.namespace = namespace;
            this.name = name;
            this.command = command2;
            this.stdin = true;
            this.stdout = true;
            this.stderr = true;
        }

        public String getName() {
            return this.name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String[] getCommand() {
            return this.command;
        }

        public String getContainer() {
            return this.container;
        }

        public ExecutionBuilder setContainer(String container) {
            this.container = container;
            return this;
        }

        public boolean getStdin() {
            return this.stdin;
        }

        public ExecutionBuilder setStdin(boolean stdin) {
            this.stdin = stdin;
            return this;
        }

        public boolean getStdout() {
            return this.stdout;
        }

        public ExecutionBuilder setStdout(boolean stdout) {
            this.stdout = stdout;
            return this;
        }

        public boolean getStderr() {
            return this.stderr;
        }

        public ExecutionBuilder setStderr(boolean stderr) {
            this.stderr = stderr;
            return this;
        }

        public boolean getTty() {
            return this.tty;
        }

        public ExecutionBuilder setTty(boolean tty) {
            this.tty = tty;
            return this;
        }

        public Consumer<Throwable> getOnUnhandledError() {
            return this.onUnhandledError;
        }

        public ExecutionBuilder setOnUnhandledError(Consumer<Throwable> onUnhandledError) {
            this.onUnhandledError = onUnhandledError;
            return this;
        }

        private String makePath() {
            Object[] encodedCommand = new String[this.command.length];
            for (int i = 0; i < this.command.length; ++i) {
                try {
                    encodedCommand[i] = URLEncoder.encode(this.command[i], "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("some thing wrong happend: " + ex.getMessage());
                }
            }
            return "/api/v1/namespaces/" + this.namespace + "/pods/" + this.name + "/exec?stdin=" + this.stdin + "&stdout=" + this.stdout + "&stderr=" + this.stderr + "&tty=" + this.tty + (this.container != null ? "&container=" + this.container : "") + "&command=" + StringUtils.join((Object[])encodedCommand, (String)"&command=");
        }

        public Process execute() throws ApiException, IOException {
            if (this.container == null) {
                CoreV1Api api = new CoreV1Api(Exec.this.apiClient);
                V1Pod pod = api.readNamespacedPod(this.name, this.namespace, "false");
                this.container = pod.getSpec().getContainers().get(0).getName();
            }
            ExecProcess exec = new ExecProcess(Exec.this.apiClient, this.onUnhandledError);
            WebSocketStreamHandler handler = exec.getHandler();
            WebSockets.stream(this.makePath(), "GET", Exec.this.apiClient, handler);
            return exec;
        }
    }

    public static class ExecProcess
    extends Process {
        private final WebSocketStreamHandler streamHandler;
        private final Consumer<Throwable> onUnhandledError;
        private int statusCode = -1;
        private boolean isAlive = true;
        private final Map<Integer, InputStream> input = new HashMap<Integer, InputStream>();
        private final CountDownLatch latch = new CountDownLatch(1);

        public ExecProcess(ApiClient apiClient) throws IOException {
            this(apiClient, Throwable::printStackTrace);
        }

        public ExecProcess(final ApiClient apiClient, Consumer<Throwable> onUnhandledError) throws IOException {
            this.onUnhandledError = Optional.ofNullable(onUnhandledError).orElse(Throwable::printStackTrace);
            this.streamHandler = new WebSocketStreamHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void handleMessage(int stream, InputStream inStream) throws IOException {
                    if (stream == 3) {
                        int exitCode2 = Exec.parseExitCode(apiClient, inStream);
                        if (exitCode2 >= 0) {
                            ExecProcess execProcess = this;
                            synchronized (execProcess) {
                                statusCode = exitCode2;
                                isAlive = false;
                            }
                        }
                        inStream.close();
                        this.close();
                        latch.countDown();
                    } else {
                        super.handleMessage(stream, inStream);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void failure(Throwable ex) {
                    super.failure(ex);
                    onUnhandledError.accept(ex);
                    ExecProcess execProcess = this;
                    synchronized (execProcess) {
                        statusCode = -1975219;
                        isAlive = false;
                        latch.countDown();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() {
                    ExecProcess execProcess = this;
                    synchronized (execProcess) {
                        if (isAlive) {
                            isAlive = false;
                            latch.countDown();
                        }
                    }
                    super.close();
                }
            };
        }

        protected WebSocketStreamHandler getHandler() {
            return this.streamHandler;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.streamHandler.getOutputStream(0);
        }

        @Override
        public InputStream getInputStream() {
            return this.getInputStream(1);
        }

        @Override
        public InputStream getErrorStream() {
            return this.getInputStream(2);
        }

        public InputStream getConnectionErrorStream() {
            return this.getInputStream(3);
        }

        public OutputStream getResizeStream() {
            return this.streamHandler.getOutputStream(4);
        }

        private synchronized InputStream getInputStream(int stream) {
            if (!this.input.containsKey(stream)) {
                this.input.put(stream, this.streamHandler.getInputStream(stream));
            }
            return this.input.get(stream);
        }

        @Override
        public int waitFor() throws InterruptedException {
            this.latch.await();
            return this.statusCode;
        }

        @Override
        public boolean waitFor(long timeout, TimeUnit unit) throws InterruptedException {
            this.latch.await(timeout, unit);
            return !this.isAlive();
        }

        @Override
        public synchronized int exitValue() {
            if (this.isAlive) {
                throw new IllegalThreadStateException();
            }
            return this.statusCode;
        }

        @Override
        public synchronized boolean isAlive() {
            return this.isAlive;
        }

        @Override
        public void destroy() {
            this.streamHandler.close();
            for (InputStream in : this.input.values()) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    log.error("Error on close", (Throwable)ex);
                }
            }
        }
    }
}

