/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.settings;

import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.ui.settings.KubernetesSettingsPanel;
import com.intellij.kubernetes.view.ui.settings.Scope;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\f\u001a\r\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f0\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesSettingsPanel;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "namespacesView", "Lcom/intellij/ui/table/TableView;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$TableItem;", "isModified", "", "()Z", "namespaces", "Ljava/util/SortedSet;", "", "Lcom/intellij/openapi/util/NlsSafe;", "scope", "Lcom/intellij/kubernetes/view/ui/settings/Scope;", "apply", "", "reset", "NamespaceColumnInfo", "ScopeColumnInfo", "TableItem", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNamespacesSettingsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNamespacesSettingsPanel.kt\ncom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,132:1\n1628#2,3:133\n1628#2,3:136\n1010#2,2:139\n19#3:141\n*S KotlinDebug\n*F\n+ 1 KubernetesNamespacesSettingsPanel.kt\ncom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel\n*L\n95#1:133,3\n98#1:136,3\n100#1:139,2\n59#1:141\n*E\n"})
public final class KubernetesNamespacesSettingsPanel
extends KubernetesSettingsPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final TableView<TableItem> namespacesView;

    public KubernetesNamespacesSettingsPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(new BorderLayout());
        this.project = project;
        this.namespacesView = new TableView();
        this.namespacesView.setShowGrid(false);
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{new NamespaceColumnInfo(), new ScopeColumnInfo()};
        this.namespacesView.setModelAndUpdateColumns(new ListTableModel(columnInfoArray));
        StatusText statusText = this.namespacesView.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        StatusText emptyText = statusText;
        emptyText.clear();
        emptyText.appendLine(KubernetesBundle.message("KubernetesNamespacesSettingsPanel.NamespacesTable.emptyText.line1", new Object[0]));
        emptyText.appendLine(KubernetesBundle.message("KubernetesNamespacesSettingsPanel.NamespacesTable.emptyText.line2", new Object[0]));
        emptyText.appendLine(KubernetesBundle.message("KubernetesNamespacesSettingsPanel.NamespacesTable.emptyText.line3", new Object[0]));
        this.add((Component)ToolbarDecorator.createDecorator((JTable)((JTable)this.namespacesView)).disableUpDownActions().setAddAction(arg_0 -> KubernetesNamespacesSettingsPanel._init_$lambda$1(this, arg_0)).setRemoveAction(arg_0 -> KubernetesNamespacesSettingsPanel._init_$lambda$2(this, arg_0)).createPanel(), "Center");
    }

    @Override
    public boolean isModified() {
        return !Intrinsics.areEqual(KubernetesApiGlobalSettings.Companion.getInstance().getNamespaces(), this.namespaces(Scope.GLOBAL)) || !Intrinsics.areEqual(KubernetesApiProjectSettings.Companion.getInstance(this.project).getNamespaces(), this.namespaces(Scope.PROJECT));
    }

    private final SortedSet<String> namespaces(Scope scope2) {
        List list2 = this.namespacesView.getListTableModel().getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getItems(...)");
        return SequencesKt.toSortedSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), arg_0 -> KubernetesNamespacesSettingsPanel.namespaces$lambda$3(scope2, arg_0)), KubernetesNamespacesSettingsPanel::namespaces$lambda$4), KubernetesNamespacesSettingsPanel::namespaces$lambda$5));
    }

    @Override
    public void apply() {
        KubernetesApiGlobalSettings.Companion.getInstance().setNamespaces((Set<String>)this.namespaces(Scope.GLOBAL));
        KubernetesApiProjectSettings.Companion.getInstance(this.project).setNamespaces((Set<String>)this.namespaces(Scope.PROJECT));
    }

    @Override
    public void reset() {
        String it;
        Collection collection;
        List items = new ArrayList();
        Iterable $this$mapTo$iv = KubernetesApiGlobalSettings.Companion.getInstance().getNamespaces();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            String string = (String)item$iv;
            collection = items;
            boolean bl = false;
            collection.add(new TableItem(it, Scope.GLOBAL));
        }
        $this$mapTo$iv = KubernetesApiProjectSettings.Companion.getInstance(this.project).getNamespaces();
        $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            it = (String)item$iv;
            collection = items;
            boolean bl = false;
            collection.add(new TableItem(it, Scope.PROJECT));
        }
        List $this$sortBy$iv = items;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    TableItem p0 = (TableItem)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)p0.getNamespace());
                    p0 = (TableItem)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)p0.getNamespace())));
                }
            });
        }
        this.namespacesView.getListTableModel().setItems(items);
    }

    private static final Unit lambda$1$lambda$0(KubernetesNamespacesSettingsPanel this$0, int $index) {
        block1: {
            TableUtil.scrollSelectionToVisible((JTable)((JTable)this$0.namespacesView));
            TableUtil.editCellAt((JTable)((JTable)this$0.namespacesView), (int)$index, (int)0);
            Component $this$asSafely$iv = this$0.namespacesView.getEditorComponent();
            boolean $i$f$asSafely = false;
            Component component2 = $this$asSafely$iv;
            if (!(component2 instanceof JTextComponent)) {
                component2 = null;
            }
            JTextComponent jTextComponent = (JTextComponent)component2;
            if (jTextComponent == null) break block1;
            jTextComponent.selectAll();
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(KubernetesNamespacesSettingsPanel this$0, AnActionButton it) {
        this$0.namespacesView.stopEditing();
        ListTableModel model2 = this$0.namespacesView.getListTableModel();
        int index = model2.getRowCount();
        String string = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
        if (string == null) {
            string = "";
        }
        model2.addRow((Object)new TableItem(string, null, 2, null));
        this$0.namespacesView.setRowSelectionInterval(index, index);
        ActionsKt.invokeLater$default(null, () -> KubernetesNamespacesSettingsPanel.lambda$1$lambda$0(this$0, index), (int)1, null);
    }

    private static final void _init_$lambda$2(KubernetesNamespacesSettingsPanel this$0, AnActionButton it) {
        this$0.namespacesView.stopEditing();
        TableUtil.removeSelectedItems((JTable)((JTable)this$0.namespacesView));
    }

    private static final boolean namespaces$lambda$3(Scope $scope, TableItem it) {
        return it.getScope() == $scope;
    }

    private static final String namespaces$lambda$4(TableItem it) {
        return it.getNamespace();
    }

    private static final boolean namespaces$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return StringsKt.isBlank((CharSequence)it);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$NamespaceColumnInfo;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$TableItem;", "", "<init>", "()V", "valueOf", "item", "isCellEditable", "", "setValue", "", "value", "intellij.clouds.kubernetes"})
    private static final class NamespaceColumnInfo
    extends ColumnInfo<TableItem, String> {
        public NamespaceColumnInfo() {
            super(KubernetesBundle.message("KubernetesNamespacesSettingsPanel.NamespaceColumn.name", new Object[0]));
        }

        @NotNull
        public String valueOf(@NotNull TableItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getNamespace();
        }

        public boolean isCellEditable(@NotNull TableItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return true;
        }

        public void setValue(@NotNull TableItem item, @NotNull String value2) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            item.setNamespace(value2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$ScopeColumnInfo;", "Lcom/intellij/kubernetes/view/ui/settings/Scope$ColumnInfoBase;", "Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$TableItem;", "<init>", "()V", "valueOf", "Lcom/intellij/kubernetes/view/ui/settings/Scope;", "item", "setValue", "", "value", "intellij.clouds.kubernetes"})
    private static final class ScopeColumnInfo
    extends Scope.ColumnInfoBase<TableItem> {
        @NotNull
        public Scope valueOf(@NotNull TableItem item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return item.getScope();
        }

        public void setValue(@NotNull TableItem item, @NotNull Scope value2) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
            item.setScope(value2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesNamespacesSettingsPanel$TableItem;", "", "namespace", "", "scope", "Lcom/intellij/kubernetes/view/ui/settings/Scope;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/view/ui/settings/Scope;)V", "getNamespace", "()Ljava/lang/String;", "setNamespace", "(Ljava/lang/String;)V", "getScope", "()Lcom/intellij/kubernetes/view/ui/settings/Scope;", "setScope", "(Lcom/intellij/kubernetes/view/ui/settings/Scope;)V", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.clouds.kubernetes"})
    private static final class TableItem {
        @NotNull
        private String namespace;
        @NotNull
        private Scope scope;

        public TableItem(@NotNull String namespace, @NotNull Scope scope2) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)((Object)scope2), (String)"scope");
            this.namespace = namespace;
            this.scope = scope2;
        }

        public /* synthetic */ TableItem(String string, Scope scope2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                scope2 = Scope.PROJECT;
            }
            this(string, scope2);
        }

        @NotNull
        public final String getNamespace() {
            return this.namespace;
        }

        public final void setNamespace(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.namespace = string;
        }

        @NotNull
        public final Scope getScope() {
            return this.scope;
        }

        public final void setScope(@NotNull Scope scope2) {
            Intrinsics.checkNotNullParameter((Object)((Object)scope2), (String)"<set-?>");
            this.scope = scope2;
        }

        @NotNull
        public final String component1() {
            return this.namespace;
        }

        @NotNull
        public final Scope component2() {
            return this.scope;
        }

        @NotNull
        public final TableItem copy(@NotNull String namespace, @NotNull Scope scope2) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            Intrinsics.checkNotNullParameter((Object)((Object)scope2), (String)"scope");
            return new TableItem(namespace, scope2);
        }

        public static /* synthetic */ TableItem copy$default(TableItem tableItem, String string, Scope scope2, int n, Object object) {
            if ((n & 1) != 0) {
                string = tableItem.namespace;
            }
            if ((n & 2) != 0) {
                scope2 = tableItem.scope;
            }
            return tableItem.copy(string, scope2);
        }

        @NotNull
        public String toString() {
            return "TableItem(namespace=" + this.namespace + ", scope=" + this.scope + ")";
        }

        public int hashCode() {
            int result2 = this.namespace.hashCode();
            result2 = result2 * 31 + this.scope.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TableItem)) {
                return false;
            }
            TableItem tableItem = (TableItem)other;
            if (!Intrinsics.areEqual((Object)this.namespace, (Object)tableItem.namespace)) {
                return false;
            }
            return this.scope == tableItem.scope;
        }

        public TableItem() {
            this(null, null, 3, null);
        }
    }
}

