/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesLogsService;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeploymentActionBase;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeploymentDownloadLogAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeploymentActionBase;", "<init>", "()V", "update", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes"})
public final class KubernetesDeploymentDownloadLogAction
extends KubernetesDeploymentActionBase {
    @Override
    protected void update(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Presentation presentation = event2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Object[] objectArray = new Object[1];
        Object t = this.getResource(event2);
        Intrinsics.checkNotNull(t);
        V1ObjectMeta v1ObjectMeta = ((V1Deployment)t).getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        objectArray[0] = v1ObjectMeta.getName();
        Supplier<String> supplier = KubernetesBundle.messagePointer("action.Kubernetes.DeploymentDownloadLog.named.description", objectArray);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        Supplier<String> description = supplier;
        presentation2.setDescription(description);
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModel apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, "deployment-download");
        KubernetesLogsService kubernetesLogsService = KubernetesLogsService.Companion.getInstance(project2);
        Object t = this.getResource(event2);
        Intrinsics.checkNotNull(t);
        V1Deployment v1Deployment = (V1Deployment)t;
        KubernetesResourceMapper kubernetesResourceMapper = this.getMapper(event2);
        Intrinsics.checkNotNull(kubernetesResourceMapper);
        kubernetesLogsService.scheduleDownloading(apiModel2, v1Deployment, kubernetesResourceMapper);
    }
}

