/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.execution.ui.ConsoleView;
import com.intellij.kubernetes.util.ConsoleUtilitiesKt;
import com.intellij.kubernetes.view.ui.KubernetesColoredConsoleView;
import com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesDeploymentLogPanel;", "Lcom/intellij/kubernetes/view/ui/KubernetesConsoleViewPanel;", "Lio/kubernetes/client/openapi/models/V1Deployment;", "deployment", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Deployment;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;)V", "supports", "", "key", "", "reportError", "", "throwable", "", "intellij.clouds.kubernetes"})
public final class KubernetesDeploymentLogPanel
extends KubernetesConsoleViewPanel<V1Deployment> {
    public KubernetesDeploymentLogPanel(@NotNull V1Deployment deployment, @NotNull Disposable parentDisposable, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(deployment, parentDisposable, project, (ConsoleView)new KubernetesColoredConsoleView(project), null, 16, null);
    }

    @Override
    public boolean supports(@NotNull Object key) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        V1ObjectMeta v1ObjectMeta = ((V1Deployment)this.getKey$intellij_clouds_kubernetes()).getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        return Intrinsics.areEqual((Object)v1ObjectMeta.getName(), (object = key instanceof V1Deployment ? (V1Deployment)key : null) != null && (object = ((V1Deployment)object).getMetadata()) != null ? ((V1ObjectMeta)object).getName() : null);
    }

    public final void reportError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        ConsoleUtilitiesKt.printError(this.getConsole(), throwable);
    }
}

