/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.notification;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.ui.NotificationsKt;
import com.intellij.kubernetes.util.KubernetesRuntimeUtilitiesKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\rJ\u0013\u0010\u0011\u001a\u00020\r2\u000b\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014J\u0006\u0010\u0018\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "notified", "Ljava/util/concurrent/atomic/AtomicBoolean;", "exceptionHandler", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "getExceptionHandler", "()Lkotlinx/coroutines/CoroutineExceptionHandler;", "reportRequestError", "", "throwable", "", "reset", "reportWarning", "message", "", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "installationNotification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "showKubernetesInstallationNotification", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n+ 2 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 KubernetesRuntimeUtilities.kt\ncom/intellij/kubernetes/util/KubernetesRuntimeUtilitiesKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n44#2,4:104\n25#3:108\n25#3:110\n9#4:109\n1557#5:111\n1628#5,3:112\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager\n*L\n28#1:104,4\n43#1:108\n62#1:110\n48#1:109\n79#1:111\n79#1:112,3\n*E\n"})
public final class KubernetesNotificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicBoolean notified;
    @NotNull
    private final CoroutineExceptionHandler exceptionHandler;
    @NotNull
    private final AtomicReference<Notification> installationNotification;

    public KubernetesNotificationManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.notified = new AtomicBoolean();
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        this.exceptionHandler = new CoroutineExceptionHandler(key, this){
            final /* synthetic */ KubernetesNotificationManager this$0;
            {
                this.this$0 = kubernetesNotificationManager;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                this.this$0.reset();
                this.this$0.reportRequestError(throwable);
            }
        };
        this.installationNotification = new AtomicReference();
    }

    @NotNull
    public final CoroutineExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void reportRequestError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        KubernetesRuntimeUtilitiesKt.logOrWarnWithDebug(logger, throwable);
        if (!this.notified.compareAndSet(false, true)) {
            return;
        }
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message("KubernetesNotificationManager.requestError.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Throwable $this$messageOrClass$iv = throwable;
        boolean $i$f$getMessageOrClass = false;
        String string2 = $this$messageOrClass$iv.getMessage();
        if (string2 == null) {
            String string3 = $this$messageOrClass$iv.getClass().getName();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        }
        String string4 = StringUtil.shortenTextWithEllipsis((String)string2, (int)250, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"shortenTextWithEllipsis(...)");
        notificationGroup.createNotification(string, string4, NotificationType.ERROR).addAction(ActionManager.getInstance().getAction("Kubernetes.CustomizeNotifications")).notify(this.project);
    }

    public final void reset() {
        this.notified.set(false);
    }

    public final void reportWarning(@NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        KubernetesNotificationManager $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KubernetesNotificationManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unable to perform operation " + message2);
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message("KubernetesNotificationManager.message.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, message2, NotificationType.WARNING).notify(this.project);
    }

    /*
     * WARNING - void declaration
     */
    public final void showKubernetesInstallationNotification() {
        Notification updated;
        void $this$mapTo$iv$iv;
        ActionManager actionManager = ActionManager.getInstance();
        Object[] objectArray = new String[]{"Kubernetes.InstallKubectl", "Kubernetes.HowToInstallKubectlAction", "Kubernetes.ShowSettings"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(actionManager.getAction((String)it));
        }
        List actions = (List)destination$iv$iv;
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kubernetes.Executables");
        String string = KubernetesBundle.message("kubectl.not.found.notification.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = KubernetesBundle.message("kubectl.not.found.notification.content", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string, string2, NotificationType.INFORMATION).addActions((Collection)actions);
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addActions(...)");
        Notification notification2 = notification;
        notification2.whenExpired(() -> KubernetesNotificationManager.showKubernetesInstallationNotification$lambda$2(this, notification2));
        Notification notification3 = updated = this.installationNotification.updateAndGet(arg_0 -> KubernetesNotificationManager.showKubernetesInstallationNotification$lambda$3(notification2, arg_0));
        boolean bl = notification3 != null ? !notification3.isExpired() : false;
        if (bl) {
            notification2.notify(this.project);
        }
    }

    private static final void showKubernetesInstallationNotification$lambda$2(KubernetesNotificationManager this$0, Notification $notification) {
        this$0.installationNotification.compareAndSet($notification, null);
    }

    private static final Notification showKubernetesInstallationNotification$lambda$3(Notification $notification, Notification prev) {
        block0: {
            Notification notification = prev;
            if (notification == null) break block0;
            notification.expire();
        }
        return $notification;
    }

    @JvmStatic
    @NotNull
    public static final KubernetesNotificationManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
        return Companion.getInstanceAsync(project, $completion);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087@\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/kubernetes/view/notification/KubernetesNotificationManager;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceAsync", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nKubernetesNotificationManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,103:1\n31#2,2:104\n76#2:106\n*S KotlinDebug\n*F\n+ 1 KubernetesNotificationManager.kt\ncom/intellij/kubernetes/view/notification/KubernetesNotificationManager$Companion\n*L\n36#1:104,2\n39#1:106\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final KubernetesNotificationManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KubernetesNotificationManager> serviceClass$iv = KubernetesNotificationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesNotificationManager)object;
        }

        @JvmStatic
        @Nullable
        public final Object getInstanceAsync(@NotNull Project project, @NotNull Continuation<? super KubernetesNotificationManager> $completion) {
            ComponentManager $this$serviceAsync$iv = (ComponentManager)project;
            boolean $i$f$serviceAsync = false;
            return ServicesKt.serviceAsync((ComponentManager)$this$serviceAsync$iv, KubernetesNotificationManager.class, $completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

