/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes.workloads;

import com.intellij.ide.util.treeView.FileNameComparator;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import javax.swing.SortOrder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a \u0010\u0000\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0003\u0012\u0002\b\u00030\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0014\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a7\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00022\u0006\u0010\t\u001a\u00020\u00072\u0019\u0010\n\u001a\u0015\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u000b\u00a2\u0006\u0002\b\fH\u0002\u001a\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0014\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002\u001a\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u001a\u0014\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0002H\u0002\u00a8\u0006\u0017"}, d2={"getColumnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "addNameField", "", "addStringField", "name", "value", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addImageField", "addRestartCountField", "addReadyStatusField", "addAgeField", "calculateAge", "creationTimestamp", "Ljava/time/OffsetDateTime;", "addContainerIDField", "addStartedField", "addRunningField", "intellij.clouds.kubernetes"})
public final class KubernetesContainerServiceViewDescriptorKt {
    private static final List<KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, ?>> getColumnDescriptors(KubernetesApiModel apiModel2) {
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[]{KubernetesContainerServiceViewDescriptorKt.addNameField(), KubernetesContainerServiceViewDescriptorKt.addImageField(), KubernetesContainerServiceViewDescriptorKt.addRestartCountField(), KubernetesContainerServiceViewDescriptorKt.addReadyStatusField(), KubernetesContainerServiceViewDescriptorKt.addAgeField(), KubernetesContainerServiceViewDescriptorKt.addContainerIDField(), KubernetesContainerServiceViewDescriptorKt.addStartedField(), KubernetesContainerServiceViewDescriptorKt.addRunningField()};
        return CollectionsKt.listOfNotNull((Object[])columnDescriptorArray);
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addNameField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.nameField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addNameField$lambda$0));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addStringField(String name, Function1<? super KubernetesContainerObject, String> value2) {
        return new KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String>(name, Reflection.getOrCreateKotlinClass(String.class), SortOrder.ASCENDING, FileNameComparator.getInstance(), null, null, null, arg_0 -> KubernetesContainerServiceViewDescriptorKt.addStringField$lambda$1(value2, arg_0), 112, null);
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addImageField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Image", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addImageField$lambda$2));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addRestartCountField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.v1container.restart.count", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addRestartCountField$lambda$3));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addReadyStatusField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Ready", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addReadyStatusField$lambda$4));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addAgeField() {
        String string = KubernetesBundle.message("KubernetesResourceMapper.ageField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return KubernetesContainerServiceViewDescriptorKt.addStringField(string, (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addAgeField$lambda$5));
    }

    private static final String calculateAge(OffsetDateTime creationTimestamp) {
        if (creationTimestamp == null) {
            return "Unknown";
        }
        Duration duration = Duration.between(creationTimestamp, OffsetDateTime.now());
        String string = "%dd %dh %dm";
        Object[] objectArray = new Object[]{duration.toDays(), duration.toHours() % (long)24, duration.toMinutes() % (long)60};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addContainerIDField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Container ID", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addContainerIDField$lambda$6));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addStartedField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Started", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addStartedField$lambda$7));
    }

    private static final KubernetesResourceMapper.ColumnDescriptor<KubernetesContainerObject, String> addRunningField() {
        return KubernetesContainerServiceViewDescriptorKt.addStringField("Running", (Function1<? super KubernetesContainerObject, String>)((Function1)KubernetesContainerServiceViewDescriptorKt::addRunningField$lambda$8));
    }

    private static final String addNameField$lambda$0(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return $this$addStringField.getName();
    }

    private static final String addStringField$lambda$1(Function1 $value, KubernetesContainerObject $this$ColumnDescriptor) {
        Intrinsics.checkNotNullParameter((Object)$this$ColumnDescriptor, (String)"$this$ColumnDescriptor");
        String string = (String)$value.invoke((Object)$this$ColumnDescriptor);
        if (string == null) {
            string = "Unknown";
        }
        return string;
    }

    private static final String addImageField$lambda$2(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return $this$addStringField.getImage();
    }

    private static final String addRestartCountField$lambda$3(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.getRestartCount());
    }

    private static final String addReadyStatusField$lambda$4(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.isReady());
    }

    private static final String addAgeField$lambda$5(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        V1ObjectMeta v1ObjectMeta = $this$addStringField.getMetadata();
        return KubernetesContainerServiceViewDescriptorKt.calculateAge(v1ObjectMeta != null ? v1ObjectMeta.getCreationTimestamp() : null);
    }

    private static final String addContainerIDField$lambda$6(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        String string = $this$addStringField.getContainerId();
        if (string == null) {
            string = "Not Available";
        }
        return string;
    }

    private static final String addStartedField$lambda$7(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.getStarted());
    }

    private static final String addRunningField$lambda$8(KubernetesContainerObject $this$addStringField) {
        Intrinsics.checkNotNullParameter((Object)$this$addStringField, (String)"$this$addStringField");
        return String.valueOf($this$addStringField.isRunning());
    }

    public static final /* synthetic */ List access$getColumnDescriptors(KubernetesApiModel apiModel2) {
        return KubernetesContainerServiceViewDescriptorKt.getColumnDescriptors(apiModel2);
    }
}

