/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.nodes;

import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewNonActivatingDescriptor;
import com.intellij.execution.services.ServiceViewToolWindowDescriptor;
import com.intellij.execution.services.SimpleServiceViewDescriptor;
import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.nodes.KubernetesServiceViewContributorKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeletableServiceViewDescriptor;
import com.intellij.kubernetes.view.ui.actions.KubernetesDeleteResourceProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/view/nodes/KubernetesDummyServiceViewNode;", "Lcom/intellij/execution/services/ServiceViewContributor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "<init>", "()V", "getViewDescriptor", "Lcom/intellij/execution/services/ServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getServices", "", "getServiceDescriptor", "service", "ViewDescriptor", "intellij.clouds.kubernetes"})
public final class KubernetesDummyServiceViewNode
implements ServiceViewContributor<SimpleServiceViewDescriptor> {
    @NotNull
    public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new ViewDescriptor(project);
    }

    @NotNull
    public List<SimpleServiceViewDescriptor> getServices(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CollectionsKt.emptyList();
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull SimpleServiceViewDescriptor service) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        throw new UnsupportedOperationException();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/view/nodes/KubernetesDummyServiceViewNode$ViewDescriptor;", "Lcom/intellij/execution/services/SimpleServiceViewDescriptor;", "Lcom/intellij/execution/services/ServiceViewNonActivatingDescriptor;", "Lcom/intellij/execution/services/ServiceViewToolWindowDescriptor;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesDeletableServiceViewDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/kubernetes/view/nodes/KubernetesDummyServiceViewNode;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getDataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "getRemover", "Ljava/lang/Runnable;", "getToolWindowId", "", "getToolWindowIcon", "Ljavax/swing/Icon;", "getStripeTitle", "getToolbarActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "deletableName", "getDeletableName", "()Ljava/lang/String;", "handleDoubleClick", "", "event", "Ljava/awt/event/MouseEvent;", "intellij.clouds.kubernetes"})
    public final class ViewDescriptor
    extends SimpleServiceViewDescriptor
    implements ServiceViewNonActivatingDescriptor,
    ServiceViewToolWindowDescriptor,
    KubernetesDeletableServiceViewDescriptor {
        @NotNull
        private final Project project;

        public ViewDescriptor(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(KubernetesBundle.message("KubernetesServiceViewContributor.Descriptor.name", new Object[0]), KubernetesIcons.Kubernetes_Y, "Kubernetes");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public DataProvider getDataProvider() {
            return KubernetesDeleteResourceProvider.dataProvider;
        }

        @NotNull
        public Runnable getRemover() {
            return () -> ViewDescriptor.getRemover$lambda$0(this, KubernetesDummyServiceViewNode.this);
        }

        @NotNull
        public String getToolWindowId() {
            String string = this.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            return string;
        }

        @NotNull
        public Icon getToolWindowIcon() {
            Icon icon = KubernetesIcons.ToolWindowKubernetes;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ToolWindowKubernetes");
            return icon;
        }

        @NotNull
        public String getStripeTitle() {
            String string = this.getPresentation().getPresentableText();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        @NotNull
        public ActionGroup getToolbarActions() {
            AnAction anAction = ActionManager.getInstance().getAction("Kubernetes.ClusterNodeActions");
            Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
            return (ActionGroup)((DefaultActionGroup)anAction);
        }

        @Override
        @NotNull
        public String getDeletableName() {
            String string = this.getPresentation().getPresentableText();
            if (string == null) {
                String string2 = KubernetesBundle.message("KubernetesServiceViewContributor.Descriptor.name", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
            return string;
        }

        public boolean handleDoubleClick(@NotNull MouseEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            AnAction addContextsAction = ActionManager.getInstance().getAction("Kubernetes.AddContexts");
            AnAction[] anActionArray = new AnAction[]{addContextsAction};
            ActionPopupMenu actionPopupMenu = ActionManager.getInstance().createActionPopupMenu("KubernetesDummyServiceViewNode", (ActionGroup)new DefaultActionGroup(anActionArray));
            Intrinsics.checkNotNullExpressionValue((Object)actionPopupMenu, (String)"createActionPopupMenu(...)");
            ActionPopupMenu popupMenu = actionPopupMenu;
            popupMenu.getComponent().show(event2.getComponent(), event2.getX(), event2.getY());
            return true;
        }

        private static final void getRemover$lambda$0(ViewDescriptor this$0, KubernetesDummyServiceViewNode this$1) {
            AdvancedSettings.Companion.setBoolean("kubernetes.show.empty.node", false);
            KubernetesServiceViewContributorKt.fireKubernetesServiceChanged(this$0.project, ServiceEventListener.EventType.SERVICE_REMOVED, this$1);
        }
    }
}

