/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.ui.FilePositionHyperlinkInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0004H\u0000\"\u001e\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u0012\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/kubernetes/helm/chart/Chart;", "filePath", "", "extractSubdirectoryFileHyperlinks", "", "Lcom/intellij/kubernetes/ui/FilePositionHyperlinkInfo;", "text", "genericFileNameAndPositionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getGenericFileNameAndPositionPattern$annotations", "()V", "Ljava/util/regex/Pattern;", "intellij.clouds.kubernetes"})
public final class HelmConsoleUtilKt {
    private static final Pattern genericFileNameAndPositionPattern = Pattern.compile("[^\\/\\w\\.\\+\\-](((([\\w\\.\\+\\-]+)\\/)*([\\w\\.\\+\\-]+\\.[\\w]+))(:((\\d+)(:(\\d+))?))?)[^\\/\\w\\.\\+\\-]");

    @Nullable
    public static final VirtualFile findFile(@NotNull Chart $this$findFile, @NotNull String filePath) {
        String relPathForChart;
        Intrinsics.checkNotNullParameter((Object)$this$findFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        VirtualFile file = null;
        String string = $this$findFile.getBaseDir().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String baseDirName = string;
        if (StringsKt.startsWith$default((String)filePath, (String)(baseDirName + "/"), (boolean)false, (int)2, null)) {
            String string2 = StringUtil.trimStart((String)filePath, (String)(baseDirName + "/"));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trimStart(...)");
            relPathForChart = string2;
            file = $this$findFile.getBaseDir().findFileByRelativePath(relPathForChart);
        }
        if (file == null) {
            if (StringsKt.startsWith$default((String)filePath, (String)($this$findFile.getName() + "/"), (boolean)false, (int)2, null)) {
                String string3 = StringUtil.trimStart((String)filePath, (String)($this$findFile.getName() + "/"));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trimStart(...)");
                relPathForChart = string3;
                file = $this$findFile.findFileByRelativeAbstractPath(relPathForChart);
            } else {
                file = $this$findFile.findFileByRelativeAbstractPath(filePath);
            }
        }
        return file;
    }

    @NotNull
    public static final Collection<FilePositionHyperlinkInfo> extractSubdirectoryFileHyperlinks(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List result2 = new ArrayList();
        Matcher templateFileMatcher = genericFileNameAndPositionPattern.matcher(text);
        while (templateFileMatcher.find()) {
            MatchResult matchResult = templateFileMatcher.toMatchResult();
            String path = matchResult.group(2);
            Object object = matchResult.group(8);
            Integer row = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? Integer.valueOf((Integer)object - 1) : null;
            Object object2 = matchResult.group(10);
            Integer col = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? Integer.valueOf((Integer)object2 - 1) : null;
            int startPosition = matchResult.start(1);
            int endPosition = matchResult.end(1);
            Intrinsics.checkNotNull((Object)path);
            result2.add(new FilePositionHyperlinkInfo(path, row, col, startPosition, endPosition - startPosition));
        }
        return result2;
    }

    private static /* synthetic */ void getGenericFileNameAndPositionPattern$annotations() {
    }
}

