/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.telepresence.TelepresenceCreateInterceptionAction;
import com.intellij.kubernetes.telepresence.TelepresenceInterceptOptions;
import com.intellij.kubernetes.view.ui.ComponentsKt;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.ui.TextFieldWithStoredHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ui.UI;
import io.kubernetes.client.common.KubernetesObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0014J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0006\u0010\u0019\u001a\u00020\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u000eH\u0002R\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "availableServices", "", "Lio/kubernetes/client/common/KubernetesObject;", "<init>", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;Ljava/util/List;)V", "services", "Lcom/intellij/openapi/ui/ComboBox;", "getServices", "()Lcom/intellij/openapi/ui/ComboBox;", "ports", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "otherOptions", "createCenterPanel", "Ljavax/swing/JComponent;", "doValidate", "Lcom/intellij/openapi/ui/ValidationInfo;", "getPreferredFocusedComponent", "currentOptions", "Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptOptions;", "getCurrentOptions", "()Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptOptions;", "storeAndGetSelectedOptions", "addCurrentTextToHistoryAsFirst", "", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nTelepresenceCreateInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,220:1\n52#2:221\n*S KotlinDebug\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog\n*L\n84#1:221\n*E\n"})
public final class TelepresenceInterceptionDialog
extends DialogWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ComboBox<KubernetesObject> services;
    @NotNull
    private final TextFieldWithStoredHistory ports;
    @NotNull
    private final TextFieldWithStoredHistory otherOptions;
    @NotNull
    private static final Regex SPLITTER = new Regex("[,\\s]+");

    public TelepresenceInterceptionDialog(@NotNull KubernetesApiModel apiModel2, @NotNull List<? extends KubernetesObject> availableServices) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter(availableServices, (String)"availableServices");
        super(apiModel2.getProject());
        this.ports = new TextFieldWithStoredHistory(TelepresenceInterceptionDialog.Companion.qualifiedPropertyName("ports"));
        this.otherOptions = new TextFieldWithStoredHistory(TelepresenceInterceptionDialog.Companion.qualifiedPropertyName("otherOptions"));
        this.services = !((Collection)availableServices).isEmpty() ? ComponentsKt.kubernetesObjectCombox$default(availableServices, null, 2, null) : null;
        TelepresenceInterceptionDialog.Companion.initFieldWithStoredHistory(this.ports, true, 40);
        TelepresenceInterceptionDialog.Companion.initFieldWithStoredHistory(this.otherOptions, false, 60);
        this.setTitle(KubernetesBundle.message("TelepresenceInterceptionDialog.dialog.title.telepresence.intercept.options", new Object[0]));
        this.setOKButtonText(KubernetesBundle.message("TelepresenceInterceptionDialog.button.telepresence.intercept", new Object[0]));
        this.init();
    }

    @Nullable
    public final ComboBox<KubernetesObject> getServices() {
        return this.services;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        PanelGridBuilder panelGridBuilder;
        PanelGridBuilder panelGridBuilder2 = UI.PanelFactory.grid();
        boolean condition$iv = this.services != null;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$applyIf$iv;
            void $this$createCenterPanel_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            panelGridBuilder = $this$createCenterPanel_u24lambda_u240.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.services)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.service", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.label.text.select.service.to.intercept", new Object[0])));
        } else {
            panelGridBuilder = panelGridBuilder2;
        }
        JPanel jPanel = panelGridBuilder.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.ports)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.ports", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.text.specify.ports.to.intercept.html", new Object[0]))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)((JComponent)this.otherOptions)).withLabel(KubernetesBundle.message("TelepresenceInterceptionDialog.label.telepresence.advanced.options", new Object[0])).withComment(KubernetesBundle.message("TelepresenceInterceptionDialog.text.specify.additional.options.for.telepresence.html", new Object[0]))).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createPanel(...)");
        return jPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.getCurrentOptions().isEmpty() ? new ValidationInfo(KubernetesBundle.message("TelepresenceInterceptionDialog.dialog.message.specify.ports.to.intercept", new Object[0]), (JComponent)this.ports) : null;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.ports;
    }

    private final TelepresenceInterceptOptions getCurrentOptions() {
        List portValues = TelepresenceInterceptionDialog.Companion.splitText(this.ports);
        List options = TelepresenceInterceptionDialog.Companion.splitText(this.otherOptions);
        return new TelepresenceInterceptOptions(portValues, options);
    }

    @NotNull
    public final TelepresenceInterceptOptions storeAndGetSelectedOptions() {
        TelepresenceInterceptOptions telepresenceInterceptOptions;
        TelepresenceInterceptOptions it = telepresenceInterceptOptions = this.getCurrentOptions();
        boolean bl = false;
        if (!((Collection)it.getPorts()).isEmpty()) {
            String string = this.ports.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.ports.setText(((Object)StringsKt.trim((CharSequence)string)).toString());
            this.addCurrentTextToHistoryAsFirst(this.ports);
        }
        if (!((Collection)it.getOptions()).isEmpty()) {
            String string = this.otherOptions.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.otherOptions.setText(((Object)StringsKt.trim((CharSequence)string)).toString());
            this.addCurrentTextToHistoryAsFirst(this.otherOptions);
        }
        return telepresenceInterceptOptions;
    }

    private final void addCurrentTextToHistoryAsFirst(TextFieldWithStoredHistory $this$addCurrentTextToHistoryAsFirst) {
        List historyCopy = $this$addCurrentTextToHistoryAsFirst.getHistory();
        if (historyCopy.remove($this$addCurrentTextToHistoryAsFirst.getText())) {
            $this$addCurrentTextToHistoryAsFirst.setHistory(historyCopy);
        }
        $this$addCurrentTextToHistoryAsFirst.addCurrentTextToHistory();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0012\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\fH\u0002J\u001e\u0010\r\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion;", "", "<init>", "()V", "SPLITTER", "Lkotlin/text/Regex;", "splitText", "", "", "splitText$intellij_clouds_kubernetes", "qualifiedPropertyName", "suffix", "Lcom/intellij/ui/TextFieldWithStoredHistory;", "initFieldWithStoredHistory", "", "selectFirstFromHistory", "", "columnsCount", "", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nTelepresenceCreateInterceptionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n774#2:221\n865#2,2:222\n1#3:224\n*S KotlinDebug\n*F\n+ 1 TelepresenceCreateInterceptionAction.kt\ncom/intellij/kubernetes/telepresence/TelepresenceInterceptionDialog$Companion\n*L\n139#1:221\n139#1:222,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> splitText$intellij_clouds_kubernetes(@NotNull String $this$splitText) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$splitText, (String)"<this>");
            CharSequence charSequence = $this$splitText;
            Regex regex = SPLITTER;
            int n = 0;
            Iterable $this$filter$iv = regex.split(charSequence, n);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final String qualifiedPropertyName(String suffix) {
            return Reflection.getOrCreateKotlinClass(TelepresenceCreateInterceptionAction.class).getQualifiedName() + "." + suffix;
        }

        private final List<String> splitText(TextFieldWithStoredHistory $this$splitText) {
            String string = $this$splitText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this.splitText$intellij_clouds_kubernetes(string);
        }

        private final void initFieldWithStoredHistory(TextFieldWithStoredHistory $this$initFieldWithStoredHistory, boolean selectFirstFromHistory, int columnsCount) {
            block1: {
                $this$initFieldWithStoredHistory.setEditor((ComboBoxEditor)new BasicComboBoxEditor(columnsCount){
                    final /* synthetic */ int $columnsCount;
                    {
                        this.$columnsCount = $columnsCount;
                    }

                    protected JTextField createEditorComponent() {
                        ExpandableTextField expandableTextField = new ExpandableTextField();
                        int n = this.$columnsCount;
                        ExpandableTextField $this$createEditorComponent_u24lambda_u240 = expandableTextField;
                        boolean bl = false;
                        $this$createEditorComponent_u24lambda_u240.setBorder(null);
                        $this$createEditorComponent_u24lambda_u240.setColumns(n);
                        return (JTextField)expandableTextField;
                    }
                });
                $this$initFieldWithStoredHistory.setHistorySize(-1);
                $this$initFieldWithStoredHistory.reset();
                if (!selectFirstFromHistory) break block1;
                List list2 = $this$initFieldWithStoredHistory.getHistory();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getHistory(...)");
                String string = (String)CollectionsKt.firstOrNull((List)list2);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    $this$initFieldWithStoredHistory.setSelectedItem((Object)it);
                }
            }
        }

        static /* synthetic */ void initFieldWithStoredHistory$default(Companion companion, TextFieldWithStoredHistory textFieldWithStoredHistory, boolean bl, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 40;
            }
            companion.initFieldWithStoredHistory(textFieldWithStoredHistory, bl, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

