/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.telepresence;

import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.install.ArchDistribution;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.FailedInstallation;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.OSDistribution;
import com.intellij.kubernetes.telepresence.TelepresenceInstallActionKt;
import com.intellij.kubernetes.telepresence.TelepresenceModel;
import com.intellij.kubernetes.view.notification.KubernetesNotificationManager;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.system.CpuArch;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0001\u001a\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0080@\u00a2\u0006\u0002\u0010\b\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"downloadAndInstallTelepresenceInteractive", "", "project", "Lcom/intellij/openapi/project/Project;", "asUpgrade", "", "downloadAndInstallTelepresence", "Lcom/intellij/kubernetes/install/InstallationResult;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "telepresenceInstallVersion", "", "distributions", "", "Lcom/intellij/kubernetes/install/OSDistribution;", "intellij.clouds.kubernetes"})
public final class TelepresenceInstallActionKt {
    @NotNull
    private static final String telepresenceInstallVersion = Registry.Companion.stringValue("kubernetes.telepresence.install.version");
    @NotNull
    private static final Map<String, OSDistribution> distributions;

    @RequiresEdt
    public static final void downloadAndInstallTelepresenceInteractive(@NotNull Project project, boolean asUpgrade) {
        OSDistribution osDistribution;
        OkCancelDialogBuilder okCancelDialogBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(project, (Object)"telepresence-install");
        if (SystemInfoRt.isWindows) {
            String windowsDownloadUrl = "https://www.telepresence.io/docs/latest/quick-start/?os=windows";
            Object[] objectArray = new Object[]{windowsDownloadUrl};
            Messages.showInfoMessage((String)KubernetesBundle.message("dialog.Telepresence.install.suggest.win", objectArray), (String)KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]));
            return;
        }
        if (asUpgrade) {
            String string = KubernetesBundle.message("dialog.Telepresence.install.telepresence.upgrade", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{TelepresenceModel.Companion.getMINIMAL_REQUIRED_VERSION(), telepresenceInstallVersion};
            String string2 = KubernetesBundle.message("dialog.Telepresence.install.suggest.upgrade", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string2);
        } else {
            String string = KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string3 = KubernetesBundle.message("dialog.Telepresence.install.suggest", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            okCancelDialogBuilder = MessageDialogBuilder.Companion.okCancel(string, string3);
        }
        OkCancelDialogBuilder dialog2 = okCancelDialogBuilder;
        String string = LangBundle.message((String)"button.install", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        if (!((OkCancelDialogBuilder)dialog2.yesText(string)).ask(project)) {
            return;
        }
        OSDistribution oSDistribution = SystemInfoRt.isMac ? distributions.get("darwin") : (osDistribution = SystemInfoRt.isLinux ? distributions.get("linux") : null);
        if (osDistribution == null) {
            KubernetesNotificationManager.Companion.getInstance(project).reportRequestError(new IllegalStateException("Unable to find Telepresence distribution for platform: " + SystemInfoRt.OS_NAME));
            return;
        }
        ArchDistribution archDistribution = CpuArch.isArm64() ? osDistribution.getArm64() : osDistribution.getAmd64();
        String downloadUrl = archDistribution.getUrl();
        BinaryInstaller.Companion.create(project).withBinaryName((Function0<String>)((Function0)TelepresenceInstallActionKt::downloadAndInstallTelepresenceInteractive$lambda$0)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)arg_0 -> TelepresenceInstallActionKt.downloadAndInstallTelepresenceInteractive$lambda$1(downloadUrl, arg_0))).install();
    }

    public static /* synthetic */ void downloadAndInstallTelepresenceInteractive$default(Project project, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        TelepresenceInstallActionKt.downloadAndInstallTelepresenceInteractive(project, bl);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object downloadAndInstallTelepresence(@NotNull Project var0, @NotNull Continuation<? super InstallationResult> $completion) {
        block11: {
            if (!($completion instanceof downloadAndInstallTelepresence.1)) ** GOTO lbl-1000
            var6_2 = $completion;
            if ((var6_2.label & -2147483648) != 0) {
                var6_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl($completion){
                    /* synthetic */ Object result;
                    int label;

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return TelepresenceInstallActionKt.downloadAndInstallTelepresence(null, (Continuation<? super InstallationResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    KubernetesUsageTriggerCollector.INSTANCE.getTELEPRESENCE_ACTION_TRIGGERED_EVENT().log(project, (Object)"telepresence-install");
                    if (!SystemInfoRt.isWindows) break;
                    windowsDownloadUrl = "https://www.telepresence.io/docs/latest/quick-start/?os=windows";
                    $continuation.label = 1;
                    v0 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(windowsDownloadUrl, null){
                        int label;
                        final /* synthetic */ String $windowsDownloadUrl;
                        {
                            this.$windowsDownloadUrl = $windowsDownloadUrl;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object object) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    Object[] objectArray = new Object[]{this.$windowsDownloadUrl};
                                    Messages.showInfoMessage((String)KubernetesBundle.message("dialog.Telepresence.install.suggest.win", objectArray), (String)KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]));
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v0 == var7_4) {
                        return var7_4;
                    }
                    ** GOTO lbl23
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl23:
                    // 2 sources

                    return new FailedInstallation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$2(), ()Ljava/lang/String;)());
                }
            }
            v1 = SystemInfoRt.isMac != false ? TelepresenceInstallActionKt.distributions.get("darwin") : (osDistribution = SystemInfoRt.isLinux != false ? TelepresenceInstallActionKt.distributions.get("linux") : null);
            if (osDistribution != null) break block11;
            $continuation.label = 2;
            v2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
                int label;
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            KubernetesNotificationManager.Companion.getInstance(this.$project).reportRequestError(new IllegalStateException("Unable to find Telepresence distribution for platform: " + SystemInfoRt.OS_NAME));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (Continuation)$continuation);
            if (v2 == var7_4) {
                return var7_4;
            }
            ** GOTO lbl34
            {
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl34:
                    // 2 sources

                    return new FailedInstallation((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$3(), ()Ljava/lang/String;)());
                }
            }
        }
        archDistribution = CpuArch.isArm64() != false ? osDistribution.getArm64() : osDistribution.getAmd64();
        downloadUrl = archDistribution.getUrl();
        $continuation.label = 3;
        v3 = BinaryInstaller.Companion.create(project).withBinaryName((Function0<String>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$4(), ()Ljava/lang/String;)()).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, downloadAndInstallTelepresence$lambda$5(java.lang.String com.intellij.kubernetes.install.BinaryInstaller$Configuration ), (Lcom/intellij/kubernetes/install/BinaryInstaller$Configuration;)Ljava/lang/String;)((String)downloadUrl)).installSuspend((Continuation<? super InstallationResult>)$continuation);
        if (v3 == var7_4) {
            return var7_4;
        }
        ** GOTO lbl46
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl46:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final String downloadAndInstallTelepresenceInteractive$lambda$0() {
        return SystemInfoRt.isWindows ? "telepresence.exe" : "telepresence";
    }

    private static final String downloadAndInstallTelepresenceInteractive$lambda$1(String $downloadUrl, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $downloadUrl;
    }

    private static final String downloadAndInstallTelepresence$lambda$2() {
        return KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
    }

    private static final String downloadAndInstallTelepresence$lambda$3() {
        return KubernetesBundle.message("dialog.Telepresence.install.telepresence.not.installed", new Object[0]);
    }

    private static final String downloadAndInstallTelepresence$lambda$4() {
        return SystemInfoRt.isWindows ? "telepresence.exe" : "telepresence";
    }

    private static final String downloadAndInstallTelepresence$lambda$5(String $downloadUrl, BinaryInstaller.Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $downloadUrl;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"darwin", (Object)new OSDistribution(new ArchDistribution(Registry.Companion.stringValue("kubernetes.telepresence.download.link.for.macos.amd64"), ""), new ArchDistribution(Registry.Companion.stringValue("kubernetes.telepresence.download.link.for.macos.arm64"), ""))), TuplesKt.to((Object)"linux", (Object)new OSDistribution(new ArchDistribution(Registry.Companion.stringValue("kubernetes.telepresence.download.link.for.linux.amd64"), ""), new ArchDistribution(Registry.Companion.stringValue("kubernetes.telepresence.download.link.for.linux.amd64"), "")))};
        distributions = MapsKt.mapOf((Pair[])pairArray);
    }
}

