/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.GenericFileReferenceType;
import com.intellij.kubernetes.model.KustomizePatchStrategicMergeReferenceMarker;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/model/KustomizePatchStrategicMergeOrJsonReferenceType;", "Lcom/intellij/kubernetes/model/GenericFileReferenceType;", "Lcom/intellij/kubernetes/model/KustomizePatchStrategicMergeReferenceMarker;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "getFileFilter", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiFileSystemItem;", "element", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "validateScalarValue", "", "scalarValue", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKustomizeDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KustomizeDefinitions.kt\ncom/intellij/kubernetes/model/KustomizePatchStrategicMergeOrJsonReferenceType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,272:1\n1#2:273\n*E\n"})
public final class KustomizePatchStrategicMergeOrJsonReferenceType
extends GenericFileReferenceType
implements KustomizePatchStrategicMergeReferenceMarker {
    public KustomizePatchStrategicMergeOrJsonReferenceType(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName, specInfo);
    }

    @Override
    @NotNull
    protected Condition<PsiFileSystemItem> getFileFilter(@NotNull YAMLScalar element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return KustomizePatchStrategicMergeOrJsonReferenceType::getFileFilter$lambda$0;
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        PsiFile targetFile;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        PsiManager psiManager = PsiManager.getInstance((Project)scalarValue.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)scalarValue);
        if (virtualFile != null && (virtualFile = virtualFile.getParent()) != null && (virtualFile = virtualFile.findFileByRelativePath(YamlUtilKt.getEffectiveText((YAMLValue)scalarValue))) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            v2 = psiManager2.findFile(it);
        } else {
            v2 = targetFile = null;
        }
        if (!KubernetesUtilKt.isNonKustomizationK8sFile((PsiFileSystemItem)targetFile) && !KubernetesUtilKt.isJsonOrNonK8sFile(targetFile)) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("KubernetesModelDefinition.yaml.k8sResourceOrJsonPatch.expected.error", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    private static final boolean getFileFilter$lambda$0(PsiFileSystemItem it) {
        return KubernetesUtilKt.isNonKustomizationK8sFile(it) || KubernetesUtilKt.isJsonOrNonK8sFile(it instanceof PsiFile ? (PsiFile)it : null);
    }
}

