/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesConfigurationUtilKt;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.model.FindAndApplyMatchingCrdQuickFix;
import com.intellij.kubernetes.model.KubernetesEditabilityValidator;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesResourceDefinitionsKt;
import com.intellij.kubernetes.model.KubernetesUnknownResourceValidator;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.ui.intentions.MarkAsNonK8sFileModCommandAction;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/model/KubernetesApiVersionType;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "Lcom/intellij/kubernetes/model/KubernetesEditabilityValidator;", "Lcom/intellij/kubernetes/model/KubernetesUnknownResourceValidator;", "<init>", "()V", "getResourceIdentity", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "insertedScalar", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "checkReadOnly", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "checkKnown", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesResourceDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/KubernetesApiVersionType\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,447:1\n19#2:448\n19#2:449\n19#2:472\n1#3:450\n1557#4:451\n1628#4,3:452\n1557#4:455\n1628#4,3:456\n1557#4:459\n1628#4,3:460\n1557#4:463\n1628#4,3:464\n129#5:467\n37#6:468\n36#6,3:469\n*S KotlinDebug\n*F\n+ 1 KubernetesResourceDefinitions.kt\ncom/intellij/kubernetes/model/KubernetesApiVersionType\n*L\n99#1:448\n101#1:449\n121#1:472\n113#1:451\n113#1:452,3\n115#1:455\n115#1:456,3\n117#1:459\n117#1:460,3\n131#1:463\n131#1:464,3\n164#1:467\n165#1:468\n165#1:469,3\n*E\n"})
public final class KubernetesApiVersionType
extends YamlScalarType
implements KubernetesEditabilityValidator,
KubernetesUnknownResourceValidator {
    @NotNull
    public static final KubernetesApiVersionType INSTANCE = new KubernetesApiVersionType();

    private KubernetesApiVersionType() {
        super("string");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public ResourceIdentity getResourceIdentity(@NotNull YAMLScalar scalarValue) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        v0 = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getTextValue(...)");
        apiVersion = v0;
        $this$asSafely$iv = scalarValue.getParent();
        $i$f$asSafely = false;
        v1 = $this$asSafely$iv;
        if (!(v1 instanceof YAMLKeyValue)) {
            v1 = null;
        }
        if ((var4_7 /* !! */  = (YAMLKeyValue)v1) == null || ($this$asSafely$iv = var4_7 /* !! */ .getParentMapping()) == null || ($i$f$asSafely = YamlUtilKt.getKeyValueByKeyIgnoreSpaces((YAMLMapping)$this$asSafely$iv, "kind")) == null || (var7_8 = $i$f$asSafely.getValue()) == null) ** GOTO lbl-1000
        var9_9 /* !! */  = var7_8;
        $i$f$asSafely = false;
        v2 = $this$asSafely$iv;
        if (!(v2 instanceof YAMLScalar)) {
            v2 = null;
        }
        if ((var8_11 = (YAMLScalar)v2) != null && (var9_9 /* !! */  = var8_11.getTextValue()) != null) {
            v3 = var9_9 /* !! */ ;
        } else lbl-1000:
        // 2 sources

        {
            v3 = "";
        }
        kind = v3;
        it /* !! */  = var4_7 /* !! */  = ResourceIdentity.Companion.create(apiVersion, kind);
        $i$a$-takeIf-KubernetesApiVersionType$getResourceIdentity$1 = false;
        return Intrinsics.areEqual((Object)it /* !! */ , (Object)ResourceIdentity.Companion.getUNDEFINED()) == false != false ? var4_7 /* !! */  : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar insertedScalar, @Nullable CompletionContext completionContext) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)insertedScalar, (String)"insertedScalar");
        Project project = insertedScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CompletionContext completionContext2 = completionContext;
        if ((completionContext2 != null ? completionContext2.getCompletionType() : null) == CompletionType.SMART) {
            Pair it;
            Iterable $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            ArrayList resourceIdVsFile = KubernetesResourceDefinitionsKt.access$getNotConfiguredCustomResourceDefinitions(project2);
            UniqueVFilePathBuilder uniqueVFilePathBuilder = UniqueVFilePathBuilder.getInstance();
            Iterable iterable = resourceIdVsFile;
            Object object = project2;
            boolean $i$f$map = false;
            void var10_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((VirtualFile)it.getSecond());
            }
            GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)object, (Collection)((List)destination$iv$iv));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
            GlobalSearchScope searchScope = globalSearchScope;
            $this$map$iv = resourceIdVsFile;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(new Pair((Object)((ResourceIdentity)it.getFirst()).getApiVersion(), it.getSecond()));
            }
            List apiVersionVsFile = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            $this$map$iv = apiVersionVsFile;
            $i$f$map = false;
            $this$mapTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                it = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add(LookupElementBuilder.create((Object)it, (String)((String)it.getFirst())).withTypeText(uniqueVFilePathBuilder.getUniqueVirtualFilePath(project2, (VirtualFile)it.getSecond(), searchScope)).withInsertHandler(KubernetesApiVersionType::getValueLookups$lambda$6$lambda$5).withAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE));
            }
            return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
        Iterable $this$map$iv = KubernetesUtilKt.getK8sModel(project2).getEditableFullApiVersions();
        boolean $i$f$map = false;
        Iterable searchScope = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String destination$iv$iv2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LookupElementBuilder.create((String)p0));
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @Override
    public void checkReadOnly(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
        String apiVersion = string;
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesModel model2 = KubernetesUtilKt.getK8sModel(project);
        if (model2.getNonEditableFullApiVersions().contains(apiVersion)) {
            Object[] objectArray = new Object[]{apiVersion};
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("NonEditableResourcesInspection.noneditable.apiVersion", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @Override
    public void checkKnown(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
        String apiVersion = string;
        Project project = scalarValue.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesModel model2 = KubernetesUtilKt.getK8sModel(project);
        if (!model2.getFullApiVersions().contains(apiVersion)) {
            TextRange textRange;
            Object v2;
            Object[] objectArray;
            String apiGroupPrefix;
            ResourceIdentity apiVersionParsed;
            block4: {
                apiVersionParsed = ResourceIdentity.Companion.createUnknown(apiVersion);
                apiGroupPrefix = apiVersionParsed.getGroup() + "/";
                objectArray = (Object[])model2.getFullApiVersions();
                for (Object t : objectArray) {
                    String it = (String)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith$default((String)it, (String)apiGroupPrefix, (boolean)false, (int)2, null)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            boolean groupExists = v2 != null;
            objectArray = new LocalQuickFix[]{new FindAndApplyMatchingCrdQuickFix(scalarValue), LocalQuickFix.from((ModCommandAction)((ModCommandAction)new MarkAsNonK8sFileModCommandAction()))};
            List quickFixes = CollectionsKt.listOfNotNull((Object[])objectArray);
            ProblemsHolder problemsHolder = holder;
            PsiElement psiElement = (PsiElement)scalarValue;
            String string2 = KubernetesBundle.message("KubernetesApiVersionType.validation.unknown.api.version", new Object[0]);
            ProblemHighlightType problemHighlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            boolean condition$iv = groupExists && ((CharSequence)apiVersionParsed.getVersion()).length() > 0;
            boolean $i$f$doIf = false;
            if (condition$iv) {
                ProblemHighlightType problemHighlightType2 = problemHighlightType;
                String string3 = string2;
                PsiElement psiElement2 = psiElement;
                ProblemsHolder problemsHolder2 = problemsHolder;
                boolean bl = false;
                TextRange textRange2 = new TextRange(apiGroupPrefix.length(), scalarValue.getTextLength());
                problemsHolder = problemsHolder2;
                psiElement = psiElement2;
                string2 = string3;
                problemHighlightType = problemHighlightType2;
                textRange = textRange2;
            } else {
                textRange = null;
            }
            Collection $this$toTypedArray$iv = quickFixes;
            boolean bl = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
            problemsHolder.registerProblem(psiElement, string2, problemHighlightType, textRange, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }

    private static final Unit getValueLookups$lambda$6$lambda$5$lambda$4$lambda$3(InsertionContext $context, VirtualFile $this_apply) {
        Project project = $context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KubernetesConfigurationUtilKt.addCrdSpecToProjectConfiguration(project, $this_apply);
        return Unit.INSTANCE;
    }

    private static final void getValueLookups$lambda$6$lambda$5(InsertionContext context2, LookupElement item) {
        block1: {
            Pair pair;
            Pair pair2;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            Object $this$asSafely$iv = item.getObject();
            boolean $i$f$asSafely = false;
            Object object = $this$asSafely$iv;
            if (!(object instanceof Pair)) {
                object = null;
            }
            if ((pair2 = (Pair)object) == null || (pair2 = (VirtualFile)pair2.getSecond()) == null) break block1;
            Pair $this$getValueLookups_u24lambda_u246_u24lambda_u245_u24lambda_u244 = pair = pair2;
            boolean bl = false;
            ActionsKt.invokeLater$default(null, () -> KubernetesApiVersionType.getValueLookups$lambda$6$lambda$5$lambda$4$lambda$3(context2, (VirtualFile)$this$getValueLookups_u24lambda_u246_u24lambda_u245_u24lambda_u244), (int)1, null);
        }
    }
}

